/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.cheatsheet.dialog;

import com.ibm.etools.struts.StrutsPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SelectWebDiagramContentProvider
implements ITreeContentProvider {
    private IFile[] webDiagrams;
    private IProject[] validProjects;

    public void dispose() {
    }

    private void findWebDiagram(IResource resource, ArrayList list) {
        if (resource.isAccessible()) {
            switch (resource.getType()) {
                case 1: {
                    String ext = ((IFile)resource).getFileExtension();
                    if (ext == null || !ext.equalsIgnoreCase("gph")) break;
                    list.add(resource);
                    break;
                }
                case 2: 
                case 4: {
                    IContainer container = (IContainer)resource;
                    try {
                        IResource[] members = container.members();
                        int i = 0;
                        while (i < members.length) {
                            this.findWebDiagram(members[i], list);
                            ++i;
                        }
                        break;
                    }
                    catch (CoreException e) {
                        StrutsPlugin.getLogger().log((Throwable)e);
                    }
                }
            }
        }
    }

    private IFile[] getAllWebDiagrams() {
        if (this.webDiagrams != null) {
            return this.webDiagrams;
        }
        IProject[] projects = this.getValidProjects();
        ArrayList list = new ArrayList();
        int i = 0;
        while (i < projects.length) {
            this.findWebDiagram((IResource)projects[i], list);
            ++i;
        }
        this.webDiagrams = list.toArray(new IFile[list.size()]);
        return this.webDiagrams;
    }

    private IResource getChildForParent(IContainer parentElement, IFile diagram) {
        IFile resource = diagram;
        IContainer parent = resource.getParent();
        while (parent != null) {
            if (parent.equals((Object)parentElement)) {
                return resource;
            }
            resource = parent;
            parent = resource.getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        IFile[] diagrams;
        if (parentElement instanceof IContainer && (diagrams = this.getAllWebDiagrams()) != null) {
            HashSet<IResource> set = new HashSet<IResource>();
            int i = 0;
            while (i < diagrams.length) {
                IResource childResource = this.getChildForParent((IContainer)parentElement, diagrams[i]);
                if (childResource != null) {
                    set.add(childResource);
                }
                ++i;
            }
            return set.toArray();
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        Object[] projects;
        if (inputElement instanceof IWorkspaceRoot && (projects = this.getValidProjects()) != null) {
            return projects;
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    private IProject[] getValidProjects() {
        if (this.validProjects != null) {
            return this.validProjects;
        }
        IVirtualComponent[] components = ComponentUtilities.getAllWorkbenchComponents();
        ArrayList<IProject> list = null;
        if (components != null && components.length != 0) {
            list = new ArrayList<IProject>();
            int i = 0;
            while (i < components.length) {
                IVirtualComponent component = components[i];
                try {
                    if (WebArtifactEdit.isValidWebModule((IVirtualComponent)component)) {
                        IProject project = component.getProject();
                        list.add(project);
                    }
                }
                catch (UnresolveableURIException unresolveableURIException) {}
                ++i;
            }
        }
        this.validProjects = list == null ? new IProject[]{} : list.toArray(new IProject[list.size()]);
        return this.validProjects;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.webDiagrams = null;
    }
}

