/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.cheatsheet.dialog;

import com.ibm.etools.struts.cheatsheet.StrutsCheatSheetContextManager;
import com.ibm.etools.struts.cheatsheet.StrutsCheatSheetResourceConstants;
import com.ibm.etools.struts.cheatsheet.dialog.SelectProjectListContentProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectProjectContextDialog
extends Dialog
implements ISelectionChangedListener {
    public static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 2000,2002\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IProject selection;
    private TreeViewer treeViewer;
    protected ITreeContentProvider contentProvider;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private int internalReturnCode;

    public SelectProjectContextDialog(Shell parent) {
        super(parent);
        this.setBlockOnOpen(true);
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.setInternalReturnCode(1);
        this.close();
    }

    protected ITreeContentProvider createContentProvider() {
        return new SelectProjectListContentProvider();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.getTitleText());
        Composite container = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        container.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        container.setLayoutData((Object)gd);
        Label textLabel = new Label(container, 64);
        textLabel.setText(this.getLabelText());
        this.treeViewer = this.createTreeViewer(container);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(1808));
        return container;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer localTree = new TreeViewer(parent);
        localTree.setContentProvider((IContentProvider)this.getContentProvider());
        localTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        localTree.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        IProject projectContext = StrutsCheatSheetContextManager.getProjectContext();
        if (projectContext != null) {
            localTree.setSelection((ISelection)new StructuredSelection((Object)projectContext));
        }
        localTree.addSelectionChangedListener((ISelectionChangedListener)this);
        return localTree;
    }

    private ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = this.createContentProvider();
        }
        return this.contentProvider;
    }

    public int getInternalReturnCode() {
        return this.internalReturnCode;
    }

    protected String getLabelText() {
        return StrutsCheatSheetResourceConstants.PROJECT_SELECT_TEXT;
    }

    public IProject getSelectedProject() {
        return this.selection;
    }

    protected String getTitleText() {
        return StrutsCheatSheetResourceConstants.PROJECT_SELECT_TITLE;
    }

    protected void okPressed() {
        this.setReturnCode(1);
        this.setInternalReturnCode(0);
        this.close();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object selElement = ((IStructuredSelection)sel).getFirstElement();
            if (selElement instanceof IProject) {
                this.setValidSelection((IProject)selElement);
            } else {
                this.setInvalidSelection();
            }
        }
    }

    protected void setInternalReturnCode(int rc) {
        this.internalReturnCode = rc;
    }

    private void setInvalidSelection() {
        this.selection = null;
        this.getButton(0).setEnabled(false);
    }

    private void setValidSelection(IProject selection) {
        this.selection = selection;
        this.getButton(0).setEnabled(true);
    }
}

