/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.cheatsheet.actions;

import com.ibm.etools.struts.cheatsheet.StrutsCheatSheetContextManager;
import com.ibm.etools.struts.cheatsheet.actions.AbstractWizardInvocationAction;
import com.ibm.etools.struts.cheatsheet.dialog.StrutsProjectWizard;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jst.servlet.ui.project.facet.WebProjectWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class CreateNewProjectAction
extends AbstractWizardInvocationAction {
    @Override
    protected void cancelPressed(IWizard wizard) {
        StrutsCheatSheetContextManager.setProjectContext(null);
    }

    @Override
    protected IWizard createWizard() {
        StrutsProjectWizard wizard = new StrutsProjectWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        return wizard;
    }

    private IFile getDiagramFileFromPath(IContainer container) {
        LocalWDEResourceVisitor visitor = new LocalWDEResourceVisitor();
        try {
            container.accept((IResourceVisitor)visitor);
        }
        catch (Exception exception) {}
        return visitor.getWDEFile();
    }

    @Override
    protected void okPressed(IWizard wizard) {
        IFile webDiagramFile;
        IDataModel model = ((WebProjectWizard)wizard).getDataModel();
        IProject project = (IProject)model.getProperty("IProjectCreationPropertiesNew.PROJECT");
        if (project != null && project.exists()) {
            StrutsCheatSheetContextManager.setProjectContext(project);
        }
        if ((webDiagramFile = this.getDiagramFileFromPath((IContainer)project)) != null && webDiagramFile.exists()) {
            StrutsCheatSheetContextManager.setWebDiagramContext(webDiagramFile);
        }
    }

    private class LocalWDEResourceVisitor
    implements IResourceVisitor {
        private IFile webDiagram = null;
        private String extension = "gph";

        public IFile getWDEFile() {
            return this.webDiagram;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.webDiagram != null) {
                return false;
            }
            if (!resource.isAccessible() || !resource.exists()) {
                return false;
            }
            switch (resource.getType()) {
                case 1: {
                    IFile file = (IFile)resource;
                    String fileExt = file.getFileExtension();
                    if (this.extension.equalsIgnoreCase(fileExt)) {
                        this.webDiagram = file;
                    }
                    return false;
                }
                case 2: {
                    IFolder folder = (IFolder)resource;
                    return !folder.getName().equals(".deployables");
                }
            }
            return true;
        }
    }
}

