/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.cheatsheet;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IWorkbenchWindow;

public class StrutsCheatSheetContext
implements IResourceChangeListener {
    private IProject project;
    private IFile webDiagram;

    protected StrutsCheatSheetContext(IWorkbenchWindow window) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    protected void clearContext() {
        this.invalidateProject();
        this.invalidateWebDiagram();
    }

    protected IProject getProjectContext() {
        return this.project;
    }

    protected IFile getWebDiagramContext() {
        return this.webDiagram;
    }

    private void invalidateProject() {
        this.setProjectContext(null);
    }

    private void invalidateWebDiagram() {
        this.setWebDiagramContext(null);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta fileDelta;
        IResourceDelta projectDelta;
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        if (this.getProjectContext() != null && (projectDelta = delta.findMember(this.getProjectContext().getFullPath())) != null && projectDelta.getKind() == 2) {
            this.invalidateProject();
        }
        if (this.getWebDiagramContext() != null && (fileDelta = delta.findMember(this.getWebDiagramContext().getFullPath())) != null && fileDelta.getKind() == 2) {
            this.invalidateWebDiagram();
        }
    }

    protected void setProjectContext(IProject project) {
        this.project = project;
        if (project == null) {
            this.webDiagram = null;
        }
    }

    protected void setWebDiagramContext(IFile file) {
        this.webDiagram = file;
        if (file != null) {
            this.project = file.getProject();
        }
    }
}

