/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.util.StrutsConfigFileUtil;
import com.ibm.etools.webtools.server.ServerRestartUtil;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor,
Preferences.IPropertyChangeListener {
    private static final int CHANGED_FLAGS = 360704;
    private static StrutsResourceChangeListener INSTANCE;
    private Map components;

    private StrutsResourceChangeListener() {
    }

    public static synchronized void shutdown() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    public static synchronized void startup() {
        if (INSTANCE == null) {
            INSTANCE = new StrutsResourceChangeListener();
            Job job = new Job("Starting StrutsResourceChangeListener"){

                protected IStatus run(IProgressMonitor monitor) {
                    INSTANCE.initialize();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setPriority(20);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
    }

    private void dispose() {
        this.setEnabled(false);
        StrutsPlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        if (this.components != null) {
            this.components.clear();
            this.components = null;
        }
    }

    private void initialize() {
        StrutsPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.setEnabled(StrutsPlugin.getDefault().getStrutsPreferences().getRestart());
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if ("restart".equals(event.getProperty())) {
            Object value = event.getNewValue();
            boolean enable = value instanceof Boolean ? ((Boolean)value).booleanValue() : StrutsPlugin.getDefault().getStrutsPreferences().getRestart();
            this.setEnabled(enable);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            this.components = new HashMap();
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException coreException) {}
            this.restartComponents();
            this.components = null;
        }
    }

    private void restartComponents() {
        for (IVirtualComponent component : this.components.values()) {
            ServerRestartUtil.restartComponent((IVirtualComponent)component, (boolean)true);
        }
    }

    private void setEnabled(boolean enable) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (enable) {
            workspace.addResourceChangeListener((IResourceChangeListener)this, 16);
        } else {
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IVirtualComponent component;
        IFile file;
        IResource resource = delta.getResource();
        if (resource.getType() == 1 && (delta.getKind() != 4 || (delta.getFlags() & 0x58100) != 0) && StrutsConfigFileUtil.isStrutsConfigFile(file = (IFile)resource, 2) && (component = Model2Util.findComponent((IResource)file)) != null) {
            this.components.put(file.getProject(), component);
        }
        return true;
    }
}

