/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.webfilewizard;

import com.ibm.etools.webtools.wizards.IWebRegionWizard;
import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.cgen.impl.WebRegionCodeGenModel;
import com.ibm.etools.webtools.wizards.markuplanguage.IMarkupLanguagelDocType;
import com.ibm.etools.webtools.wizards.markuplanguage.MarkupLanguage;
import com.ibm.etools.webtools.wizards.util.DialogSettingsHelper;
import com.ibm.etools.webtools.wizards.util.WebtoolsWizardsStore;
import com.ibm.etools.webtools.wizards.util.WizardsErrorDisplayer;
import com.ibm.etools.webtools.wizards.webfilewizard.WebFileRegionDataPage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;

public abstract class WebFileRegionDataWithMarkupPage
extends WebFileRegionDataPage {
    protected Label fBaseLabelSeparator;
    protected Combo wtMarkupLanguageCombo;
    protected int wtCurrentSelectedMarkupLanguageIndex = -1;
    protected String[] fValidContentIdLabels;
    protected String[] fValidContentId;

    public void createControl(Composite parent) {
        this.createAdvancedButton(parent);
        super.createControl(parent);
    }

    protected void createMarkupLanguageControl(Composite composite) {
        Label charEncodingLabel = new Label(composite, 0);
        charEncodingLabel.setText(ResourceHandler.Markup_Language__1);
        this.wtMarkupLanguageCombo = new Combo(composite, 8);
        this.wtMarkupLanguageCombo.setLayoutData((Object)new GridData(768));
        this.wtMarkupLanguageCombo.addListener(13, (Listener)this);
        WebFileRegionDataWithMarkupPage.createSpacer((Composite)composite);
    }

    @Override
    protected void createPageControl(Composite composite) {
        super.createPageControl(composite);
        this.createMarkupLanguageControl(composite);
    }

    @Override
    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.wtMarkupLanguageCombo) {
            this.handleMarkupLanguageComboSelectionChanged();
        } else {
            super.handleEvent(e);
        }
    }

    protected void handleMarkupLanguageComboSelectionChanged() {
        LinkedList<String> modifiedProperties = new LinkedList<String>();
        int newSelectedMarkupLanguageIndex = this.wtCurrentSelectedMarkupLanguageIndex;
        if (this.wtMarkupLanguageCombo != null && (newSelectedMarkupLanguageIndex = this.wtMarkupLanguageCombo.getSelectionIndex()) != this.wtCurrentSelectedMarkupLanguageIndex) {
            this.selectNewMarkupLanguage(newSelectedMarkupLanguageIndex);
            modifiedProperties.add("markupLanguage");
        }
        if (newSelectedMarkupLanguageIndex != this.wtCurrentSelectedMarkupLanguageIndex) {
            WebRegionCodeGenModel[] supportedCodeGenModels = this.getWebFileRegionData().getSupportedCodeGenModels();
            supportedCodeGenModels = this.pruneCodeGenModels(supportedCodeGenModels);
            ArrayList<String> selectedModelIds = new ArrayList<String>();
            ArrayList<String> selectedModelLabels = new ArrayList<String>();
            int currentSelectedModelIndex = -1;
            int defaultIndex = -1;
            WebRegionCodeGenModel defaultModel = this.getWebFileRegionData().getDefaultCodeGenModel();
            int i = 0;
            while (i < supportedCodeGenModels.length) {
                WebRegionCodeGenModel model = supportedCodeGenModels[i];
                selectedModelIds.add(model.getId());
                selectedModelLabels.add(model.getLabel());
                if (model == this.getRegionData().getCurrentCodeGenModel()) {
                    currentSelectedModelIndex = i;
                }
                if (model == defaultModel) {
                    defaultIndex = i;
                }
                ++i;
            }
            if (currentSelectedModelIndex == -1) {
                if (defaultIndex != -1) {
                    currentSelectedModelIndex = defaultIndex;
                } else if (supportedCodeGenModels.length > 0) {
                    currentSelectedModelIndex = 0;
                }
            }
            this.setValidModelIds(selectedModelIds.toArray(new String[selectedModelIds.size()]));
            this.setValidModelLabels(selectedModelLabels.toArray(new String[selectedModelLabels.size()]));
            if (this.wtModelCombo != null) {
                this.wtModelCombo.setItems(this.getValidModelLabels());
                if (currentSelectedModelIndex != -1) {
                    this.wtModelCombo.select(currentSelectedModelIndex);
                    this.handleModelComboSelection();
                    modifiedProperties.add("modelId");
                }
            } else if (selectedModelIds.size() > currentSelectedModelIndex && currentSelectedModelIndex > -1) {
                this.handleNewModelSelected((String)selectedModelIds.get(currentSelectedModelIndex));
                modifiedProperties.add("modelId");
            }
            ((IWebRegionWizard)this.getWizard()).fireRegionDataChangedEvent(modifiedProperties);
            this.wtCurrentSelectedMarkupLanguageIndex = newSelectedMarkupLanguageIndex;
        }
    }

    @Override
    protected void initContent() {
        super.initContent();
        if (this.wtMarkupLanguageCombo != null) {
            this.populateMarkupLanguageCombo(this.wtMarkupLanguageCombo);
        }
    }

    protected boolean isRestoreModelComboWidgetValue(String previousModelId, int previousModelIndex) {
        return false;
    }

    protected boolean isValidMarkupLanguage(String contentID) {
        return true;
    }

    protected void populateMarkupLanguageCombo(Combo comboBox) {
        String[] newValidContentIdLabels = null;
        String[] newValidContentId = null;
        int currentSelectedMarkupLanguageIndex = 0;
        try {
            String[] labels = MarkupLanguage.getLabels();
            String[] contentIds = MarkupLanguage.getIDs();
            Vector<String> availableContentIdLabel = new Vector<String>();
            Vector<String> availableContentId = new Vector<String>();
            HTMLDocumentTypeRegistry registry = HTMLDocumentTypeRegistry.getInstance();
            int i = 0;
            while (i < contentIds.length) {
                if (this.isValidMarkupLanguage(contentIds[i])) {
                    MarkupLanguage mL = new MarkupLanguage(contentIds[i]);
                    IMarkupLanguagelDocType[] mLDocType = mL.getDocTypes();
                    boolean addContentId = false;
                    int j = 0;
                    while (j < mLDocType.length) {
                        if (registry.getEntry(mLDocType[j].getPublicID()) != null) {
                            addContentId = true;
                            break;
                        }
                        ++j;
                    }
                    if (addContentId) {
                        if (i < labels.length) {
                            availableContentIdLabel.add(labels[i]);
                        } else {
                            availableContentIdLabel.add(ResourceHandler._NO_LABEL__1);
                        }
                        availableContentId.add(contentIds[i]);
                        if (this.getWebFileRegionData().getMarkupLanguage() != null && contentIds[i].equals(this.getWebFileRegionData().getMarkupLanguage().getID())) {
                            currentSelectedMarkupLanguageIndex = i;
                        }
                    }
                }
                ++i;
            }
            newValidContentIdLabels = availableContentIdLabel.toArray(new String[availableContentIdLabel.size()]);
            newValidContentId = availableContentId.toArray(new String[availableContentId.size()]);
        }
        catch (CoreException coreException) {}
        if (newValidContentIdLabels == null || newValidContentIdLabels.length < 1) {
            WizardsErrorDisplayer.displayError((Throwable)new Exception(ResourceHandler.No_Markup_Languages_were_found__2), (Shell)this.getShell());
        } else {
            String[] comboItems = comboBox.getItems();
            if (this.fValidContentId != null && comboItems != null && this.fValidContentIdLabels.length == comboItems.length && this.fValidContentId.length == newValidContentId.length) {
                boolean isEqual = true;
                int i = 0;
                while (i < comboItems.length) {
                    if (!this.fValidContentIdLabels[i].equals(comboItems[i])) {
                        isEqual = false;
                        break;
                    }
                    ++i;
                }
                if (isEqual) {
                    i = 0;
                    while (i < newValidContentId.length) {
                        if (!this.fValidContentId[i].equals(newValidContentId[i])) {
                            isEqual = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (isEqual && comboBox.getSelectionIndex() != -1) {
                    String markupId = this.fValidContentId[comboBox.getSelectionIndex()];
                    if (this.getWebFileRegionData().getMarkupLanguage() != null && markupId.equals(this.getWebFileRegionData().getMarkupLanguage().getID())) {
                        return;
                    }
                }
            }
            this.fValidContentIdLabels = newValidContentIdLabels;
            this.fValidContentId = newValidContentId;
            comboBox.setItems(this.fValidContentIdLabels);
            comboBox.select(currentSelectedMarkupLanguageIndex);
            this.handleMarkupLanguageComboSelectionChanged();
        }
    }

    public void restoreWidgetValues() {
        super.restoreWidgetValues();
        DialogSettingsHelper.restoreCombo((Combo)this.wtMarkupLanguageCombo, (String)(String.valueOf(this.getWizard().getClass().getName()) + "WebFileRegionDataPage.wtMarkupLanguageCombo"), (IDialogSettings)WebtoolsWizardsStore.getDialogSettings());
    }

    public void saveWidgetValues() {
        super.saveWidgetValues();
        DialogSettingsHelper.saveCombo((Combo)this.wtMarkupLanguageCombo, (String)(String.valueOf(this.getWizard().getClass().getName()) + "WebFileRegionDataPage.wtMarkupLanguageCombo"), (IDialogSettings)WebtoolsWizardsStore.getDialogSettings());
    }

    protected void selectNewMarkupLanguage(int index) {
        try {
            this.getWebFileRegionData().setMarkupLanguage(this.fValidContentId[index]);
        }
        catch (Throwable throwable) {
            WizardsErrorDisplayer.displayError((Throwable)throwable, (Shell)this.getShell());
        }
    }
}

