/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.webfilewizard;

import com.ibm.etools.webtools.wizards.IWebRegionWizard;
import com.ibm.etools.webtools.wizards.WebtoolsWizardsPlugin;
import com.ibm.etools.webtools.wizards.basic.TypeDeploymentDescriptorPage;
import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.cgen.IWebRegionCodeGenContrib;
import com.ibm.etools.webtools.wizards.impl.NewRegionDataPage;
import com.ibm.etools.webtools.wizards.util.WebFileExtensions;
import com.ibm.etools.webtools.wizards.webfilewizard.BaseWebSelectionValidator;
import com.ibm.etools.webtools.wizards.webfilewizard.IWebFileCodeGenInfo;
import com.ibm.etools.webtools.wizards.webfilewizard.IWebFileRegionData;
import com.ibm.etools.webtools.wizards.webfilewizard.WebFileOptionsDataPage;
import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public abstract class WebFileRegionDataPage
extends NewRegionDataPage
implements ISelectionChangedListener {
    protected Label wtFileNameLabel;
    protected Text wtFileNameText;
    protected Label fBaseLabelSeparator;
    String[] fValidModelIds;
    String[] fValidModelLabels;

    protected void createFileNameControl(Composite composite) {
        this.wtFileNameLabel = new Label(composite, 0);
        this.wtFileNameLabel.setText(ResourceHandler.File_Name__4);
        this.wtFileNameText = new Text(composite, 2048);
        this.wtFileNameText.setLayoutData((Object)new GridData(768));
        this.wtFileNameText.addListener(24, (Listener)this);
        WebFileRegionDataPage.createSpacer((Composite)composite);
    }

    protected void createPageControl(Composite composite) {
        this.createContainerSelectionControl(composite, ResourceHandler.Folder__1);
        this.createFileNameControl(composite);
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Status ret = new Status(4, WebtoolsWizardsPlugin.getPluginId(), 4, ResourceHandler.Invalid_Container__none_31, null);
                try {
                    if (selection[0] != null) {
                        ret = new Status(0, WebtoolsWizardsPlugin.getPluginId(), 0, "", null);
                    }
                }
                catch (Exception exception) {}
                return ret;
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean ret = false;
                if (element instanceof IContainer) {
                    IContainer container = (IContainer)element;
                    ret = BaseWebSelectionValidator.whyCanINotUseWeb(container) == null;
                }
                return ret;
            }
        };
    }

    protected String getDefaultSuffix() {
        String suffix = this.getWebFileRegionData().getSuffix();
        return suffix;
    }

    protected String[] getValidModelIds() {
        return this.fValidModelIds;
    }

    protected String[] getValidModelLabels() {
        return this.fValidModelLabels;
    }

    protected final IWebFileRegionData getWebFileRegionData() {
        return (IWebFileRegionData)this.getRegionData();
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.wtFileNameText) {
            this.getWebFileRegionData().setPrefix(this.wtFileNameText.getText());
        } else {
            super.handleEvent(e);
        }
    }

    protected void handleModelComboSelection() throws ArrayIndexOutOfBoundsException {
        int index = this.wtModelCombo.getSelectionIndex();
        this.getRegionData().getCurrentCodeGenModel();
        if (this.fValidModelIds != null && this.fValidModelIds.length > index && index >= 0) {
            this.handleNewModelSelected(this.getValidModelIds()[index]);
        } else {
            super.handleModelComboSelection();
        }
    }

    protected void handleNewModelSelected(String newModelID) {
        block10: {
            boolean changed = this.getRegionData().getModelId() != newModelID;
            super.handleNewModelSelected(newModelID);
            if (!changed) break block10;
            IWizardPage[] pages = this.getWizard().getPages();
            IWebRegionCodeGenContrib contrib = this.getRegionData().getCurrentCodeGenModel().getCode_gen_contrib();
            if (contrib instanceof IWebFileCodeGenInfo) {
                int i = 0;
                while (i < pages.length) {
                    if (pages[i] instanceof WebFileOptionsDataPage) {
                        ((WebFileOptionsDataPage)pages[i]).setStyleSheetEnabled(!((IWebFileCodeGenInfo)contrib).generatesContentFragment());
                    } else if (pages[i] instanceof TypeDeploymentDescriptorPage) {
                        ((TypeDeploymentDescriptorPage)pages[i]).setShouldEnableAddToWebXML(!((IWebFileCodeGenInfo)contrib).shouldDisableAddToWebXml());
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < pages.length) {
                    if (pages[i] instanceof WebFileOptionsDataPage) {
                        ((WebFileOptionsDataPage)pages[i]).setStyleSheetEnabled(true);
                    } else if (pages[i] instanceof TypeDeploymentDescriptorPage) {
                        ((TypeDeploymentDescriptorPage)pages[i]).setShouldEnableAddToWebXML(true);
                    }
                    ++i;
                }
            }
        }
    }

    protected void initContent() {
        super.initContent();
        if (this.wtFileNameText != null && this.getWebFileRegionData().getPrefix() != null) {
            this.wtFileNameText.setText(this.getWebFileRegionData().getPrefix());
        }
    }

    protected void newContainerSelection(IContainer container) {
        LinkedList<String> modifiedProperties = new LinkedList<String>();
        IContainer oldContainer = this.getRegionData().getDestinationFolder();
        this.getRegionData().setDestinationFolder(container);
        modifiedProperties.add("destinationFolder");
        if ((oldContainer == null || !oldContainer.getFullPath().equals((Object)container.getFullPath())) && this.getWizard() instanceof IWebRegionWizard) {
            ((IWebRegionWizard)this.getWizard()).fireRegionDataChangedEvent(modifiedProperties);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    protected void setValidModelIds(String[] strings) {
        this.fValidModelIds = strings;
    }

    protected void setValidModelLabels(String[] strings) {
        this.fValidModelLabels = strings;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.wtFileNameText != null) {
            this.wtFileNameText.setFocus();
        }
    }

    protected void updateButtonStates() {
    }

    protected String whyCanINotUse(IContainer container) {
        return BaseWebSelectionValidator.whyCanINotUseWeb(container);
    }

    protected String whyCanINotUseWebFileName(String fileName) {
        String ret = null;
        if (fileName.equals("")) {
            ret = ResourceHandler.WebFileRegionDataPage_A_file_name_must_be_specified__2;
            this.fPageStatus.addErrorMessage(ret);
        } else if (!fileName.trim().equals(fileName)) {
            ret = ResourceHandler.WebFileRegionDataPage_The_file_name_cannot_begin_or_end_with_white_spaces__3;
            this.fPageStatus.addErrorMessage(ret);
        } else if (fileName.endsWith(".")) {
            ret = ResourceHandler.WebFileRegionDataPage_The_file_name_cannot_end_with_a_period__4;
            this.fPageStatus.addErrorMessage(ret);
        } else if (fileName.startsWith(".")) {
            ret = ResourceHandler.WebFileRegionDataPage_The_file_name_cannot_start_with_a_period__5;
            this.fPageStatus.addErrorMessage(ret);
        } else {
            String suffix = this.getDefaultSuffix();
            if (!fileName.equals("") && fileName.lastIndexOf(".") == -1) {
                fileName = String.valueOf(fileName) + suffix;
            } else {
                String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
                ret = this.whyIsFileExtensionNotValid(fileExtension);
            }
            if (ret == null) {
                IStatus result = ResourcesPlugin.getWorkspace().validateName(fileName, 1);
                if (!result.isOK()) {
                    ret = NLS.bind((String)ResourceHandler.Invalid_File_Name__22, (Object)result.getMessage());
                    this.fPageStatus.addErrorMessage(ret);
                } else if (this.getWebFileRegionData().getDestinationFolder() != null) {
                    IPath filePath = this.getWebFileRegionData().getDestinationFolder().getFullPath();
                    filePath = filePath.append(fileName);
                    result = ResourcesPlugin.getWorkspace().validatePath(filePath.toString(), 1);
                    if (!result.isOK()) {
                        ret = NLS.bind((String)ResourceHandler.Invalid_File_Name__22, (Object)result.getMessage());
                        this.fPageStatus.addErrorMessage(ret);
                    } else {
                        File systemFile = new File(this.getWebFileRegionData().getDestinationFolder().getLocation().toOSString(), fileName);
                        if (systemFile.exists()) {
                            ret = NLS.bind((String)ResourceHandler.The_file_already_exists_1, (Object)fileName);
                            this.fPageStatus.addErrorMessage(ret);
                        }
                    }
                }
            }
        }
        return ret;
    }

    protected String whyIsFileExtensionNotValid(String extension) {
        String ret = null;
        if (!WebFileExtensions.isWebType((String)extension)) {
            ret = NLS.bind((String)ResourceHandler.Invalid_File_Extension, (Object)extension);
            this.fPageStatus.addErrorMessage(ret);
        }
        return ret;
    }

    protected String whyIsPageNotComplete() {
        String ret = super.whyIsPageNotComplete();
        if (!this.fPageStatus.isError() && this.wtFileNameText != null) {
            ret = this.whyCanINotUseWebFileName(this.wtFileNameText.getText());
        }
        return ret;
    }
}

