/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.webfilewizard;

import com.ibm.etools.webtools.wizards.cgen.FilesPreferenceUtil;
import com.ibm.etools.webtools.wizards.cgen.impl.WebRegionCodeGenModel;
import com.ibm.etools.webtools.wizards.markuplanguage.IMarkupLanguage;
import com.ibm.etools.webtools.wizards.markuplanguage.MarkupLanguage;
import com.ibm.etools.webtools.wizards.regiondata.IWTFileData;
import com.ibm.etools.webtools.wizards.regiondata.impl.WTRegionData;
import com.ibm.etools.webtools.wizards.webfilewizard.IWebFileRegionData;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;

public class WebFileRegionData
extends WTRegionData
implements IWebFileRegionData {
    protected String wtWebFileName;
    protected String wtCharacterEncoding = null;
    protected HTMLDocumentTypeEntry wtDocType;
    protected Vector wtStyleSheetEntries = new Vector();
    protected Boolean insertMetaContentType = null;
    protected Boolean insertGenerator = null;
    protected IMarkupLanguage wtMarkupLanguage = null;
    protected String wtContentTypeDirectiveContent = "";

    @Override
    public void addStyleSheetEntry(IFile styleSheetEntry) {
        if (!this.fileEntryExists(styleSheetEntry, this.wtStyleSheetEntries)) {
            this.wtStyleSheetEntries.add(styleSheetEntry);
        }
    }

    @Override
    public void addStyleSheetEntry(IFile styleSheetEntry, int index) {
        if (!this.fileEntryExists(styleSheetEntry, this.wtStyleSheetEntries)) {
            this.wtStyleSheetEntries.add(index, styleSheetEntry);
        }
    }

    protected boolean fileEntryExists(IFile entry, List list) {
        if (list != null) {
            boolean entryfound = false;
            int i = 0;
            while (i < list.size()) {
                IFile file = (IFile)list.get(i);
                if (entry.getFullPath().toString().equalsIgnoreCase(file.getFullPath().toString())) {
                    entryfound = true;
                    break;
                }
                ++i;
            }
            return entryfound;
        }
        return false;
    }

    @Override
    public String getCharacterEncoding() {
        return this.wtCharacterEncoding;
    }

    @Override
    public String getContentTypeDirectiveContent() {
        return this.wtContentTypeDirectiveContent;
    }

    @Override
    public HTMLDocumentTypeEntry getDocType() {
        return this.wtDocType;
    }

    @Override
    public IMarkupLanguage getMarkupLanguage() {
        return this.wtMarkupLanguage;
    }

    @Override
    public String getPreferredCharacterEncoding() {
        return FilesPreferenceUtil.getOutputCodesetForHTML();
    }

    @Override
    public Vector getStyleSheetEntries() {
        return this.wtStyleSheetEntries;
    }

    @Override
    public String getSuffix() {
        String suffix = null;
        IMarkupLanguage ml = this.getMarkupLanguage();
        if (ml != null && ml.getID().indexOf("html") != -1) {
            suffix = FilesPreferenceUtil.getDefaultSuffix();
        }
        if (suffix == null || suffix.equals("")) {
            IWTFileData[] fileNames = this.getFiles();
            if (fileNames != null && fileNames.length > 0 && fileNames[0] != null && fileNames[0].getSourceType() == 1) {
                suffix = fileNames[0].getSuffix();
            }
        } else if (!suffix.startsWith(".")) {
            suffix = "." + suffix;
        }
        if (suffix == null || suffix.equals("")) {
            suffix = ".html";
        }
        return suffix;
    }

    @Override
    public WebRegionCodeGenModel[] getSupportedCodeGenModels() {
        ArrayList<WebRegionCodeGenModel> selectedModels = new ArrayList<WebRegionCodeGenModel>();
        IMarkupLanguage markup = this.getMarkupLanguage();
        String markupId = markup != null ? markup.getID() : "";
        WebRegionCodeGenModel[] codeGenModels = this.getCodeGenModels();
        int i = 0;
        while (i < codeGenModels.length) {
            WebRegionCodeGenModel codeGenModel = codeGenModels[i];
            this.initModelIfNecessary(codeGenModel);
            IMarkupLanguage[] languages = codeGenModel.getMarkupLanguages();
            if (languages != null) {
                int j = 0;
                while (j < languages.length) {
                    if (languages[j].getID().equals(markupId)) {
                        selectedModels.add(codeGenModel);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return selectedModels.toArray(new WebRegionCodeGenModel[selectedModels.size()]);
    }

    @Override
    public String getWebFileName() {
        String fileName = this.getPrefix();
        String prefix = this.getPrefix();
        if (prefix.lastIndexOf(".") == -1) {
            fileName = String.valueOf(fileName) + this.getSuffix();
        }
        return fileName;
    }

    @Override
    public void removeAllStyleSheetEntries() {
        this.wtStyleSheetEntries.removeAllElements();
    }

    @Override
    public void removeStyleSheetEntry(IFile styleSheetEntry) {
        this.wtStyleSheetEntries.remove(styleSheetEntry);
    }

    @Override
    public void removeStyleSheetEntry(int index) {
        this.wtStyleSheetEntries.remove(index);
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.wtCharacterEncoding = encoding;
        int i = 0;
        while (i < this.getFiles().length) {
            this.getFiles()[i].setCharacterEncoding(encoding);
            ++i;
        }
    }

    @Override
    public void setContentTypeDirectiveContent(String value) {
        this.wtContentTypeDirectiveContent = value;
    }

    @Override
    public void setDocType(HTMLDocumentTypeEntry docType) {
        this.wtDocType = docType;
    }

    @Override
    public void setMarkupLanguage(String modelId) throws CoreException {
        this.wtMarkupLanguage = new MarkupLanguage(modelId);
    }

    @Override
    public void setWebFileName(String fileName) {
        this.wtWebFileName = fileName;
    }
}

