/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.webfilewizard;

import com.ibm.etools.struts.webregionwizard.Activator;
import com.ibm.etools.webtools.wizards.basic.WebFileDataUtil;
import com.ibm.etools.webtools.wizards.cgen.WTCodeFormatter;
import com.ibm.etools.webtools.wizards.regiondata.IWTFileData;
import com.ibm.etools.webtools.wizards.regiondata.IWTRegionData;
import com.ibm.etools.webtools.wizards.webfilewizard.IWebFileRegionData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;

public class WebFileCodeFormatter
extends WTCodeFormatter {
    public static void format(IWTFileData fileData, IWTRegionData regionData, IFile file, IProgressMonitor monitor) throws CoreException {
        CleanupPreferences prefs = WebFileCodeFormatter.getCleanupPreferences();
        WebFileCodeFormatter.setCleanUpFormatStrategy(regionData);
        if (fileData != null && fileData.getSourceType() == 1) {
            if (fileData.isText()) {
                WebFileCodeFormatter.formatWeb(file.getLocation().toOSString());
            }
            if (file != null && file.exists()) {
                file.refreshLocal(2, monitor);
            }
        }
        WebFileCodeFormatter.restorePreferences(prefs);
    }

    public static void formatWeb(IFile file) {
        try {
            HTMLCleanupProcessorImpl processor = new HTMLCleanupProcessorImpl();
            processor.cleanupFile(file);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    public static void formatWeb(String fileName) {
        try {
            HTMLCleanupProcessorImpl processor = new HTMLCleanupProcessorImpl();
            processor.cleanupFileName(fileName);
        }
        catch (Exception ex) {
            Activator.log(ex);
        }
    }

    private static CleanupPreferences getCleanupPreferences() {
        Preferences store = WebFileCodeFormatter.getModelManagerPreferenceStore();
        CleanupPreferences prefs = new CleanupPreferences();
        prefs.cleanupTagNameCase = store.getInt("cleanupTagNameCase");
        prefs.cleanupAttrNameCase = store.getInt("cleanupAttrNameCase");
        prefs.insertMissingTags = store.getBoolean("insertMissingTags");
        prefs.quoteAttrValues = store.getBoolean("quoteAttrValues");
        prefs.formatSource = store.getBoolean("formatSource");
        return prefs;
    }

    protected static Preferences getCommonPreferenceStore() {
        return WebFileCodeFormatter.getHTMLPrefs();
    }

    public static Preferences getHTMLPrefs() {
        return Platform.getPlugin((String)"org.eclipse.wst.html.core").getPluginPreferences();
    }

    private static Preferences getModelManagerPreferenceStore() {
        return WebFileCodeFormatter.getCommonPreferenceStore();
    }

    private static void restorePreferences(CleanupPreferences prefs) {
        Preferences store = WebFileCodeFormatter.getModelManagerPreferenceStore();
        store.setValue("cleanupTagNameCase", prefs.cleanupTagNameCase);
        store.setValue("cleanupAttrNameCase", prefs.cleanupAttrNameCase);
        store.setValue("insertMissingTags", prefs.insertMissingTags);
        store.setValue("quoteAttrValues", prefs.quoteAttrValues);
        store.setValue("formatSource", prefs.formatSource);
    }

    protected static void setCleanUpFormatStrategy(IWTRegionData regionData) {
        int attrCase;
        int tagCase;
        WebFileDataUtil webFileDataUtil = new WebFileDataUtil((IWebFileRegionData)regionData);
        Preferences store = WebFileCodeFormatter.getModelManagerPreferenceStore();
        if (webFileDataUtil.determineVersion().equalsIgnoreCase("XHTML") || webFileDataUtil.determineVersion().equalsIgnoreCase("WML")) {
            tagCase = 1;
            attrCase = 1;
        } else if (WebFileCodeFormatter.getCommonPreferenceStore().getBoolean("preferredMarkupCaseSupported")) {
            tagCase = WebFileCodeFormatter.getCommonPreferenceStore().getInt("tagNameCase");
            attrCase = WebFileCodeFormatter.getCommonPreferenceStore().getInt("attrNameCase");
        } else {
            tagCase = 0;
            attrCase = 0;
        }
        store.setValue("cleanupTagNameCase", tagCase);
        store.setValue("cleanupAttrNameCase", attrCase);
        store.setValue("insertMissingTags", false);
        store.setValue("quoteAttrValues", false);
        store.setValue("formatSource", true);
    }

    private static class CleanupPreferences {
        int cleanupTagNameCase;
        int cleanupAttrNameCase;
        boolean insertMissingTags;
        boolean quoteAttrValues;
        boolean formatSource;

        private CleanupPreferences() {
        }
    }
}

