/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.simplewebwizard;

import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.simplewebwizard.SimpleWebRegionDataPage;
import com.ibm.etools.webtools.wizards.util.DialogSettingsHelper;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class SimpleWebFileWithExtensionRegionDataPage
extends SimpleWebRegionDataPage {
    private static final String idFileSuffixCombo = "SimpleWebFileWithExtensionRegionDataPage.wtFileSuffixCombo";
    protected Combo wtFileSuffixCombo;
    protected String[] wtExtensionTypes = null;

    @Override
    protected void createFileNameControl(Composite composite) {
        this.wtFileNameLabel = new Label(composite, 0);
        this.wtFileNameLabel.setText(ResourceHandler.File_Name__4);
        this.wtFileNameText = new Text(composite, 2048);
        GridData data = new GridData(768);
        this.wtFileNameText.setLayoutData((Object)data);
        this.wtFileNameText.addListener(24, (Listener)this);
        SimpleWebFileWithExtensionRegionDataPage.createSpacer((Composite)composite);
        Label fileSuffixLabel = new Label(composite, 0);
        fileSuffixLabel.setText(ResourceHandler.File_Type__1);
        this.wtFileSuffixCombo = new Combo(composite, 8);
        data = new GridData(768);
        this.wtFileSuffixCombo.setLayoutData((Object)data);
        this.wtFileSuffixCombo.addListener(24, (Listener)this);
        SimpleWebFileWithExtensionRegionDataPage.createSpacer((Composite)composite);
    }

    @Override
    protected String getDefaultSuffix() {
        if (this.wtFileSuffixCombo != null && this.wtFileSuffixCombo.getItemCount() > 0) {
            return "." + this.wtFileSuffixCombo.getText();
        }
        return super.getDefaultSuffix();
    }

    protected String[] getExtensionTypes() {
        if (this.wtExtensionTypes == null) {
            this.wtExtensionTypes = new String[0];
        }
        return this.wtExtensionTypes;
    }

    @Override
    public void handleEvent(Event ev) {
        if (ev.widget == this.wtFileSuffixCombo) {
            this.getSimpleWebRegionData().setSuffix(this.getDefaultSuffix());
        } else {
            super.handleEvent(ev);
        }
        this.setPageComplete(this.validatePage());
    }

    @Override
    protected void initContent() {
        if (this.wtFileSuffixCombo != null) {
            this.populateFileTypeCombo(this.wtFileSuffixCombo);
            this.matchAndSelect(this.wtFileSuffixCombo);
        }
        super.initContent();
    }

    protected void matchAndSelect(Combo combo) {
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
    }

    protected void populateFileTypeCombo(Combo combo) {
        combo.setItems(this.getExtensionTypes());
    }

    public void restoreWidgetValues() {
        super.restoreWidgetValues();
        IDialogSettings store = this.getDialogSettings();
        if (store != null && store.get(this.getUniqueKey("")) != null) {
            DialogSettingsHelper.restoreCombo((Combo)this.wtFileSuffixCombo, (String)idFileSuffixCombo, (IDialogSettings)store);
        }
    }

    public void saveWidgetValues() {
        super.saveWidgetValues();
        IDialogSettings store = this.getDialogSettings();
        if (store != null) {
            store.put(this.getUniqueKey(""), this.getUniqueKey(""));
            DialogSettingsHelper.saveCombo((Combo)this.wtFileSuffixCombo, (String)idFileSuffixCombo, (IDialogSettings)store);
        }
    }

    protected final void setExtensionTypes(String[] extensionTypes) {
        this.wtExtensionTypes = extensionTypes;
    }

    @Override
    protected String whyIsFileExtensionNotValid(String extension) {
        String ret = null;
        if (this.wtExtensionTypes != null && this.wtExtensionTypes.length > 0) {
            ret = NLS.bind((String)ResourceHandler.Invalid_File_Extension, (Object)extension);
            int i = 0;
            while (i < this.wtExtensionTypes.length) {
                if (extension.equals(this.wtExtensionTypes[i])) {
                    ret = null;
                    break;
                }
                ++i;
            }
        }
        if (ret != null) {
            this.fPageStatus.addErrorMessage(ret);
        }
        return ret;
    }
}

