/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic.util;

import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.basic.util.WTTypeWizardSelectionValidator;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ProjectValidationUtil {
    protected IJavaProject[] wtProjects;
    protected HashMap wtAcceptableTable = new HashMap();
    protected String[] wtClassNames;
    protected boolean wtHasToBe13 = false;
    protected String wtNot13ErrorMessage = "";

    public ProjectValidationUtil(String[] classNames) {
        this(classNames, false, "");
    }

    public ProjectValidationUtil(String[] classNames, boolean hasToBe13, String not13ErrorMessage) {
        this.wtClassNames = classNames;
        this.wtNot13ErrorMessage = not13ErrorMessage;
        this.loadJavaProjects();
        int i = 0;
        while (i < this.wtProjects.length) {
            IJavaProject javaProject = this.wtProjects[i];
            IProject project = javaProject.getProject();
            IVirtualComponent webComponent = ComponentCore.createComponent((IProject)project);
            if (webComponent != null) {
                WebArtifactEdit readOnlyEditModel = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)webComponent);
                if (readOnlyEditModel != null) {
                    if (hasToBe13 && readOnlyEditModel.getJ2EEVersion() < 13) {
                        this.wtAcceptableTable.put(project, this.wtNot13ErrorMessage);
                    } else {
                        this.wtAcceptableTable.put(project, null);
                    }
                    readOnlyEditModel.dispose();
                }
            } else {
                this.wtAcceptableTable.put(project, this.whyCanINotUseJavaProject(javaProject));
            }
            ++i;
        }
    }

    public IJavaProject[] getValidJavaProjects() {
        Vector<IJavaProject> validProject = new Vector<IJavaProject>();
        int i = 0;
        while (i < this.wtProjects.length) {
            IJavaProject jProject = this.wtProjects[i];
            Object error = this.wtAcceptableTable.get(jProject.getProject());
            if (error == null) {
                validProject.add(jProject);
            }
            ++i;
        }
        return validProject.toArray(new IJavaProject[validProject.size()]);
    }

    protected void loadJavaProjects() {
        try {
            this.wtProjects = JemProjectUtilities.getJavaModel().getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            this.wtProjects = new IJavaProject[0];
        }
    }

    public String whyCanINotUseJava(IContainer container) {
        String ret = WTTypeWizardSelectionValidator.whyCanINotUseJava(container);
        if (ret == null) {
            ret = this.whyCanINotUseProject(container.getProject());
        }
        return ret;
    }

    protected String whyCanINotUseJavaProject(IJavaProject javaProject) {
        String ret = null;
        try {
            int i = 0;
            while (i < this.wtClassNames.length) {
                String listenerName = this.wtClassNames[i];
                IType type = javaProject.findType(listenerName);
                if (type == null) {
                    ret = NLS.bind((String)ResourceHandler.is_not_found_in_this_Java_Project, (Object)listenerName);
                    break;
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
        return ret;
    }

    public String whyCanINotUseProject(IProject project) {
        String ret = ResourceHandler.Must_be_within_a_Java_Project_2;
        if (this.wtAcceptableTable.containsKey(project)) {
            ret = (String)this.wtAcceptableTable.get(project);
        }
        return ret;
    }
}

