/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.struts.webregionwizard.Activator;
import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.cgen.FilesPreferenceUtil;
import com.ibm.etools.webtools.wizards.webfilewizard.IWebFileRegionData;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;

public class WebFileDataUtil {
    protected static final String UTF16Key = "UTF-16";
    protected IWebFileRegionData wtRegionData;
    protected String version = "HTML";
    protected Boolean fIncludeDocTypeTag = null;
    protected boolean fIsFrameSet = false;
    protected Boolean fInsertMetaContentType = null;
    protected Boolean fIncludeGeneratorInSource = null;
    protected String generatorString = "IBM WebSphere Studio";
    protected String attributeNameAttrib = "lower";
    protected String tagNameAttrib = "lower";
    protected String newLine = "\r\n";

    public WebFileDataUtil(IWebFileRegionData regionData) {
        this.wtRegionData = regionData;
    }

    public static String getContextRootString(IVirtualComponent component) {
        WebArtifactEdit readOnlyWebEdit;
        String contextRootString = "";
        if (!WebFileDataUtil.isStaticComponent(component) && (readOnlyWebEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component)) != null) {
            contextRootString = readOnlyWebEdit.getServerContextRoot();
            readOnlyWebEdit.dispose();
        }
        return contextRootString;
    }

    public static String getDocTypeTag(HTMLDocumentTypeEntry docType) {
        if (docType.getPublicId().length() == 0 && docType.getSystemId().length() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<!DOCTYPE " + docType.getName() + " ");
        if (docType.getPublicId() != null && docType.getPublicId().length() > 0) {
            buffer.append("PUBLIC \"");
            buffer.append(docType.getPublicId());
            buffer.append("\"");
            if (docType.getSystemId() != null && docType.getSystemId().length() > 0) {
                buffer.append(" \"" + docType.getSystemId() + "\"");
            }
        } else {
            buffer.append("SYSTEM \"");
            buffer.append(docType.getSystemId());
            buffer.append("\"");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public static IPath getWebFolderString(IVirtualComponent component) {
        return component != null ? component.getRootFolder().getWorkspaceRelativePath() : new Path("");
    }

    private static boolean isStaticComponent(IVirtualComponent component) {
        boolean isStatic = false;
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
            IProjectFacet staticWebFacet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
            isStatic = facetedProject.hasProjectFacet(staticWebFacet);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isStatic;
    }

    public String determineVersion() {
        String publicID;
        HTMLDocumentTypeEntry docType = this.getWtRegionData().getDocType();
        if (docType != null && (publicID = docType.getPublicId()) != null) {
            if (publicID.lastIndexOf("XHTML") != -1) {
                return "XHTML";
            }
            if (publicID.lastIndexOf("HTML") != -1) {
                return "HTML";
            }
            if (publicID.lastIndexOf("WML") != -1) {
                return "WML";
            }
        }
        return "HTML";
    }

    public String getCharacterEncoding() {
        if (this.getWtRegionData().getCharacterEncoding() == null || this.getWtRegionData().getCharacterEncoding().equals("")) {
            return FilesPreferenceUtil.getWorkbenchOutputCodeset();
        }
        String encoding = this.getWtRegionData().getCharacterEncoding();
        if (encoding == null) {
            Activator.log(ResourceHandler.Invalid_Encoding_returned_by_Wizard_5);
        }
        return encoding;
    }

    public Vector getCSSListWithContextRoot() {
        if (this.getWtRegionData() != null) {
            Vector<String> cssVector = new Vector<String>();
            int i = 0;
            while (i < this.getWtRegionData().getStyleSheetEntries().size()) {
                cssVector.add(this.getFileWithContextRoot((IFile)this.getWtRegionData().getStyleSheetEntries().get(i)));
                ++i;
            }
            return cssVector;
        }
        return new Vector();
    }

    public String getDocTypePublicID() {
        String publicID = this.getWtRegionData().getDocType().getPublicId();
        publicID = publicID != null && !publicID.equals("") ? "\"" + publicID + "\"" : "";
        return publicID;
    }

    public String getDocTypeSystemID() {
        String systemID = this.getWtRegionData().getDocType().getSystemId();
        systemID = systemID != null && !systemID.equals("") ? "\"" + systemID + "\"" : "";
        return systemID;
    }

    public String getDocTypeTag() {
        if (this.wtRegionData != null) {
            String docTag = WebFileDataUtil.getDocTypeTag(this.wtRegionData.getDocType());
            return docTag;
        }
        return "";
    }

    public String getEndOfTagString() {
        String version = this.determineVersion();
        String endTag = ">";
        if (version.equals("HTML")) {
            endTag = ">";
        } else if (version.equals("XHTML") || version.equals("XML") || version.equals("WML")) {
            endTag = "/>";
        }
        return endTag;
    }

    public String getFileWithContextRoot(IFile myFile) {
        IVirtualComponent component = ComponentUtilities.findComponent((IResource)myFile);
        IPath filePath = myFile.getFullPath();
        IPath rootFolderPath = WebFileDataUtil.getWebFolderString(component);
        if (rootFolderPath.isPrefixOf(myFile.getFullPath())) {
            filePath = filePath.removeFirstSegments(rootFolderPath.segmentCount());
        }
        if (!WebFileDataUtil.isStaticComponent(component)) {
            String contextRoot = WebFileDataUtil.getContextRootString(component);
            filePath = new Path(contextRoot).append(filePath);
        }
        return filePath.makeAbsolute().toString();
    }

    @Deprecated
    public String getFormattedString(String stringText, String stringCase) {
        if (stringCase.equals("lower")) {
            return stringText.toLowerCase();
        }
        if (stringCase.equals("upper")) {
            return stringText.toUpperCase();
        }
        return stringText;
    }

    public String getFormattedWebFileName() {
        String name = this.getWtRegionData().getWebFileName();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < name.length()) {
            String n = new String(new char[]{name.charAt(i)});
            switch (name.charAt(i)) {
                case '<': {
                    n = "&lt;";
                    break;
                }
                case '>': {
                    n = "&gt;";
                    break;
                }
                case '&': {
                    n = "&amp;";
                    break;
                }
                case '\"': {
                    n = "&quot;";
                    break;
                }
            }
            buf.append(n);
            ++i;
        }
        return buf.toString();
    }

    public String getGeneratorString() {
        return FilesPreferenceUtil.getGenerator();
    }

    public String getNewLine() {
        String newLine = System.getProperty("line.separator");
        if (newLine.length() == 0) {
            newLine = "\r\n";
        }
        return newLine;
    }

    public IWebFileRegionData getWtRegionData() {
        return this.wtRegionData;
    }

    public String getXMLNS() {
        if (this.determineVersion().equals("XHTML")) {
            return " xmlns=\"http://www.w3.org/1999/xhtml\" ";
        }
        return "";
    }

    public boolean includeContentTypeMetaTag() {
        boolean ret = true;
        if (this.getWtRegionData().getMarkupLanguage() != null && this.getWtRegionData().getMarkupLanguage().getID().equals("com.ibm.etools.webtools.wizards.basic.chtml")) {
            ret = false;
        }
        return ret;
    }

    public boolean includeDocTypeTag() {
        if (this.determineVersion().equals("XHTML")) {
            return true;
        }
        return FilesPreferenceUtil.getCheckDocType();
    }

    public boolean includeGeneratorInSource() {
        return FilesPreferenceUtil.getGeneratorOut();
    }

    public boolean isFrameSet() {
        String publicID;
        HTMLDocumentTypeEntry docType = this.getWtRegionData().getDocType();
        return docType != null && (publicID = docType.getPublicId()) != null && (publicID.lastIndexOf("Frameset") != -1 || publicID.lastIndexOf("frameset") != -1 || publicID.lastIndexOf("FRAMESET") != -1);
    }

    public boolean isUTF16() {
        boolean ret = false;
        String encoding = this.getCharacterEncoding();
        if (encoding != null && (encoding = encoding.toUpperCase()).indexOf(UTF16Key) != -1) {
            ret = true;
        }
        return ret;
    }

    public void setWtRegionData(IWebFileRegionData wtRegionData) {
        this.wtRegionData = wtRegionData;
    }
}

