/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.JMethod;
import com.ibm.etools.webtools.wizards.basic.MethodStubDataUtil;
import com.ibm.etools.webtools.wizards.basic.PackageEntity;
import com.ibm.etools.webtools.wizards.util.JavaModelUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;

public class TypeWizardUtil {
    protected ITypeRegionData typeRegionData;
    protected Collection wtImportsList = new Vector();
    protected IPackageFragment wtPackageFragment;
    protected Vector allMethodsList = new Vector();
    protected Vector abstractMethodList = new Vector();
    protected Vector interfaceMethodList = new Vector();
    protected Vector stubMethodList = new Vector();
    protected Vector superConstructorsList = new Vector();
    protected Map usedClasses = new HashMap();

    public TypeWizardUtil() {
    }

    public TypeWizardUtil(ITypeRegionData typeRegionData) {
        this.typeRegionData = typeRegionData;
    }

    public static String[] getImportOrder() {
        String prefValue = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.importorder", null);
        return prefValue.split(";");
    }

    public static int getImportThreshold() {
        String prefValue = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.ondemandthreshold", null);
        return Integer.parseInt(prefValue);
    }

    public static boolean isLowerType(String unqualifiedName) {
        return Character.isLowerCase(unqualifiedName.charAt(0));
    }

    public static boolean lowerTypeCanBeUsed() {
        String prefValue = PreferenceConstants.getPreference((String)"org.eclipse.jdt.ui.ignorelowercasenames", null);
        return Boolean.getBoolean(prefValue);
    }

    public void addAbstractMethod(JMethod method) {
        if (method != null && !this.allMethodsList.contains(method)) {
            this.abstractMethodList.add(method);
            this.allMethodsList.add(method);
        }
    }

    public void addInterfaceMethod(JMethod method) {
        if (method != null && !this.allMethodsList.contains(method)) {
            this.interfaceMethodList.add(method);
            this.allMethodsList.add(method);
        }
    }

    public void addStubMethod(JMethod method) {
        if (method != null && !this.allMethodsList.contains(method)) {
            this.stubMethodList.add(method);
            this.allMethodsList.add(method);
        }
    }

    public void addSuperConstructors(JMethod method) {
        if (method != null && !this.superConstructorsList.contains(method)) {
            this.superConstructorsList.add(method);
        }
    }

    public void addToImportsList(IType type) {
        if (type != null) {
            if (type.getPackageFragment().isDefaultPackage() || type.getPackageFragment().getElementName().equals("")) {
                Iterator iter = this.wtImportsList.iterator();
                while (iter.hasNext()) {
                    IType javaType = (IType)iter.next();
                    if (!javaType.getElementName().equals(type.getElementName())) continue;
                    iter.remove();
                }
                if (!this.wtImportsList.contains(type)) {
                    this.wtImportsList.add(type);
                }
            } else {
                boolean isPresent = false;
                boolean canAdd = true;
                for (IType element : this.wtImportsList) {
                    if (type.getElementName().equals(this.typeRegionData.getPrefix())) {
                        canAdd = false;
                        break;
                    }
                    if (!element.getElementName().equals(type.getElementName())) continue;
                    isPresent = true;
                    canAdd = false;
                    break;
                }
                if (!isPresent && !TypeWizardUtil.lowerTypeCanBeUsed() && TypeWizardUtil.isLowerType(type.getElementName())) {
                    canAdd = false;
                }
                if (canAdd && !this.wtImportsList.contains(type)) {
                    this.wtImportsList.add(type);
                }
            }
        }
    }

    public void addToImportsList(String fullyQualifiedName, ITypeRegionData regionData) {
        try {
            IType type;
            if (fullyQualifiedName != null && (type = regionData.getJavaProject().findType(fullyQualifiedName)) != null) {
                this.addToImportsList(type);
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void addTypeNameInUse(String typeUnqualifiedName, String fullyQualifiedName) {
        if (typeUnqualifiedName != null && !typeUnqualifiedName.equals("") && !this.usedClasses.containsKey(typeUnqualifiedName)) {
            this.usedClasses.put(typeUnqualifiedName, fullyQualifiedName);
        }
    }

    public void clearAll() {
        this.wtImportsList.clear();
        this.usedClasses.clear();
    }

    public JMethod createJConstructor(String accessSpecifier, String[] parameterTypes, String[] parameterNames, String[] exceptions) {
        MethodStubDataUtil dataUtil = new MethodStubDataUtil(this.typeRegionData);
        return dataUtil.createJConstructor(accessSpecifier, this.typeRegionData.getPrefix(), parameterTypes, parameterNames, exceptions);
    }

    public JMethod createJMethod(IMethod method) {
        MethodStubDataUtil dataUtil = new MethodStubDataUtil(this.typeRegionData);
        return dataUtil.createJMethod(method);
    }

    public JMethod createJMethod(String accessSpecifier, String methodName, String[] parameterTypes, String[] parameterNames, String returnType, String[] exceptions, boolean isConstructor) {
        MethodStubDataUtil dataUtil = new MethodStubDataUtil(this.typeRegionData);
        return dataUtil.createJMethod(accessSpecifier, methodName, parameterTypes, parameterNames, returnType, exceptions, isConstructor);
    }

    protected void filterImportsList(ITypeRegionData regionData) {
        IPackageFragment regionDataPackageFrag = regionData.getJavaPackageFragment();
        String regionDataPackageName = regionData.getJavaPackageName();
        this.processInitialImportsList();
        Iterator iter = this.wtImportsList.iterator();
        while (iter.hasNext()) {
            IType javaType = (IType)iter.next();
            IPackageFragment packageFrag = javaType.getPackageFragment();
            if (packageFrag == null || !packageFrag.exists()) continue;
            if (packageFrag.getElementName().equals("") || packageFrag.isDefaultPackage()) {
                this.addTypeNameInUse(javaType.getElementName(), javaType.getElementName());
                if (regionDataPackageName != null && !regionDataPackageName.equals("")) continue;
                iter.remove();
                continue;
            }
            if (javaType.getElementName() != null && javaType.getElementName().equals(regionData.getPrefix())) {
                iter.remove();
                continue;
            }
            if (regionDataPackageFrag != null && regionDataPackageFrag.exists() && packageFrag.getElementName().equals(regionDataPackageName)) {
                iter.remove();
                continue;
            }
            if (!packageFrag.getElementName().equals("java.lang")) continue;
            IType conflictingType = null;
            try {
                conflictingType = regionData.getJavaProject().findType(regionDataPackageName, javaType.getElementName());
            }
            catch (JavaModelException javaModelException) {}
            if (conflictingType != null && conflictingType.exists()) continue;
            iter.remove();
        }
    }

    public IMethod findMethodImplementationInHierarchy(ITypeHierarchy tH, IType thisType, String methodName, String[] parameterTypes, boolean isConstructor) throws JavaModelException {
        IMethod found = JavaModelUtil.findMethod((String)methodName, (String[])parameterTypes, (boolean)isConstructor, (IType)thisType);
        if (found != null && !Flags.isAbstract((int)found.getFlags())) {
            return found;
        }
        return JavaModelUtil.findMethodInHierarchy((ITypeHierarchy)tH, (IType)thisType, (String)methodName, (String[])parameterTypes, (boolean)isConstructor);
    }

    public IMethod findMethodImplementationInHierarchy(JMethod jMethod) {
        IMethod implementedMethod = null;
        IType superClass = this.typeRegionData.getSuperClass();
        try {
            if (superClass != null && superClass.exists()) {
                ITypeHierarchy tH = superClass.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                implementedMethod = this.findMethodImplementationInHierarchy(tH, this.typeRegionData.getSuperClass(), jMethod.getMethodName(), jMethod.getParameterTypes(), jMethod.isConstructor());
            }
        }
        catch (JavaModelException javaModelException) {}
        return implementedMethod;
    }

    public JMethod findSimilarMethod(JMethod jMethod) {
        JMethod ret = null;
        if (jMethod != null) {
            if (jMethod.isConstructor()) {
                if (this.getSuperConstructorsList().contains(jMethod)) {
                    int ind = this.getSuperConstructorsList().indexOf(jMethod);
                    ret = (JMethod)this.getSuperConstructorsList().get(ind);
                }
            } else {
                int ind;
                if (this.getAbstractMethodList().contains(jMethod)) {
                    ind = this.getAbstractMethodList().indexOf(jMethod);
                    ret = (JMethod)this.getAbstractMethodList().get(ind);
                }
                if (this.getInterfaceMethodList().contains(jMethod)) {
                    ind = this.getInterfaceMethodList().indexOf(jMethod);
                    ret = (JMethod)this.getInterfaceMethodList().get(ind);
                }
            }
        }
        return ret;
    }

    public Vector getAbstractMethodList() {
        return this.abstractMethodList;
    }

    public Vector getInterfaceMethodList() {
        return this.interfaceMethodList;
    }

    public Vector getStubMethodList() {
        return this.stubMethodList;
    }

    public Vector getSuperConstructorsList() {
        return this.superConstructorsList;
    }

    public IType getType(String qualifiedName) {
        IType thisType = null;
        try {
            thisType = this.typeRegionData.getJavaProject().findType(qualifiedName);
        }
        catch (JavaModelException javaModelException) {}
        return thisType;
    }

    public String getTypeNameToUse(IType type) {
        if (type != null && type.exists()) {
            return this.getTypeNameToUse(type.getElementName(), type.getFullyQualifiedName('.'));
        }
        return "java.lang.Object";
    }

    public String getTypeNameToUse(String unqualifiedName, String qualifiedName) {
        String ret = qualifiedName;
        String packageName = qualifiedName;
        try {
            packageName = qualifiedName.substring(0, qualifiedName.indexOf(unqualifiedName));
        }
        catch (Exception exception) {}
        if (packageName == null || packageName.equals("")) {
            ret = unqualifiedName;
        } else if (!this.isTypeNameAlreadyInUseByAnotherClass(unqualifiedName, qualifiedName)) {
            if (!TypeWizardUtil.isLowerType(unqualifiedName)) {
                this.addTypeNameInUse(unqualifiedName, qualifiedName);
                ret = unqualifiedName;
            } else {
                if (TypeWizardUtil.lowerTypeCanBeUsed()) {
                    this.addTypeNameInUse(unqualifiedName, qualifiedName);
                }
                ret = unqualifiedName;
            }
        }
        return ret;
    }

    public boolean isMethodImplementedInHierarchy(JMethod jMethod) {
        boolean ret = false;
        IMethod foundMethod = this.findMethodImplementationInHierarchy(jMethod);
        if (foundMethod != null && foundMethod.exists()) {
            ret = true;
        }
        return ret;
    }

    public boolean isTypeNameAlreadyInUseByAnotherClass(String typeUnqualifiedName, String fullyQualifiedName) {
        boolean isTypeNameAlreadyInUseByAnotherClass = false;
        String packageName = fullyQualifiedName;
        try {
            packageName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf(typeUnqualifiedName));
        }
        catch (Exception exception) {}
        if (typeUnqualifiedName != null) {
            if (this.usedClasses.containsKey(typeUnqualifiedName)) {
                isTypeNameAlreadyInUseByAnotherClass = !((String)this.usedClasses.get(typeUnqualifiedName)).equals(fullyQualifiedName);
                return isTypeNameAlreadyInUseByAnotherClass;
            }
            boolean isItInImportsList = false;
            for (IType element : this.wtImportsList) {
                if (!element.getElementName().equals(typeUnqualifiedName)) continue;
                isItInImportsList = true;
                isTypeNameAlreadyInUseByAnotherClass = !element.getFullyQualifiedName('.').equals(fullyQualifiedName);
                break;
            }
            if (isItInImportsList) {
                return isTypeNameAlreadyInUseByAnotherClass;
            }
            isTypeNameAlreadyInUseByAnotherClass = packageName == null || packageName.equals("") ? false : (packageName.equals("java.lang.") ? false : !packageName.equals(String.valueOf(this.typeRegionData.getJavaPackageName()) + "."));
        }
        return isTypeNameAlreadyInUseByAnotherClass;
    }

    public Collection processImportsList(ITypeRegionData regionData) {
        Vector<PackageEntity> listOfPackageEntities = new Vector<PackageEntity>();
        this.filterImportsList(regionData);
        for (IType javaType : this.wtImportsList) {
            IPackageFragment packageFrag = javaType.getPackageFragment();
            if (packageFrag == null || !packageFrag.exists()) continue;
            PackageEntity entity = null;
            for (PackageEntity element : listOfPackageEntities) {
                if (!element.packageFragment.getElementName().equals(packageFrag.getElementName())) continue;
                entity = element;
                break;
            }
            if (entity == null) {
                entity = new PackageEntity();
                listOfPackageEntities.add(entity);
            }
            entity.packageFragment = packageFrag;
            entity.listOfTypes.add(javaType);
        }
        return this.sortPackageEntityList(listOfPackageEntities);
    }

    protected void processInitialImportsList() {
        Vector initialImportsList = new Vector();
        for (JMethod jMethod : this.superConstructorsList) {
            initialImportsList.addAll(jMethod.getImportsList());
        }
        for (JMethod jMethod : this.abstractMethodList) {
            initialImportsList.addAll(jMethod.getImportsList());
        }
        for (JMethod jMethod : this.interfaceMethodList) {
            initialImportsList.addAll(jMethod.getImportsList());
        }
        for (JMethod jMethod : this.stubMethodList) {
            initialImportsList.addAll(jMethod.getImportsList());
        }
        for (IType element : initialImportsList) {
            this.addToImportsList(element);
        }
    }

    public void removeSimilarMethod(JMethod jMethod) {
        if (jMethod != null) {
            if (jMethod.isConstructor()) {
                if (this.getSuperConstructorsList().contains(jMethod)) {
                    this.getSuperConstructorsList().remove(jMethod);
                }
            } else {
                if (this.getAbstractMethodList().contains(jMethod)) {
                    this.getAbstractMethodList().remove(jMethod);
                    this.allMethodsList.remove(jMethod);
                }
                if (this.getInterfaceMethodList().contains(jMethod)) {
                    this.getInterfaceMethodList().remove(jMethod);
                    this.allMethodsList.remove(jMethod);
                }
            }
        }
    }

    protected Collection sortPackageEntityList(Vector listOfPackageEntities) {
        for (PackageEntity packageEntity : listOfPackageEntities) {
            if (packageEntity.listOfTypes.size() > TypeWizardUtil.getImportThreshold()) continue;
            IType[] listOfJavaTypes = packageEntity.listOfTypes.toArray(new IType[packageEntity.listOfTypes.size()]);
            int i = 0;
            while (i < listOfJavaTypes.length) {
                int j = 0;
                while (j < listOfJavaTypes.length) {
                    String x = listOfJavaTypes[i].getElementName();
                    String y = listOfJavaTypes[j].getElementName();
                    if (x != null && y != null && x.compareTo(y) < 0) {
                        IType temp = listOfJavaTypes[i];
                        listOfJavaTypes[i] = listOfJavaTypes[j];
                        listOfJavaTypes[j] = temp;
                    }
                    ++j;
                }
                packageEntity.listOfTypes = Arrays.asList(listOfJavaTypes);
                ++i;
            }
        }
        String[] sortPriority = TypeWizardUtil.getImportOrder();
        Vector newList = new Vector();
        int i = 0;
        while (i < sortPriority.length) {
            Vector<PackageEntity> sortVector = new Vector<PackageEntity>();
            Iterator iter = listOfPackageEntities.iterator();
            while (iter.hasNext()) {
                PackageEntity packageEntity = (PackageEntity)iter.next();
                String packageName = packageEntity.packageFragment.getElementName();
                if (!packageName.startsWith(sortPriority[i]) || !packageName.equals(sortPriority[i]) && packageName.charAt(sortPriority[i].length()) != '.') continue;
                packageEntity.sortType = sortPriority[i];
                sortVector.add(packageEntity);
                iter.remove();
            }
            Collections.sort(sortVector, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof PackageEntity && arg1 instanceof PackageEntity) {
                        IPackageFragment pf0 = ((PackageEntity)arg0).packageFragment;
                        IPackageFragment pf1 = ((PackageEntity)arg1).packageFragment;
                        if (pf0 != null && pf1 != null) {
                            return pf0.getElementName().compareTo(pf1.getElementName());
                        }
                    }
                    return 0;
                }

                @Override
                public boolean equals(Object arg0) {
                    return false;
                }
            });
            newList.addAll(sortVector);
            ++i;
        }
        newList.addAll(listOfPackageEntities);
        return newList;
    }
}

