/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.webtools.wizards.IWebRegionWizard;
import com.ibm.etools.webtools.wizards.WebtoolsWizardsPlugin;
import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;
import com.ibm.etools.webtools.wizards.basic.util.ProjectValidationUtil;
import com.ibm.etools.webtools.wizards.impl.NewRegionDataWithPackagePage;
import com.ibm.etools.webtools.wizards.util.JavaModelUtil;
import com.ibm.etools.webtools.wizards.util.TypeSearchEngine;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public abstract class TypeRegionDataPage
extends NewRegionDataWithPackagePage
implements ISelectionChangedListener {
    protected Label wtClassNameLabel;
    protected Text wtClassNameText;
    protected Text wtSuperClassText;
    protected Label wtSuperClassLabel;
    protected Button wtSuperClassButton;
    protected Label fSuperSeparatorLabel;
    protected ProjectValidationUtil wtProjectValidationUtil = new ProjectValidationUtil(new String[]{"java.lang.Object"});
    protected boolean wtValidProject = false;
    protected boolean wtNeedToInitialize = false;
    protected ITypeHierarchy[] wtTypeHierarchies;

    public TypeRegionDataPage() {
        this("type_region_data_page");
    }

    public TypeRegionDataPage(String pageName) {
        super(pageName);
    }

    public TypeRegionDataPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createClassNameControl(Composite composite) {
        this.wtClassNameLabel = new Label(composite, 0);
        this.wtClassNameLabel.setText(ResourceHandler.Class_Name__2);
        this.wtClassNameText = new Text(composite, 2048);
        if (this.getRegionData().getPrefix() != null) {
            this.wtClassNameText.setText(this.getRegionData().getPrefix());
        }
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.wtClassNameText.setLayoutData((Object)data);
        this.wtClassNameText.addListener(24, (Listener)this);
        TypeRegionDataPage.createSpacer((Composite)composite);
    }

    protected void createPageControl(Composite composite) {
        this.createContainerSelectionControl(composite, ResourceHandler.Folder__8);
        this.createJavaPackageSelectionControl(composite);
        this.createClassNameControl(composite);
        this.fSuperSeparatorLabel = new Label(composite, 258);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.fSuperSeparatorLabel.setLayoutData((Object)data);
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (e.widget instanceof Composite) {
                    final Composite c = (Composite)e.widget;
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            int width;
                            if (c != null && !c.isDisposed() && (width = c.getSize().x - 2 * ((GridLayout)c.getLayout()).marginWidth) > 10) {
                                GridData data = (GridData)(this).TypeRegionDataPage.this.fSuperSeparatorLabel.getLayoutData();
                                data.widthHint = width;
                                c.layout();
                            }
                        }
                    });
                }
            }
        });
        this.createSuperClassControl(composite);
    }

    protected void createSuperClassControl(Composite composite) {
        this.wtSuperClassLabel = new Label(composite, 0);
        this.wtSuperClassLabel.setText(ResourceHandler.Superclass__16);
        this.wtSuperClassText = new Text(composite, 2048);
        if (this.getTypeRegionData().getSuperClass() != null) {
            this.wtSuperClassText.setText(this.getTypeRegionData().getSuperClass().getFullyQualifiedName());
        }
        if (this.wtSuperClassText != null && this.wtSuperClassText.getText().equals("")) {
            this.wtSuperClassText.setText(this.getTypeRegionData().getDefaultSuperClassName());
        }
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.wtSuperClassText.setLayoutData((Object)data);
        this.wtSuperClassText.addListener(24, (Listener)this);
        this.wtSuperClassButton = new Button(composite, 8);
        this.wtSuperClassButton.setText(ResourceHandler.Browse_17);
        this.wtSuperClassButton.addListener(13, (Listener)this);
        data = new GridData(128);
        this.wtSuperClassButton.setLayoutData((Object)data);
    }

    private StandardJavaElementContentProvider getContainerContentProvider() {
        return new StandardJavaElementContentProvider(){

            public Object[] getChildren(Object element) {
                Object[] ret = super.getChildren(element);
                if (ret != NO_CHILDREN && ret instanceof IJavaProject[]) {
                    ret = TypeRegionDataPage.this.wtProjectValidationUtil.getValidJavaProjects();
                }
                return ret;
            }
        };
    }

    protected ISelectionStatusValidator getContainerDialogSelectionValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                Status ret = new Status(4, "com.ibm.etools.struts.webregionwizard", 4, ResourceHandler.Choose_a_Java_Source_Folder_19, null);
                try {
                    IJavaProject jProject;
                    IPackageFragmentRoot root;
                    if (selection[0] instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)selection[0]).getKind() == 1) {
                        ret = new Status(0, "com.ibm.etools.struts.webregionwizard", 0, "", null);
                    }
                    if (selection[0] instanceof IJavaProject && (root = (jProject = (IJavaProject)selection[0]).getPackageFragmentRoot((IResource)jProject.getProject())) != null && root.exists()) {
                        ret = new Status(0, "com.ibm.etools.struts.webregionwizard", 0, "", null);
                    }
                }
                catch (Exception exception) {}
                return ret;
            }
        };
    }

    protected ViewerFilter getContainerDialogViewerFilter() {
        Class[] acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        return new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean ret = super.select(viewer, parent, element);
                if (element instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)element;
                    String error = TypeRegionDataPage.this.wtProjectValidationUtil.whyCanINotUseProject(javaProject.getProject());
                    ret = error == null;
                } else if (element instanceof IPackageFragmentRoot) {
                    try {
                        ret = ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        ErrorDialog.openError((Shell)TypeRegionDataPage.this.getShell(), (String)ResourceHandler.Error_21, null, (IStatus)e.getStatus());
                        ret = false;
                    }
                }
                return ret;
            }
        };
    }

    protected ITypeHierarchy[] getTypeHierarchies() {
        if (this.wtTypeHierarchies == null) {
            int numberOfInterfaces = this.getTypeRegionData().getDefaultSuperInterfaceNames().length;
            this.wtTypeHierarchies = new ITypeHierarchy[numberOfInterfaces];
            IJavaProject jP = this.getRegionData().getJavaProject();
            if (jP != null) {
                int i = 0;
                while (i < numberOfInterfaces) {
                    try {
                        IType defaultType = jP.findType(this.getTypeRegionData().getDefaultSuperInterfaceNames()[i]);
                        if (defaultType != null) {
                            this.wtTypeHierarchies[i] = defaultType.newTypeHierarchy(jP, (IProgressMonitor)new NullProgressMonitor());
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                    ++i;
                }
            }
        }
        return this.wtTypeHierarchies;
    }

    protected final ITypeRegionData getTypeRegionData() {
        return (ITypeRegionData)this.getRegionData();
    }

    protected void handleContainerBrowseButtonPressed() {
        ISelectionStatusValidator validator = this.getContainerDialogSelectionValidator();
        ViewerFilter filter = this.getContainerDialogViewerFilter();
        StandardJavaElementContentProvider provider = this.getContainerContentProvider();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator(validator);
        dialog.setSorter((ViewerSorter)new JavaElementSorter());
        dialog.setTitle(ResourceHandler.Container_Selection_24);
        dialog.setMessage(ResourceHandler.Choose_a_Container__25);
        dialog.addFilter(filter);
        IJavaModel root = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setInput((Object)root);
        IJavaProject javaProject = this.getTypeRegionData().getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelection((Object)javaProject);
        }
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            try {
                IContainer resource = null;
                if (element instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot pFrag = (IPackageFragmentRoot)element;
                    resource = (IContainer)pFrag.getUnderlyingResource();
                }
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    resource = (IContainer)jproject.getUnderlyingResource();
                }
                if (resource != null) {
                    this.dealWithSelectedContainerResource(resource);
                }
            }
            catch (Exception exception) {}
        }
    }

    public void handleEvent(Event ev) {
        Widget source = ev.widget;
        if (source == this.wtSuperClassButton) {
            this.handleSuperClassBrowseButtonPressed();
        } else if (source == this.wtClassNameText) {
            this.getRegionData().setPrefix(this.wtClassNameText.getText());
        } else {
            super.handleEvent(ev);
        }
        this.setPageComplete(this.validatePage());
    }

    protected void handleSuperClassBrowseButtonPressed() {
        this.getControl().setCursor(new Cursor((Device)this.getShell().getDisplay(), 1));
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return;
        }
        IJavaSearchScope scope = TypeSearchEngine.createJavaSearchScopeForAProject((IJavaProject)root.getJavaProject(), (boolean)true, (boolean)true);
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, 5);
        dialog.setTitle(ResourceHandler.Superclass_selection_26);
        dialog.setMessage(ResourceHandler.Choose_a_type__27);
        if (this.getTypeRegionData().getSuperClass() != null) {
            dialog.setFilter(this.getTypeRegionData().getSuperClass().getElementName());
        }
        if (dialog.open() == 0) {
            this.getTypeRegionData().setSuperClass((IType)dialog.getFirstResult());
            if (this.getTypeRegionData().getSuperClass() != null) {
                String typeName = this.getTypeRegionData().getSuperClass().getFullyQualifiedName('.');
                this.wtSuperClassText.setText(typeName);
            } else {
                this.wtSuperClassText.setText("");
            }
            this.getControl().setCursor(null);
            return;
        }
        this.getControl().setCursor(null);
        this.getTypeRegionData().setSuperClass(null);
    }

    protected void initContent() {
        super.initContent();
        if (this.wtClassNameText != null && this.getTypeRegionData().getPrefix() != null) {
            this.wtClassNameText.setText(this.getTypeRegionData().getPrefix());
        }
        if (this.wtSuperClassText != null && this.wtSuperClassText.getText() == null && this.getTypeRegionData().getSuperClass() != null) {
            this.wtSuperClassText.setText(this.getTypeRegionData().getSuperClass().getFullyQualifiedName());
        }
    }

    protected void initInterfaces() {
    }

    protected void newContainerSelection(IContainer container) {
        try {
            LinkedList<String> modifiedProperties = new LinkedList<String>();
            IContainer oldContainer = this.getRegionData().getDestinationFolder();
            this.getRegionData().setDestinationFolder(container);
            modifiedProperties.add("destinationFolder");
            this.setPackageFragment(this.getPackageFragmentRoot().getPackageFragment(this.wtJavaPackageText.getText()), this.wtJavaPackageText.getText());
            if ((oldContainer == null || !oldContainer.getFullPath().equals((Object)container.getFullPath())) && this.getWizard() instanceof IWebRegionWizard) {
                ((IWebRegionWizard)this.getWizard()).fireRegionDataChangedEvent(modifiedProperties);
            }
        }
        catch (Exception exception) {
            this.fPageStatus.addErrorMessage(ResourceHandler.Must_be_within_a_Java_Project_2);
        }
    }

    protected String resolvePathForErrorMessage(IPath ppath) {
        String ret = null;
        IPath validPath = ppath;
        while (validPath.segmentCount() > 0) {
            IResource resource = WebtoolsWizardsPlugin.getWorkspace().getRoot().findMember(validPath);
            if (resource != null && resource.exists() && resource instanceof IContainer) {
                IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)resource.getProject());
                if (javaProject == null) {
                    ret = ResourceHandler.Must_be_within_a_Java_Project_2;
                    break;
                }
                List sourceContainers = JemProjectUtilities.getSourceContainers((IProject)resource.getProject());
                IContainer sourceContainer = (IContainer)sourceContainers.get(0);
                ret = NLS.bind((String)ResourceHandler.Must_be_in_sourceFolder, (Object)sourceContainer.getFullPath().lastSegment());
                break;
            }
            validPath = validPath.removeLastSegments(1);
        }
        return ret;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtonStates();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.wtClassNameText != null) {
            this.wtClassNameText.setFocus();
            this.wtClassNameText.selectAll();
        }
    }

    protected void updateButtonStates() {
        super.updateButtonStates();
        TypeRegionDataPage.setEnabled((Control)this.wtSuperClassButton, (this.getRegionData().getProject() != null ? 1 : 0) != 0);
    }

    protected String validateClassNameInequality(IType type) {
        String ret = null;
        try {
            String newClassName = String.valueOf(this.getTypeRegionData().getJavaPackageName()) + "." + this.getTypeRegionData().getPrefix();
            if (newClassName != null && !newClassName.equals("") && newClassName.equals(type.getFullyQualifiedName('.'))) {
                ret = NLS.bind((String)ResourceHandler.Class_name_causes_cycle, (Object[])new Object[]{this.getTypeRegionData().getPrefix(), this.getTypeRegionData().getPrefix()});
            }
        }
        catch (NullPointerException nullPointerException) {}
        return ret;
    }

    protected String validateTypeHierarchy(IType type) {
        String errorString = null;
        int i = 0;
        while (i < this.getTypeHierarchies().length) {
            if (this.getTypeHierarchies()[i] != null && type != null && !type.getFullyQualifiedName('.').equals("java.lang.Object") && this.getTypeHierarchies()[i].contains(type)) {
                return errorString;
            }
            ++i;
        }
        if (this.getTypeHierarchies().length < 1) {
            return errorString;
        }
        String interfaceString = "";
        int i2 = 0;
        while (i2 < this.getTypeRegionData().getDefaultSuperInterfaceNames().length) {
            String interfaceName = this.getTypeRegionData().getDefaultSuperInterfaceNames()[i2];
            if (this.getTypeRegionData().getDefaultSuperInterfaceNames().length > 2) {
                interfaceName = interfaceName.substring(interfaceName.lastIndexOf(46) + 1);
            }
            interfaceString = String.valueOf(interfaceString) + interfaceName;
            if (i2 < this.getTypeRegionData().getDefaultSuperInterfaceNames().length - 1) {
                interfaceString = String.valueOf(interfaceString) + ", ";
            }
            ++i2;
        }
        errorString = this.getTypeRegionData().getDefaultSuperInterfaceNames().length == 1 ? NLS.bind((String)ResourceHandler.Interface_SuperClass_Implement, (Object)interfaceString) : NLS.bind((String)ResourceHandler.Interface_SuperClass_Implement_multi, (Object)interfaceString);
        return errorString;
    }

    protected String whyCanINotUse(IContainer container) {
        return this.wtProjectValidationUtil.whyCanINotUseJava(container);
    }

    protected String whyCanINotUseSuperTypeName() {
        if (this.wtSuperClassText == null) {
            return null;
        }
        if (this.wtSuperClassText.getText() == null || this.wtSuperClassText.getText().trim().length() == 0) {
            try {
                IType type;
                IJavaProject javaProject = this.getRegionData().getJavaProject();
                if (javaProject != null && (type = javaProject.findType(this.getTypeRegionData().getBaseClassForJavaType())) != null) {
                    this.getTypeRegionData().setSuperClass(type);
                    String errorString = this.validateClassNameInequality(type);
                    if (errorString != null) {
                        this.fPageStatus.addErrorMessage(errorString);
                        return errorString;
                    }
                    errorString = this.validateTypeHierarchy(type);
                    if (errorString != null) {
                        this.fPageStatus.addErrorMessage(errorString);
                        return errorString;
                    }
                    return null;
                }
            }
            catch (Exception exception) {}
            this.getTypeRegionData().setSuperClass(null);
            return null;
        }
        String errorString = ResourceHandler.Invalid_Super_Class_42;
        IStatus val = JavaConventions.validateJavaTypeName((String)this.wtSuperClassText.getText());
        if (val.getSeverity() == 4) {
            errorString = NLS.bind((String)ResourceHandler.Invalid_Super_Class__43, (Object)val.getMessage());
            this.getTypeRegionData().setSuperClass(null);
            this.fPageStatus.addErrorMessage(errorString);
            return errorString;
        }
        val.matches(2);
        IJavaProject jP = this.getRegionData().getJavaProject();
        IType type = null;
        if (jP != null) {
            try {
                type = jP.findType(String.valueOf(this.getRegionData().getJavaPackageName()) + "." + this.wtSuperClassText.getText());
                if (type == null) {
                    type = jP.findType("java.lang." + this.wtSuperClassText.getText());
                }
            }
            catch (JavaModelException javaModelException) {}
            try {
                if (type == null) {
                    type = jP.findType(this.wtSuperClassText.getText());
                }
            }
            catch (JavaModelException javaModelException) {}
            if (type == null) {
                this.getTypeRegionData().setSuperClass(null);
                errorString = ResourceHandler.Invalid_Super_Class_46;
            } else {
                try {
                    if (!type.isClass()) {
                        this.getTypeRegionData().setSuperClass(null);
                        errorString = ResourceHandler.Invalid_Super_Class_47;
                    } else if (!Flags.isFinal((int)type.getFlags())) {
                        if (JavaModelUtil.isVisible((IMember)type, (IPackageFragment)this.getPackageFragment())) {
                            errorString = this.validateClassNameInequality(type);
                            if (errorString == null) {
                                errorString = this.validateTypeHierarchy(type);
                                if (errorString == null) {
                                    this.getTypeRegionData().setSuperClass(type);
                                } else {
                                    this.getTypeRegionData().setSuperClass(null);
                                }
                            } else {
                                this.getTypeRegionData().setSuperClass(null);
                            }
                        } else {
                            errorString = "Super Class Is Not Visible";
                            this.getTypeRegionData().setSuperClass(null);
                        }
                    } else {
                        this.getTypeRegionData().setSuperClass(null);
                        errorString = ResourceHandler.Super_Class_cannot_be_final_48;
                    }
                }
                catch (JavaModelException javaModelException) {
                    this.getTypeRegionData().setSuperClass(null);
                }
            }
        }
        if (errorString != null) {
            this.fPageStatus.addErrorMessage(errorString);
        }
        return errorString;
    }

    protected String whyCanINotUseTypeName() {
        ICompilationUnit classFile;
        boolean qualified;
        String ret = null;
        if (this.wtClassNameText == null) {
            return null;
        }
        IStatus val = JavaConventions.validateJavaTypeName((String)this.wtClassNameText.getText());
        boolean bl = qualified = this.wtClassNameText.getText().lastIndexOf(".") > -1;
        if (qualified) {
            ret = String.valueOf(ResourceHandler.Invalid_Type_Name__34) + " " + ResourceHandler.Fully_qualified_class_names_not_allowed_35;
            this.fPageStatus.addErrorMessage(ret);
            return ret;
        }
        if (val.getSeverity() == 4) {
            ret = String.valueOf(ResourceHandler.Invalid_Type_Name__34) + " " + val.getMessage();
            this.fPageStatus.addErrorMessage(ret);
            return ret;
        }
        if (val.matches(2)) {
            this.fPageStatus.addWarning(val);
        }
        if (this.getRegionData().getJavaPackageFragment() != null && (classFile = this.getRegionData().getJavaPackageFragment().getCompilationUnit(String.valueOf(this.getRegionData().getPrefix()) + ".java")).exists()) {
            ret = NLS.bind((String)ResourceHandler.The_file_already_exists_1, (Object)classFile.getElementName());
            this.fPageStatus.addErrorMessage(ret);
            return ret;
        }
        return ret;
    }

    protected String whyIsPageNotComplete() {
        String ret = super.whyIsPageNotComplete();
        if (!this.fPageStatus.isError()) {
            if (!this.wtValidProject) {
                this.wtValidProject = true;
            }
            if (this.wtNeedToInitialize) {
                this.wtNeedToInitialize = false;
                this.initInterfaces();
            }
            ret = this.whyCanINotUseTypeName();
            if (!this.fPageStatus.isError()) {
                ret = this.whyCanINotUseSuperTypeName();
            }
            if (!this.fPageStatus.isError() && this.getTypeRegionData().isAbstract() && this.getTypeRegionData().isFinal()) {
                ret = ResourceHandler.Type_cannot_be_both_abstract_and_final_50;
                this.fPageStatus.addErrorMessage(ret);
            }
        } else if (!this.wtValidProject) {
            this.wtNeedToInitialize = true;
        }
        return ret;
    }
}

