/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.regiondata.impl.WTRegionData;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class TypeRegionData
extends WTRegionData
implements ITypeRegionData {
    protected Vector wtSuperInterfaces = new Vector();
    protected IType wtSuperClass;
    protected boolean wtAbstract = false;
    protected boolean wtFinal = false;
    protected boolean wtPublic = true;
    protected String wtDefaultSuperClassName = "java.lang.Object";
    protected String[] wtDefaultSuperInterfaceNames = new String[0];
    protected boolean wtCreateInheritedAbstractStubs = true;
    protected boolean wtCreateSuperClassConstructors = false;
    protected boolean wtAddToWebXML = true;
    private String wtBaseClassForJavaType = "java.lang.Object";

    public static IType findType(IJavaProject jproject, String fullyQualifiedName) throws JavaModelException {
        String pathStr = String.valueOf(fullyQualifiedName.replace('.', '/')) + ".java";
        IJavaElement jelement = jproject.findElement((IPath)new Path(pathStr));
        if (jelement == null) {
            IType res;
            IType type;
            String qualifier = Signature.getQualifier((String)fullyQualifiedName);
            if (qualifier.length() > 0 && (type = TypeRegionData.findType(jproject, qualifier)) != null && (res = type.getType(Signature.getSimpleName((String)fullyQualifiedName))).exists()) {
                return res;
            }
        } else {
            if (jelement.getElementType() == 5) {
                String simpleName = Signature.getSimpleName((String)fullyQualifiedName);
                return ((ICompilationUnit)jelement).getType(simpleName);
            }
            if (jelement.getElementType() == 6) {
                return ((IClassFile)jelement).getType();
            }
        }
        return null;
    }

    @Override
    public void addSuperInterface(IType type) {
        if (type != null && !this.isSuperInterfaceAdded(type.getFullyQualifiedName())) {
            this.wtSuperInterfaces.add(type);
        }
    }

    @Override
    public String getBaseClassForJavaType() {
        return this.wtBaseClassForJavaType;
    }

    @Override
    public String getDefaultSuperClassName() {
        return this.wtDefaultSuperClassName;
    }

    @Override
    public String[] getDefaultSuperInterfaceNames() {
        return this.wtDefaultSuperInterfaceNames;
    }

    public IPackageFragmentRoot getJavaPackageFragmentRoot() {
        if (this.wtPackageFragmentRoot == null && this.getJavaProject() != null && this.getDestinationFolder() != null) {
            this.wtPackageFragmentRoot = this.getJavaProject().getPackageFragmentRoot((IResource)this.getDestinationFolder());
        }
        return this.wtPackageFragmentRoot;
    }

    @Override
    public IType getSuperClass() {
        if (this.wtSuperClass == null) {
            this.wtSuperClass = this.loadDefaultSuperClass();
        }
        return this.wtSuperClass;
    }

    @Override
    public IType[] getSuperInterfaces() {
        return this.wtSuperInterfaces.toArray(new IType[this.wtSuperInterfaces.size()]);
    }

    @Override
    public boolean isAbstract() {
        return this.wtAbstract;
    }

    public boolean isAddToWebXML() {
        return this.wtAddToWebXML;
    }

    @Override
    public boolean isCreateInheritedAbstractStubs() {
        return this.wtCreateInheritedAbstractStubs;
    }

    @Override
    public boolean isCreateSuperClassConstructors() {
        return this.wtCreateSuperClassConstructors;
    }

    @Override
    public boolean isFinal() {
        return this.wtFinal;
    }

    @Override
    public boolean isPublic() {
        return this.wtPublic;
    }

    protected boolean isSuperInterfaceAdded(String full_signature) {
        boolean ret = false;
        int i = 0;
        while (i < this.wtSuperInterfaces.size()) {
            if (((IType)this.wtSuperInterfaces.get(i)).getFullyQualifiedName().equals(full_signature)) {
                ret = true;
                break;
            }
            ++i;
        }
        return ret;
    }

    protected IType loadDefaultSuperClass() {
        IJavaProject javaProject = this.getJavaProject();
        IType ret_type = null;
        if (javaProject != null) {
            try {
                ret_type = TypeRegionData.findType(this.getJavaProject(), this.getDefaultSuperClassName());
            }
            catch (JavaModelException javaModelException) {}
        }
        return ret_type;
    }

    @Override
    public void removeSuperInterface(IType type) {
        this.wtSuperInterfaces.remove(type);
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.wtAbstract = isAbstract;
    }

    @Override
    public void setAddToWebXML(boolean addToWebXML) {
        this.wtAddToWebXML = addToWebXML;
    }

    @Override
    public void setBaseClassForJavaType(String defaultSuperClass) {
        this.wtBaseClassForJavaType = defaultSuperClass;
    }

    @Override
    public void setCreateInheritedAbstractStubs(boolean createInheritedAbstractStubs) {
        this.wtCreateInheritedAbstractStubs = createInheritedAbstractStubs;
    }

    @Override
    public void setCreateSuperClassConstructors(boolean createSuperClassConstructors) {
        this.wtCreateSuperClassConstructors = createSuperClassConstructors;
    }

    @Override
    public void setDefaultSuperClassName(String defaultSuperClassName) {
        this.wtDefaultSuperClassName = defaultSuperClassName;
    }

    @Override
    public void setDefaultSuperInterfaceNames(String[] defaultSuperInterfaceNames) {
        this.wtDefaultSuperInterfaceNames = defaultSuperInterfaceNames;
    }

    @Override
    public void setFinal(boolean isFinal) {
        this.wtFinal = isFinal;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.wtPublic = isPublic;
    }

    @Override
    public void setSuperClass(IType type) {
        this.wtSuperClass = type;
    }

    @Override
    public void setSuperInterfaces(IType[] types) {
        this.wtSuperInterfaces.removeAllElements();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                this.wtSuperInterfaces.add(types[i]);
                ++i;
            }
        }
    }
}

