/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.struts.webregionwizard.Activator;
import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.JMethod;
import com.ibm.etools.webtools.wizards.basic.PackageEntity;
import com.ibm.etools.webtools.wizards.basic.TypeWizardUtil;
import com.ibm.etools.webtools.wizards.regiondata.IWTRegionData;
import com.ibm.etools.webtools.wizards.util.ViewBeanDataUtil;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

public class TypeDataUtil
extends ViewBeanDataUtil {
    protected TypeWizardUtil typeWizardUtil;

    public TypeDataUtil(ITypeRegionData regionData, TypeWizardUtil typeWizardUtil) {
        super((IWTRegionData)regionData);
        this.typeWizardUtil = typeWizardUtil;
        this.processType();
    }

    public TypeDataUtil(ITypeRegionData regionData, TypeWizardUtil typeWizardUtil, boolean canProcessType) {
        super((IWTRegionData)regionData);
        this.typeWizardUtil = typeWizardUtil;
        if (canProcessType) {
            this.processType();
        }
    }

    public static String getFullyQualifiedName(IType type) {
        if (type == null) {
            return "";
        }
        String prefixName = TypeDataUtil.getFullyQualifiedName(type.getDeclaringType());
        if (prefixName == null || prefixName.equals("")) {
            return type.getElementName();
        }
        return String.valueOf(prefixName) + "." + type.getElementName();
    }

    public static String getQualifierName(IType type) {
        String packageName = type.getPackageFragment().getElementName();
        String suffixName = TypeDataUtil.getFullyQualifiedName(type.getDeclaringType());
        if (packageName == null || packageName.equals("")) {
            return suffixName;
        }
        if (suffixName == null || suffixName.equals("")) {
            return packageName;
        }
        return String.valueOf(packageName) + "." + TypeDataUtil.getFullyQualifiedName(type.getDeclaringType());
    }

    public JMethod[] getAbstractMethods() {
        Vector abstractMethodList = this.typeWizardUtil.getAbstractMethodList();
        return abstractMethodList.toArray(new JMethod[abstractMethodList.size()]);
    }

    protected IMethod[] getAllInterfaceMethods(IType superInterface) {
        Hashtable<String, IMethod> methods = new Hashtable<String, IMethod>();
        try {
            ITypeHierarchy typeHierarchy = superInterface.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            if (typeHierarchy != null) {
                IType[] types = typeHierarchy.getAllSuperInterfaces(superInterface);
                int i = 0;
                while (i < types.length) {
                    IMethod[] newMethods = types[i].getMethods();
                    int j = 0;
                    while (j < newMethods.length) {
                        methods.put(String.valueOf(newMethods[j].getSignature()) + newMethods[j].getElementName(), newMethods[j]);
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException ex) {
            Activator.log((Exception)((Object)ex));
        }
        return methods.values().toArray(new IMethod[methods.values().size()]);
    }

    public String getExtendsString() {
        String ret = "";
        if (this.getTypeRegionData().getSuperClass() != null && !this.getTypeRegionData().getSuperClass().getFullyQualifiedName().equals("java.lang.Object")) {
            ret = "extends " + this.typeWizardUtil.getTypeNameToUse(this.getTypeRegionData().getSuperClass());
        }
        return ret;
    }

    public String getImplementsString() {
        String ret = "";
        if (this.getTypeRegionData().getSuperInterfaces() != null && this.getTypeRegionData().getSuperInterfaces().length > 0) {
            ret = "implements ";
            int i = 0;
            while (i < this.getTypeRegionData().getSuperInterfaces().length) {
                ret = String.valueOf(ret) + this.typeWizardUtil.getTypeNameToUse(this.getTypeRegionData().getSuperInterfaces()[i]);
                if (i < this.getTypeRegionData().getSuperInterfaces().length - 1) {
                    ret = String.valueOf(ret) + ", ";
                }
                ++i;
            }
        }
        return ret;
    }

    public String getImportsString() {
        StringBuffer importStatement = new StringBuffer("");
        Collection listOfImports = this.typeWizardUtil.processImportsList(this.getTypeRegionData());
        Object[] packageObjects = listOfImports.toArray();
        if (packageObjects.length > 0) {
            String sortType = ((PackageEntity)packageObjects[0]).sortType;
            int i = 0;
            while (i < packageObjects.length) {
                PackageEntity packageEntity = (PackageEntity)packageObjects[i];
                if (packageEntity.listOfTypes.size() <= TypeWizardUtil.getImportThreshold()) {
                    for (IType javaType : packageEntity.listOfTypes) {
                        importStatement.append("import " + javaType.getFullyQualifiedName('.') + ";" + System.getProperties().getProperty("line.separator"));
                    }
                } else {
                    importStatement.append("import " + packageEntity.packageFragment.getElementName() + ".*;" + System.getProperties().getProperty("line.separator"));
                }
                String newSortType = packageEntity.sortType;
                if (!sortType.equals(newSortType)) {
                    importStatement.append(System.getProperties().getProperty("line.separator"));
                    sortType = newSortType;
                }
                ++i;
            }
        }
        return importStatement.toString();
    }

    public JMethod[] getMethodsToImplement() {
        LinkedList methodsList = new LinkedList();
        methodsList.addAll(this.typeWizardUtil.getAbstractMethodList());
        methodsList.addAll(this.typeWizardUtil.getInterfaceMethodList());
        methodsList.addAll(this.typeWizardUtil.getStubMethodList());
        return methodsList.toArray(new JMethod[methodsList.size()]);
    }

    public String getModifiersString() {
        String ret = "";
        if (this.getTypeRegionData().isPublic()) {
            ret = String.valueOf(ret) + "public ";
        }
        if (this.getTypeRegionData().isFinal()) {
            ret = String.valueOf(ret) + "final ";
        }
        if (this.getTypeRegionData().isAbstract()) {
            ret = String.valueOf(ret) + "abstract ";
        }
        return ret;
    }

    private IType getSuperClass() {
        return this.getTypeRegionData().getSuperClass();
    }

    public JMethod[] getSuperClassConstructors() {
        Vector superConstructorsList = this.typeWizardUtil.getSuperConstructorsList();
        return superConstructorsList.toArray(new JMethod[superConstructorsList.size()]);
    }

    public JMethod[] getSuperInterfaceMethods() {
        Vector interfaceMethodList = this.typeWizardUtil.getInterfaceMethodList();
        return interfaceMethodList.toArray(new JMethod[interfaceMethodList.size()]);
    }

    private IType[] getSuperInterfaces() {
        return this.getTypeRegionData().getSuperInterfaces();
    }

    protected ITypeRegionData getTypeRegionData() {
        return (ITypeRegionData)this.getRegionData();
    }

    private boolean isAbstractMethods() {
        return this.getTypeRegionData().isCreateInheritedAbstractStubs();
    }

    private boolean isAddConstructors() {
        return this.getTypeRegionData().isCreateSuperClassConstructors();
    }

    protected void processAbstractMethods() {
        if (this.isAbstractMethods()) {
            try {
                IType superClass = this.getSuperClass();
                ITypeHierarchy tH = superClass.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                while (superClass != null && Flags.isAbstract((int)superClass.getFlags())) {
                    IMethod[] methodList = superClass.getMethods();
                    int i = 0;
                    while (i < methodList.length) {
                        this.processOneAbstractMethod(methodList[i], tH);
                        ++i;
                    }
                    if (superClass.getSuperclassName() != null) {
                        superClass = this.getTypeRegionData().getJavaProject().findType(superClass.getSuperclassName());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    protected void processOneAbstractMethod(IMethod method, ITypeHierarchy tH) throws JavaModelException {
        IMethod implementedMethod;
        if (method == null || tH == null) {
            return;
        }
        if (!(!Flags.isAbstract((int)method.getFlags()) || Flags.isStatic((int)method.getFlags()) || Flags.isPrivate((int)method.getFlags()) || (implementedMethod = this.typeWizardUtil.findMethodImplementationInHierarchy(tH, this.getSuperClass(), method.getElementName(), method.getParameterTypes(), false)) != null && implementedMethod.exists())) {
            JMethod jMethod = this.typeWizardUtil.createJMethod(method);
            jMethod.setIsConstructor(false);
            this.typeWizardUtil.addAbstractMethod(jMethod);
        }
    }

    protected void processOneInterfaceMethod(IMethod method, ITypeHierarchy tH) throws JavaModelException {
        if (method == null || tH == null) {
            return;
        }
        IMethod implementedMethod = this.typeWizardUtil.findMethodImplementationInHierarchy(tH, this.getSuperClass(), method.getElementName(), method.getParameterTypes(), false);
        if (implementedMethod == null || !implementedMethod.exists()) {
            JMethod jMethod = this.typeWizardUtil.createJMethod(method);
            jMethod.setIsConstructor(false);
            this.typeWizardUtil.addInterfaceMethod(jMethod);
        }
    }

    protected void processSuperClass() {
        this.typeWizardUtil.addToImportsList(this.getSuperClass());
        this.processSuperClassConstructors();
        this.processAbstractMethods();
    }

    protected void processSuperClassConstructors() {
        if (this.isAddConstructors()) {
            try {
                IType superClass = this.getSuperClass();
                if (superClass != null) {
                    IMethod[] methodList = superClass.getMethods();
                    int i = 0;
                    while (i < methodList.length) {
                        IMethod method = methodList[i];
                        if (method.isConstructor() && !Flags.isStatic((int)method.getFlags()) && !Flags.isPrivate((int)method.getFlags())) {
                            JMethod jMethod = this.typeWizardUtil.createJMethod(method);
                            jMethod.setIsConstructor(true);
                            this.typeWizardUtil.addSuperConstructors(jMethod);
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Activator.log(e);
            }
        }
    }

    protected void processSuperInterfaces() {
        try {
            Hashtable<String, IMethod> methods = new Hashtable<String, IMethod>();
            int i = 0;
            while (i < this.getSuperInterfaces().length) {
                this.typeWizardUtil.addToImportsList(this.getSuperInterfaces()[i]);
                if (this.isAbstractMethods()) {
                    IMethod[] myMethods = this.getSuperInterfaces()[i].getMethods();
                    int j = 0;
                    while (j < myMethods.length) {
                        methods.put(String.valueOf(myMethods[j].getSignature()) + myMethods[j].getElementName(), myMethods[j]);
                        ++j;
                    }
                    IMethod[] superMethods = this.getAllInterfaceMethods(this.getSuperInterfaces()[i]);
                    int j2 = 0;
                    while (j2 < superMethods.length) {
                        methods.put(String.valueOf(superMethods[j2].getSignature()) + superMethods[j2].getElementName(), superMethods[j2]);
                        ++j2;
                    }
                }
                ++i;
            }
            if (this.isAbstractMethods()) {
                ITypeHierarchy tH = this.getSuperClass().newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                IMethod[] methodArray = methods.values().toArray(new IMethod[methods.values().size()]);
                int i2 = 0;
                while (i2 < methodArray.length) {
                    this.processOneInterfaceMethod(methodArray[i2], tH);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    public void processType() {
        if (this.usesDefaultJavaPackage()) {
            this.typeWizardUtil.addTypeNameInUse(this.getTypeRegionData().getPrefix(), this.getTypeRegionData().getPrefix());
        } else {
            this.typeWizardUtil.addTypeNameInUse(this.getTypeRegionData().getPrefix(), String.valueOf(this.getTypeRegionData().getJavaPackageFragment().getElementName()) + "." + this.getTypeRegionData().getPrefix());
        }
        this.processSuperClass();
        this.processSuperInterfaces();
    }
}

