/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableControlAdapter
extends ControlAdapter {
    boolean fResized = false;

    public void controlResized(ControlEvent e) {
        if (e.widget instanceof Table && !this.fResized) {
            final Table table = (Table)e.widget;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (table != null && !table.isDisposed()) {
                        Point size = table.getSize();
                        if (size.x > 4) {
                            int newSize;
                            TableControlAdapter.this.setResized();
                            int numColumnCount = table.getColumnCount();
                            int pixelsToSubtract = 4 / numColumnCount;
                            if (pixelsToSubtract <= 0) {
                                pixelsToSubtract = 1;
                            }
                            if ((newSize = size.x / numColumnCount - pixelsToSubtract) > 0 && table.getColumnCount() > 0) {
                                int i = 0;
                                while (i < numColumnCount) {
                                    TableColumn column = table.getColumn(i);
                                    if (column != null && !column.isDisposed()) {
                                        column.setWidth(newSize);
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                }
            });
        }
    }

    public void setResized() {
        this.fResized = true;
    }
}

