/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.struts.webregionwizard.Activator;
import com.ibm.etools.webtools.wizards.basic.CodeSegment;
import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.JException;
import com.ibm.etools.webtools.wizards.basic.JMethod;
import com.ibm.etools.webtools.wizards.basic.JParameter;
import com.ibm.etools.webtools.wizards.basic.JType;
import com.ibm.etools.webtools.wizards.basic.TypeWizardUtil;
import com.ibm.etools.webtools.wizards.util.JavaModelUtil;
import java.util.Vector;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class MethodStubDataUtil {
    protected JMethod jMethod;
    ITypeRegionData typeRegionData;
    protected final String ABSTRACT_STRING = "abstract";
    protected final String PUBLIC_STRING = "public";
    protected TypeWizardUtil typeWizardUtil;

    public MethodStubDataUtil(ITypeRegionData typeRegionData) {
        this.typeRegionData = typeRegionData;
    }

    public MethodStubDataUtil(JMethod method, TypeWizardUtil typeWizardUtil) {
        this.jMethod = method;
        this.typeWizardUtil = typeWizardUtil;
    }

    public JMethod createJConstructor(String accessSpecifier, String methodName, String[] parameterTypes, String[] parameterNames, String[] exceptions) {
        JMethod jMethod = new JMethod();
        jMethod.setIsConstructor(true);
        jMethod.setMethodName(methodName);
        jMethod.setAccessSpecifier(accessSpecifier);
        JParameter jReturnParam = new JParameter();
        jReturnParam = this.createJParam(JType.VOID, "");
        jMethod.setReturnParam(jReturnParam);
        JParameter[] jParams = new JParameter[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            jParams[i] = this.createJParam(parameterTypes[i], parameterNames[i]);
            ++i;
        }
        jMethod.setParams(jParams);
        JException[] jExceptions = new JException[exceptions.length];
        int i2 = 0;
        while (i2 < exceptions.length) {
            jExceptions[i2] = new JException();
            jExceptions[i2].setType(this.createJType(exceptions[i2]));
            ++i2;
        }
        jMethod.setExceptions(jExceptions);
        jMethod.setTypeRegionData(this.typeRegionData);
        return jMethod;
    }

    public JMethod createJMethod(IMethod wtMethod) {
        JMethod jMethod = new JMethod();
        try {
            jMethod.setAccessSpecifier(this.getAccessSpecifier(wtMethod));
            jMethod.setMethodName(wtMethod.getElementName());
            JParameter returnParam = this.parseParamSignature(wtMethod.getReturnType(), wtMethod);
            jMethod.setReturnParam(returnParam);
            JParameter[] jParams = new JParameter[wtMethod.getParameterTypes().length];
            int i = 0;
            while (i < wtMethod.getParameterTypes().length) {
                jParams[i] = this.parseParamSignature(wtMethod.getParameterTypes()[i], wtMethod);
                jParams[i].setParameterName(wtMethod.getParameterNames()[i]);
                ++i;
            }
            jMethod.setParams(jParams);
            JException[] jExceptions = new JException[wtMethod.getExceptionTypes().length];
            int i2 = 0;
            while (i2 < wtMethod.getExceptionTypes().length) {
                jExceptions[i2] = this.parseExceptionSignature(wtMethod.getExceptionTypes()[i2], wtMethod);
                ++i2;
            }
            jMethod.setExceptions(jExceptions);
            jMethod.setMethod(wtMethod);
            if (wtMethod.isConstructor()) {
                jMethod.setIsImplementedInSuperClass(true);
                jMethod.setMethodInSuperClass(wtMethod);
            }
            jMethod.setDeclaringType(wtMethod.getDeclaringType());
            jMethod.setTypeRegionData(this.typeRegionData);
        }
        catch (JavaModelException javaModelException) {}
        return jMethod;
    }

    public JMethod createJMethod(String accessSpecifier, String methodName, String[] parameterTypes, String[] parameterNames, String returnType, String[] exceptions, boolean isConstructor) {
        JMethod jMethod = new JMethod();
        jMethod.setIsConstructor(isConstructor);
        jMethod.setMethodName(methodName);
        jMethod.setAccessSpecifier(accessSpecifier);
        JParameter jReturnParam = new JParameter();
        jReturnParam = this.createJParam(returnType, "");
        jMethod.setReturnParam(jReturnParam);
        JParameter[] jParams = new JParameter[parameterTypes.length];
        int i = 0;
        while (i < parameterTypes.length) {
            jParams[i] = this.createJParam(parameterTypes[i], parameterNames[i]);
            ++i;
        }
        jMethod.setParams(jParams);
        JException[] jExceptions = new JException[exceptions.length];
        int i2 = 0;
        while (i2 < exceptions.length) {
            jExceptions[i2] = new JException();
            jExceptions[i2].setType(this.createJType(exceptions[i2]));
            ++i2;
        }
        jMethod.setExceptions(jExceptions);
        jMethod.setTypeRegionData(this.typeRegionData);
        return jMethod;
    }

    protected JParameter createJParam(String paramType, String paramName) {
        JParameter jParam = new JParameter();
        String paramSignature = Signature.createTypeSignature((String)paramType, (boolean)true);
        int arrayCount = Signature.getArrayCount((String)paramSignature);
        if (arrayCount == 0) {
            jParam.setIsArray(false);
        } else {
            jParam.setIsArray(true);
        }
        jParam.setArrayDimensions(arrayCount);
        jParam.setParameterName(paramName);
        jParam.setType(this.createJType(paramType));
        return jParam;
    }

    protected JType createJType(String paramType) {
        int arrayCount;
        JType jType = new JType();
        String paramSignature = Signature.createTypeSignature((String)paramType, (boolean)true);
        char type = paramSignature.charAt(arrayCount = Signature.getArrayCount((String)paramSignature));
        if (type == 'Q' || type == 'L') {
            String qualifiedName = Signature.toString((String)paramSignature.substring(arrayCount));
            jType.setIsClass(true);
            try {
                IType thisType;
                if (qualifiedName != null && (thisType = this.typeRegionData.getJavaProject().findType(qualifiedName)) != null && thisType.exists()) {
                    jType.setClassType(thisType);
                }
            }
            catch (JavaModelException javaModelException) {}
        } else {
            jType.setIsSimple(true);
            jType.setSimpleType(Signature.toString((String)paramSignature.substring(arrayCount)));
        }
        return jType;
    }

    public String getAccessSpecifier(IMethod wtMethod) {
        String ret = "";
        try {
            if (wtMethod != null) {
                ret = Flags.toString((int)wtMethod.getFlags());
                int index = ret.indexOf("abstract");
                if (index != -1) {
                    String begin = ret.substring(0, index);
                    String end = ret.substring(index + "abstract".length());
                    ret = String.valueOf(begin) + end;
                }
                if (ret.indexOf("public") == -1) {
                    ret = "public " + ret;
                }
            }
        }
        catch (JavaModelException ex) {
            Activator.log((Exception)((Object)ex));
        }
        return ret;
    }

    public String getDeclaringType() {
        String ret = "";
        if (this.jMethod.getMethod() != null && this.jMethod.getDeclaringType() != null) {
            ret = this.jMethod.getDeclaringType().getFullyQualifiedName('.');
        }
        return ret;
    }

    public String getExceptionString() {
        String ret = "";
        try {
            if (this.jMethod != null) {
                if (this.jMethod.getExceptions().length > 0) {
                    ret = "throws ";
                }
                int i = 0;
                while (i < this.jMethod.getExceptions().length) {
                    ret = String.valueOf(ret) + this.typeWizardUtil.getTypeNameToUse(this.jMethod.getExceptions()[i].getType().getClassType());
                    if (i < this.jMethod.getExceptions().length - 1) {
                        ret = String.valueOf(ret) + ", ";
                    }
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        return ret;
    }

    public String getJavaDocComment() {
        StringBuffer buffer = new StringBuffer("");
        try {
            boolean useSeeTag = false;
            IMethod methodToSee = this.jMethod.getMethod();
            if (this.jMethod.isImplementedInSuperClass()) {
                useSeeTag = true;
                methodToSee = this.jMethod.getMethodInSuperClass();
            } else if (this.jMethod.getMethod() != null) {
                useSeeTag = true;
                methodToSee = this.jMethod.getMethod();
            }
            if (useSeeTag) {
                int i;
                buffer.append("/**\r\n * @see " + methodToSee.getDeclaringType().getFullyQualifiedName('.'));
                String methodSignature = methodToSee.getSignature();
                methodSignature = Signature.toString((String)methodSignature.replace('/', '.'));
                if (methodToSee.isConstructor() && (i = methodSignature.indexOf(JType.VOID)) != -1) {
                    String constructorMethodSignature = methodSignature.substring(0, i);
                    constructorMethodSignature = String.valueOf(constructorMethodSignature) + methodToSee.getDeclaringType().getElementName();
                    methodSignature = constructorMethodSignature = String.valueOf(constructorMethodSignature) + methodSignature.substring(i + JType.VOID.length());
                }
                buffer.append("#" + methodSignature + "\r\n");
                buffer.append(" */");
            } else {
                int i;
                buffer.append("/**\r\n * Method " + this.jMethod.getMethodName() + ".\r\n");
                if (this.jMethod.getMethodComment() != null) {
                    buffer.append("/**\r\n * " + this.jMethod.getMethodComment() + "\r\n");
                }
                if (this.jMethod.getNumberOfParameters() > 0) {
                    i = 0;
                    while (i < this.jMethod.getNumberOfParameters()) {
                        buffer.append(" * @param " + this.jMethod.getParams()[i].getParameterName() + "\r\n");
                        ++i;
                    }
                }
                if (!this.jMethod.getReturnParam().getType().isVoid()) {
                    buffer.append(" * @return " + this.jMethod.getReturnParam().getType().getElementName());
                    i = 0;
                    while (i < this.jMethod.getReturnParam().getArrayDimensions()) {
                        buffer.append("[]");
                        ++i;
                    }
                    buffer.append("\r\n");
                }
                if (this.jMethod.getNumberOfExceptions() > 0) {
                    i = 0;
                    while (i < this.jMethod.getNumberOfParameters()) {
                        buffer.append(" * @throws " + this.jMethod.getExceptions()[i].getType().getElementName() + "\r\n");
                        ++i;
                    }
                }
                buffer.append(" */");
            }
        }
        catch (JavaModelException javaModelException) {}
        return buffer.toString();
    }

    public String getMethodBody() {
        String methodBody = this.jMethod.getMethodBody();
        if (methodBody == null) {
            StringBuffer buf = new StringBuffer();
            Vector methodBodyVector = this.jMethod.getMethodBodyVector();
            for (Object element : methodBodyVector) {
                if (element instanceof CodeSegment) {
                    buf.append(((CodeSegment)element).getCode());
                    continue;
                }
                if (!(element instanceof String)) continue;
                IType thisType = this.typeWizardUtil.getType((String)element);
                if (thisType != null) {
                    buf.append(this.typeWizardUtil.getTypeNameToUse(thisType));
                    continue;
                }
                buf.append((String)element);
            }
            methodBody = buf.toString();
        }
        return methodBody;
    }

    public String getModifierString() {
        return this.jMethod.getAccessSpecifier();
    }

    public String getParamNamesString() {
        String ret = "";
        if (this.jMethod != null) {
            int i = 0;
            while (i < this.jMethod.getNumberOfParameters()) {
                JParameter jParam = this.jMethod.getParams()[i];
                ret = String.valueOf(ret) + jParam.getParameterName();
                if (i < this.jMethod.getNumberOfParameters() - 1) {
                    ret = String.valueOf(ret) + ", ";
                }
                ++i;
            }
        }
        return ret;
    }

    public String getParamString() {
        String ret = "";
        try {
            if (this.jMethod != null) {
                int i = 0;
                while (i < this.jMethod.getNumberOfParameters()) {
                    ret = String.valueOf(ret) + this.getParamTypeString(this.jMethod.getParams()[i]) + " " + this.jMethod.getParams()[i].getParameterName();
                    if (i < this.jMethod.getNumberOfParameters() - 1) {
                        ret = String.valueOf(ret) + ", ";
                    }
                    ++i;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        return ret;
    }

    protected String getParamTypeString(JParameter jParam) {
        StringBuffer buf = new StringBuffer("");
        JType jType = jParam.getType();
        if (jType.isSimple()) {
            buf.append(jType.getSimpleType());
        } else {
            buf.append(this.typeWizardUtil.getTypeNameToUse(jType.getClassType()));
        }
        if (jParam.isArray()) {
            int i = 1;
            while (i <= jParam.getArrayDimensions()) {
                buf.append("[]");
                ++i;
            }
        }
        return buf.toString();
    }

    public String getReturnTypeString() {
        StringBuffer buf = new StringBuffer("");
        try {
            if (this.jMethod != null && !this.jMethod.isConstructor()) {
                buf.append(this.getParamTypeString(this.jMethod.getReturnParam()));
            }
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        return buf.toString();
    }

    public String getSignature() {
        String ret = "";
        try {
            if (this.jMethod != null && this.jMethod.getMethod() != null) {
                ret = Signature.toString((String)this.jMethod.getMethod().getSignature());
            }
        }
        catch (JavaModelException ex) {
            Activator.log((Exception)((Object)ex));
        }
        catch (IllegalArgumentException ex) {
            Activator.log(ex);
        }
        return ret;
    }

    protected JException parseExceptionSignature(String refTypeSig, IMethod wtMethod) throws JavaModelException {
        JException jException = new JException();
        if (refTypeSig != null) {
            jException.setType(this.parseSimpleSignature(refTypeSig, wtMethod));
        }
        return jException;
    }

    protected JParameter parseParamSignature(String refTypeSig, IMethod wtMethod) throws JavaModelException {
        JParameter jParam = new JParameter();
        if (refTypeSig != null) {
            int arrayCount = Signature.getArrayCount((String)refTypeSig);
            if (arrayCount == 0) {
                jParam.setIsArray(false);
                jParam.setArrayDimensions(0);
            } else {
                jParam.setIsArray(true);
                jParam.setArrayDimensions(arrayCount);
            }
            jParam.setType(this.parseSimpleSignature(refTypeSig, wtMethod));
        }
        return jParam;
    }

    protected JType parseSimpleSignature(String refTypeSig, IMethod wtMethod) {
        JType jType = new JType();
        try {
            int arrayCount = Signature.getArrayCount((String)refTypeSig);
            char type = refTypeSig.charAt(arrayCount);
            if (type == 'Q' || type == 'L') {
                int semi = refTypeSig.indexOf(59, arrayCount + 1);
                if (semi == -1) {
                    return jType;
                }
                String preParseName = refTypeSig.substring(arrayCount + 1, semi);
                String fullyQualifiedName = null;
                if (type == 'Q') {
                    IType declaringType = wtMethod.getDeclaringType();
                    String[][] resolvedNames = null;
                    if (declaringType != null && declaringType.exists()) {
                        resolvedNames = declaringType.resolveType(preParseName);
                    }
                    if (resolvedNames != null && resolvedNames.length > 0) {
                        fullyQualifiedName = JavaModelUtil.concatenateName((String)resolvedNames[0][0], (String)resolvedNames[0][1]);
                    }
                } else if (type == 'L') {
                    fullyQualifiedName = preParseName;
                }
                if (fullyQualifiedName != null) {
                    jType.setIsClass(true);
                    IType thisType = wtMethod.getJavaProject().findType(fullyQualifiedName);
                    if (thisType != null && thisType.exists()) {
                        jType.setClassType(thisType);
                    }
                }
            } else {
                jType.setIsSimple(true);
                jType.setSimpleType(Signature.toString((String)refTypeSig.substring(arrayCount)));
            }
        }
        catch (JavaModelException javaModelException) {}
        return jType;
    }

    public void setMethod(JMethod method) {
        this.jMethod = method;
    }
}

