/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import org.eclipse.jdt.core.IType;

public class JType {
    public static String VOID = "void";
    public static String BOOLEAN = "boolean";
    public static String INT = "int";
    public static String FLOAT = "float";
    public static String CHAR = "char";
    public static String BYTE = "byte";
    public static String SHORT = "short";
    public static String LONG = "long";
    public static String DOUBLE = "double";
    public boolean isSimple = true;
    public IType classType = null;
    public String simpleType = VOID;

    public JType() {
    }

    public JType(boolean isClass, IType classType) {
        this.isSimple = !isClass;
        this.classType = classType;
    }

    public JType(boolean isSimple, String simpleType) {
        this.isSimple = isSimple;
        this.simpleType = simpleType;
    }

    public boolean equals(Object obj1) {
        boolean ret = false;
        if (obj1 instanceof JType) {
            JType type1 = (JType)obj1;
            if (this.isSimple() == type1.isSimple()) {
                ret = this.isSimple() ? this.simpleType.equals(type1.getSimpleType()) : this.getClassType().getFullyQualifiedName('.').equals(type1.getClassType().getFullyQualifiedName('.'));
            }
        }
        return ret;
    }

    public IType getClassType() {
        return this.classType;
    }

    public String getDefaultValue() {
        StringBuffer buf = new StringBuffer();
        if (this.isSimple()) {
            String ret = "";
            if (this.simpleType.equals(BOOLEAN)) {
                ret = "false";
            } else if (this.simpleType.equals(CHAR)) {
                ret = "'\\u0000'";
            } else if (this.simpleType.equals(BYTE)) {
                ret = "Byte.valueOf(\"0\").byteValue()";
            } else if (this.simpleType.equals(SHORT)) {
                ret = "0";
            } else if (this.simpleType.equals(INT)) {
                ret = "0";
            } else if (this.simpleType.equals(LONG)) {
                ret = "0";
            } else if (this.simpleType.equals(FLOAT)) {
                ret = "0";
            } else if (this.simpleType.equals(DOUBLE)) {
                ret = "0.0";
            }
            buf.append(ret);
        } else {
            IType classType = this.getClassType();
            if (classType != null && classType.exists()) {
                if (classType.getFullyQualifiedName('.').equals("java.lang.String")) {
                    buf.append("\"\"");
                } else {
                    buf.append("null");
                }
            } else {
                buf.append("null");
            }
        }
        return buf.toString();
    }

    public String getElementName() {
        String ret = "";
        if (this.isSimple()) {
            ret = this.simpleType;
        } else if (this.getClassType() != null) {
            ret = this.getClassType().getFullyQualifiedName('.');
        }
        return ret;
    }

    public String getSimpleType() {
        return this.simpleType;
    }

    public boolean isClass() {
        return !this.isSimple;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean isVoid() {
        boolean ret = false;
        if (this.isSimple() && this.getSimpleType().equals(VOID)) {
            ret = true;
        }
        return ret;
    }

    public void setClassType(IType classType) {
        this.classType = classType;
        if (classType == null) {
            this.setIsSimple(true);
        }
    }

    public void setIsClass(boolean isClass) {
        this.isSimple = !isClass;
    }

    public void setIsSimple(boolean isSimple) {
        this.isSimple = isSimple;
    }

    public void setSimpleType(String simpleType) {
        this.simpleType = simpleType;
    }
}

