/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.webtools.wizards.basic.JType;
import com.ibm.etools.webtools.wizards.basic.nls.ResourceHandler;

public class JParameter {
    public JType type;
    public String parameterName;
    public boolean isArray = false;
    public int arrayDimensions = 0;

    public JParameter() {
    }

    public JParameter(JType type) {
        this.isArray = false;
        this.type = type;
    }

    public JParameter(JType type, int arrayDimensions) {
        this.type = type;
        if (arrayDimensions == 0) {
            this.isArray = false;
        } else if (arrayDimensions > 0) {
            this.isArray = true;
        } else if (arrayDimensions < 0) {
            throw new IllegalArgumentException(ResourceHandler.cannot_pass_negative_arrayDimension_1);
        }
    }

    public boolean equals(Object obj1) {
        boolean ret = false;
        if (obj1 instanceof JParameter) {
            JParameter param1 = (JParameter)obj1;
            if (this.isArray() == param1.isArray() && this.arrayDimensions == param1.getArrayDimensions() && this.type.equals(param1.getType())) {
                ret = true;
            }
        }
        return ret;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public String getDefaultValue() {
        StringBuffer buf = new StringBuffer();
        if (this.isArray()) {
            buf.append("null");
        } else {
            buf.append(this.getType().getDefaultValue());
        }
        return buf.toString();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public JType getType() {
        return this.type;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArrayDimensions(int arrayDimensions) {
        this.arrayDimensions = arrayDimensions;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setType(JType type) {
        this.type = type;
    }
}

