/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.webtools.wizards.basic.CodeSegment;
import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.JException;
import com.ibm.etools.webtools.wizards.basic.JParameter;
import com.ibm.etools.webtools.wizards.basic.JType;
import java.util.Vector;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

public class JMethod {
    protected String accessSpecifier;
    protected JParameter returnParam;
    protected boolean isConstructor = false;
    protected String methodName;
    protected JParameter[] params = new JParameter[0];
    protected JException[] exceptions = new JException[0];
    protected Vector importsList = new Vector();
    protected String methodBody;
    protected Vector methodBodyVector = new Vector();
    protected IMethod method;
    protected IType declaringType;
    protected boolean isImplementedInSuperClass = false;
    protected IMethod methodInSuperClass = null;
    protected String methodComment;
    protected ITypeRegionData typeRegionData;
    public static final String TYPESTART = "<TYPE>";
    public static final String TYPEEND = "</TYPE>";

    public void addToImportsList(IType type) {
        if (type != null && !this.importsList.contains(type)) {
            this.importsList.add(type);
        }
    }

    public void appendMethodBody(String newMethodBody) {
        String sourceString = newMethodBody;
        while (sourceString != null && sourceString.length() > 0) {
            int typeNameStart = sourceString.indexOf(TYPESTART);
            if (typeNameStart > 0) {
                CodeSegment seg = new CodeSegment();
                seg.setCode(sourceString.substring(0, typeNameStart));
                this.methodBodyVector.add(seg);
            } else if (typeNameStart == -1) {
                CodeSegment seg = new CodeSegment();
                seg.setCode(sourceString);
                this.methodBodyVector.add(seg);
                break;
            }
            int typeNameEnd = sourceString.indexOf(TYPEEND);
            if (typeNameEnd > typeNameStart) {
                String typeName = sourceString.substring(typeNameStart + TYPESTART.length(), typeNameEnd);
                this.addToImportsList(this.getType(typeName));
                this.methodBodyVector.add(typeName);
            }
            sourceString = sourceString.substring(typeNameEnd + TYPEEND.length());
        }
    }

    public boolean equals(Object obj1) {
        boolean ret = false;
        if (obj1 instanceof JMethod) {
            JMethod method1 = (JMethod)obj1;
            if (this.isConstructor() == method1.isConstructor() && (this.isConstructor() || this.methodName.equals(method1.getMethodName())) && (this.isConstructor() || this.returnParam.equals(method1.getReturnParam())) && this.params.length == method1.getParams().length) {
                ret = true;
                int i = 0;
                while (i < this.params.length) {
                    if (!this.params[i].equals(method1.getParams()[i])) {
                        ret = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    public String getAccessSpecifier() {
        return this.accessSpecifier;
    }

    public IType getDeclaringType() {
        return this.declaringType;
    }

    public JException[] getExceptions() {
        return this.exceptions;
    }

    public Vector getImportsList() {
        Vector<IType> methodImportList = new Vector<IType>();
        if (!this.isConstructor() && this.returnParam.getType().isClass()) {
            methodImportList.add(this.returnParam.getType().getClassType());
        }
        int i = 0;
        while (i < this.params.length) {
            if (this.params[i].getType().isClass()) {
                methodImportList.add(this.params[i].getType().getClassType());
            }
            ++i;
        }
        i = 0;
        while (i < this.exceptions.length) {
            if (this.exceptions[i].getType().isClass()) {
                methodImportList.add(this.exceptions[i].getType().getClassType());
            }
            ++i;
        }
        methodImportList.addAll(this.importsList);
        return methodImportList;
    }

    public IMethod getMethod() {
        return this.method;
    }

    @Deprecated
    public String getMethodBody() {
        return this.methodBody;
    }

    public Vector getMethodBodyVector() {
        if (this.methodBodyVector.isEmpty()) {
            CodeSegment seg = new CodeSegment();
            StringBuffer buf = new StringBuffer();
            if (this.isConstructor()) {
                if (this.isImplementedInSuperClass()) {
                    buf.append("super(");
                    int i = 0;
                    while (i < this.getNumberOfParameters()) {
                        JParameter jParam = this.getParams()[i];
                        buf.append(jParam.getParameterName());
                        if (i < this.getNumberOfParameters() - 1) {
                            buf.append(", ");
                        }
                        ++i;
                    }
                    buf.append(");");
                } else {
                    buf.append("");
                }
            } else {
                if (this.returnParam.getType().isSimple() && this.returnParam.getType().simpleType.equals(JType.VOID)) {
                    seg.setCode("");
                    this.methodBodyVector.add(seg);
                    return this.methodBodyVector;
                }
                buf.append("return ");
                buf.append(this.returnParam.getDefaultValue());
                buf.append(";");
            }
            seg.setCode(buf.toString());
            this.methodBodyVector.add(seg);
        }
        return this.methodBodyVector;
    }

    public String getMethodComment() {
        return this.methodComment;
    }

    public IMethod getMethodInSuperClass() {
        return this.methodInSuperClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getNumberOfExceptions() {
        return this.exceptions.length;
    }

    public int getNumberOfParameters() {
        return this.params.length;
    }

    public String[] getParameterTypes() {
        String[] parameterTypes = new String[this.params.length];
        int i = 0;
        while (i < this.params.length) {
            StringBuffer buf = new StringBuffer();
            JType jType = this.params[i].getType();
            if (jType.isSimple()) {
                buf.append(jType.getSimpleType());
            } else {
                IType classType = jType.getClassType();
                if (classType == null || !classType.exists()) {
                    buf.append("java.lang.Object");
                } else {
                    buf.append(jType.getClassType().getFullyQualifiedName('.'));
                }
            }
            if (this.params[i].isArray()) {
                i = 1;
                while (i <= this.params[i].getArrayDimensions()) {
                    buf.append("[]");
                    ++i;
                }
            }
            parameterTypes[i] = Signature.createTypeSignature((String)buf.toString(), (boolean)true);
            ++i;
        }
        return parameterTypes;
    }

    public JParameter[] getParams() {
        return this.params;
    }

    public JParameter getReturnParam() {
        return this.returnParam;
    }

    public IType getType(String qualifiedName) {
        IType thisType = null;
        try {
            thisType = this.getTypeRegionData().getJavaProject().findType(qualifiedName);
        }
        catch (JavaModelException javaModelException) {}
        return thisType;
    }

    public ITypeRegionData getTypeRegionData() {
        return this.typeRegionData;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isImplementedInSuperClass() {
        return this.isImplementedInSuperClass;
    }

    public void setAccessSpecifier(String accessSpecifier) {
        this.accessSpecifier = accessSpecifier;
    }

    protected void setDeclaringType(IType type) {
        this.declaringType = type;
    }

    public void setExceptions(JException[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setImportsList(Vector importsList) {
        this.importsList = importsList;
    }

    public void setIsConstructor(boolean isConstructor) {
        this.isConstructor = isConstructor;
    }

    public void setIsImplementedInSuperClass(boolean isImplementedInSuperClass) {
        this.isImplementedInSuperClass = isImplementedInSuperClass;
    }

    public void setMethod(IMethod method) {
        this.method = method;
    }

    @Deprecated
    public void setMethodBody(String methodBody) {
        this.methodBody = methodBody;
    }

    public void setMethodComment(String methodComment) {
        this.methodComment = methodComment;
    }

    public void setMethodInSuperClass(IMethod methodInSuperClass) {
        this.methodInSuperClass = methodInSuperClass;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParams(JParameter[] params) {
        this.params = params;
    }

    public void setReturnParam(JParameter returnParam) {
        this.returnParam = returnParam;
    }

    public void setTypeRegionData(ITypeRegionData typeRegionData) {
        this.typeRegionData = typeRegionData;
    }
}

