/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.wizards.basic;

import com.ibm.etools.webtools.wizards.basic.TypeDataUtil;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class HierarchySelection
extends TwoPaneElementSelector {
    protected IRunnableContext fRunnableContext;
    protected IType[] fIT;

    public HierarchySelection(Shell parent, IRunnableContext context, IType[] types) {
        super(parent, (ILabelProvider)new TypeRenderer(), (ILabelProvider)new PackageRenderer());
        this.setUpperListLabel(JavaUIMessages.TypeSelectionDialog_upperLabel);
        this.setLowerListLabel(JavaUIMessages.TypeSelectionDialog_lowerLabel);
        this.fRunnableContext = context;
        Assert.isNotNull((Object)this.fRunnableContext);
        this.fIT = types;
    }

    protected void computeResult() {
        super.computeResult();
    }

    public int open() {
        if (this.fIT.length == 0) {
            return 1;
        }
        this.setElements(this.fIT);
        this.setInitialSelections(new Object[]{""});
        return super.open();
    }

    private static class PackageRenderer
    extends LabelProvider {
        private final Image PACKAGE_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.package_obj.gif");
        private final Image CLASS_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif");

        private PackageRenderer() {
        }

        public Image getImage(Object element) {
            if (element instanceof IType && ((IType)element).getDeclaringType() != null) {
                return this.CLASS_ICON;
            }
            return this.PACKAGE_ICON;
        }

        public String getText(Object element) {
            IType type = (IType)element;
            String p = TypeDataUtil.getQualifierName(type);
            if ("".equals(p)) {
                String def = "(default package)";
                return def;
            }
            return p;
        }
    }

    private static class TypeRenderer
    extends LabelProvider {
        private final Image CLASS_ICON = JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif");

        private TypeRenderer() {
        }

        public Image getImage(Object element) {
            return this.CLASS_ICON;
        }

        public String getText(Object element) {
            IType e = (IType)element;
            return e.getElementName();
        }
    }
}

