/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.tiles;

import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.Plugin0;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigFactory;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.tiles.IStrutsTilesConstants;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import com.ibm.etools.tiles.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class PostInstallOperation
implements IDelegate,
IStrutsTilesConstants {
    protected IProject project;
    protected IVirtualComponent component;
    protected IDataModel model;
    protected IProgressMonitor monitor;

    private Command createUpdateStrutsConfigCommand(StrutsArtifactEdit strutsConfig) {
        ArrayList commands = new ArrayList();
        this.createUpdateStrutsConfigCommands(commands, strutsConfig);
        switch (commands.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Command)commands.get(0);
            }
        }
        return new CompoundCommand(commands);
    }

    private void createUpdateStrutsConfigCommands(List commands, StrutsArtifactEdit strutsConfig) {
        if (StrutsProjectCoreUtil.getStrutsVersion((IProject)strutsConfig.getComponent().getProject()) == 0) {
            return;
        }
        boolean needCommand = true;
        EList plugins = strutsConfig.getStrutsConfig().getPlugins();
        for (Plugin0 plugin : plugins) {
            if ("org.apache.struts.tiles.TilesPlugin".equals(plugin.getClassName())) {
                EList setProperties = plugin.getSetProperties();
                for (SetProperty setProp : setProperties) {
                    if ("definitions-config".equals(setProp.getProperty())) {
                        StringTokenizer tokenizer = new StringTokenizer(setProp.getValue(), " ,");
                        while (tokenizer.hasMoreTokens()) {
                            String path = tokenizer.nextToken();
                            if (!this.getDefinitionConfigPath().equals(path)) continue;
                            needCommand = false;
                            break;
                        }
                    }
                    if (!needCommand) break;
                }
            }
            if (!needCommand) break;
        }
        if (needCommand) {
            StrutsconfigFactory factory = StrutsconfigPackage.eINSTANCE.getStrutsconfigFactory();
            Plugin0 plugin = factory.createPlugin0();
            plugin.setClassName("org.apache.struts.tiles.TilesPlugin");
            SetProperty setProp = factory.createSetProperty();
            setProp.setProperty("definitions-config");
            setProp.setValue(this.getDefinitionConfigPath());
            plugin.getSetProperties().add((Object)setProp);
            setProp = factory.createSetProperty();
            setProp.setProperty("definitions-parser-validate");
            setProp.setValue("true");
            plugin.getSetProperties().add((Object)setProp);
            setProp = factory.createSetProperty();
            setProp.setProperty("moduleAware");
            setProp.setValue("true");
            plugin.getSetProperties().add((Object)setProp);
            commands.add(AddCommand.create((EditingDomain)this.getEditingDomain(strutsConfig), (Object)strutsConfig.getStrutsConfig(), (Object)StrutsconfigPackage.eINSTANCE.getStrutsConfig_Plugins(), (Object)plugin));
        }
    }

    public final void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.project = project;
        if (config instanceof IDataModel) {
            this.model = (IDataModel)config;
        }
        this.monitor = monitor;
        this.component = ComponentCore.createComponent((IProject)project);
        if (this.component != null && !this.isPseudoInstall() && this.hasRequiredFacet()) {
            this.updateStrutsConfig();
        }
    }

    protected abstract String getDefinitionConfigPath();

    protected EditingDomain getEditingDomain(StrutsArtifactEdit strutsConfig) {
        return new AdapterFactoryEditingDomain(new AdapterFactory(){

            public Adapter adapt(Notifier target, Object type) {
                return null;
            }

            public Object adapt(Object object, Object type) {
                return null;
            }

            public void adaptAllNew(Notifier notifier) {
            }

            public Adapter adaptNew(Notifier target, Object type) {
                return null;
            }

            public boolean isFactoryForType(Object type) {
                return false;
            }
        }, strutsConfig.getCommandStack());
    }

    protected abstract boolean hasRequiredFacet();

    protected abstract boolean isPseudoInstall();

    private void updateStrutsConfig() {
        Collection files = StrutsSearchUtil.getStrutsConfigIFiles((IProject)this.component.getProject());
        for (IFile file : files) {
            StrutsArtifactEdit strutsConfig = StrutsArtifactEdit.getStrutsArtifactEditForWrite((IFile)file);
            if (strutsConfig == null) continue;
            try {
                try {
                    Command command = this.createUpdateStrutsConfigCommand(strutsConfig);
                    if (command != null) {
                        strutsConfig.getCommandStack().execute(command);
                    }
                    strutsConfig.saveIfNecessary(this.monitor);
                }
                catch (Throwable throwable) {
                    Logger.logException((Throwable)throwable);
                    strutsConfig.dispose();
                    continue;
                }
            }
            catch (Throwable throwable) {
                strutsConfig.dispose();
                throw throwable;
            }
            strutsConfig.dispose();
        }
    }
}

