/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.security.internal.wrappers;

import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.security.internal.wrappers.StrutsSecurityWrapper;
import com.ibm.etools.webtools.security.base.internal.events.AbstractSecurityEvent;
import com.ibm.etools.webtools.security.base.internal.events.SecurityResourceLabelChangedEvent;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.j2ee.model.IModelProvider;

public class StrutsActionWrapper
extends StrutsSecurityWrapper
implements IReferenceListener {
    public StrutsActionWrapper(ILink resource, String addressableURL, IModelProvider webEdit) {
        super(resource, addressableURL, webEdit);
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
    }

    public int category() {
        return 0;
    }

    public void dispose() {
        super.dispose();
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
    }

    public void generateURLPatterns() {
        try {
            IProject prj = this.getProject();
            Collection urlPatterns = StrutsSearchUtil.getStrutsServletMappings((IProject)prj, (SearchScope)SearchEngine.createSearchScope((IResource[])new IResource[]{prj}), null);
            for (String urlPattern : urlPatterns) {
                String url;
                if (urlPattern.startsWith("*")) {
                    String suffix = urlPattern.substring(urlPattern.indexOf("*."), urlPattern.length());
                    String moduleName = (String)this.getParent().getResource();
                    url = String.valueOf(moduleName) + ((ILink)this.getResource()).getName() + suffix;
                    this.urlPatterns.add(url);
                    continue;
                }
                String moduleName = (String)this.getParent().getResource();
                String prefix = urlPattern.substring(0, urlPattern.indexOf("*"));
                url = String.valueOf(prefix) + moduleName + ((ILink)this.getResource()).getName();
                this.urlPatterns.add(url);
            }
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        for (ReferenceEvent referenceEvent : events) {
            if (referenceEvent.getReferenceElement() != this.getResource()) continue;
            this.updateLabel();
            SecurityResourceLabelChangedEvent newEvent = new SecurityResourceLabelChangedEvent((Object)this);
            this.fire((AbstractSecurityEvent)newEvent);
        }
    }

    private void updateLabel() {
        this.setLabel(((ILink)this.getResource()).getName());
        this.addressableURL = ((ILink)this.getResource()).getName();
    }
}

