/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.core.util.SiteFileTypeUtil;
import com.ibm.etools.siteedit.sitelib.core.SiteNavBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.regions.DOMJSPRegionContexts;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.commentelement.util.TagScanner;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class NavigationTagUtil
implements DOMJSPRegionContexts {
    private static NavigationTagUtil navigationTagUtil;
    private Map knownItems = new HashMap();
    private Map knownTabs = new HashMap();
    public static final int NOT_SPEC = 0;
    public static final int HTML_SPEC = 1;
    public static final int JSP_SPEC = 2;
    public static final int FACES_SPEC = 3;
    private static final Integer[] typeObjects;

    static {
        typeObjects = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3)};
    }

    private NavigationTagUtil() {
    }

    public static NavigationTagUtil getInstance() {
        if (navigationTagUtil == null) {
            navigationTagUtil = new NavigationTagUtil();
        }
        return navigationTagUtil;
    }

    public void dispose() {
        this.knownItems.clear();
        this.knownItems = new HashMap();
        this.knownTabs.clear();
        this.knownTabs = new HashMap();
    }

    public static String[] getNavTags(IDOMModel model) {
        if (model == null) {
            return null;
        }
        ArrayList<String> navTags = new ArrayList<String>();
        IStructuredDocument doc = model.getStructuredDocument();
        if (doc != null) {
            IStructuredDocumentRegion region = doc.getFirstStructuredDocumentRegion();
            while (region != null) {
                String thisLine = NavigationTagUtil.getNavCommentTag(region);
                if (thisLine != null) {
                    navTags.add(thisLine);
                }
                if ((thisLine = NavigationTagUtil.getNavCustomTag(region)) != null) {
                    navTags.add(thisLine);
                }
                region = region.getNext();
            }
        }
        return navTags.toArray(new String[navTags.size()]);
    }

    public boolean isSpecFile(IFile file) {
        return this.getSpecType(file) != 0;
    }

    public int getSpecType(IFile file) {
        if (file == null || !file.exists()) {
            return 0;
        }
        return this.getSpecType(file.getLocation());
    }

    public boolean isTabSpec(IFile file) {
        IPath fullPath = file.getFullPath();
        if (fullPath == null || !file.exists()) {
            return false;
        }
        return this.isTagTab(fullPath);
    }

    public boolean isTabSpec(IPath fullPath) {
        if (this.knownTabs.containsKey(fullPath)) {
            return this.knownTabs.get(fullPath) == Boolean.TRUE;
        }
        boolean isTab = this.isTagTab(fullPath);
        this.knownTabs.put(fullPath, isTab);
        return isTab;
    }

    private boolean isTagTab(IPath fullPath) {
        IStructuredDocument flatModel;
        if (this.getSpecType(fullPath) != 0 && (flatModel = NavigationTagUtil.getStructuredDocument(fullPath)) != null) {
            IStructuredDocumentRegion node = flatModel.getFirstStructuredDocumentRegion();
            while (node != null) {
                if (this.isForImgTabTag(node)) {
                    return true;
                }
                node = node.getNext();
            }
        }
        return false;
    }

    public int getSpecType(IPath fullPath) {
        if (this.knownItems.containsKey(fullPath)) {
            return (Integer)this.knownItems.get(fullPath);
        }
        int specType = this.getSpecType0(fullPath);
        this.knownItems.put(fullPath, typeObjects[specType]);
        return specType;
    }

    private int getSpecType0(IPath fullPath) {
        IStructuredDocument flatModel = NavigationTagUtil.getStructuredDocument(fullPath);
        if (flatModel != null) {
            IStructuredDocumentRegion node = flatModel.getFirstStructuredDocumentRegion();
            switch (SiteFileTypeUtil.whatKindOfFile(fullPath)) {
                case 0: {
                    while (node != null) {
                        if (this.isForEachCommentTag(node)) {
                            return 1;
                        }
                        node = node.getNext();
                    }
                    break;
                }
                case 2: {
                    while (node != null) {
                        if (this.isForEachCommentTag(node)) {
                            return 3;
                        }
                        if (this.isUseNavTagBeanTag(node)) {
                            return 2;
                        }
                        node = node.getNext();
                    }
                    break;
                }
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IStructuredDocument getStructuredDocument(IPath fullPath) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            manager.connect(fullPath, (IProgressMonitor)new NullProgressMonitor());
            try {
                ITextFileBuffer fileBuffer = manager.getTextFileBuffer(fullPath);
                if (fileBuffer == null) return null;
                IDocument document = fileBuffer.getDocument();
                if (!(document instanceof IStructuredDocument)) return null;
                IStructuredDocument iStructuredDocument = (IStructuredDocument)document;
                return iStructuredDocument;
            }
            finally {
                manager.disconnect(fullPath, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return null;
    }

    private boolean isForEachCommentTag(IStructuredDocumentRegion node) {
        String regionType = NavigationTagUtil.getFirstRegionType(node);
        if (regionType == "XML_COMMENT_OPEN" || regionType == "JSP_COMMENT_OPEN") {
            ITextRegionList regions = node.getRegions();
            for (ITextRegion region : regions) {
                regionType = region.getType();
                if (regionType != "XML_COMMENT_TEXT" && regionType != "JSP_COMMENT_TEXT") continue;
                String data = node.getText(region);
                if (!(data = data.trim()).startsWith("siteedit:forEach")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isForImgTabTag(IStructuredDocumentRegion node) {
        String text = node.getFullText();
        return text.indexOf("${sitenav.navtabSelImg[") >= 0;
    }

    private static String getNavCommentTag(IStructuredDocumentRegion node) {
        String regionType = NavigationTagUtil.getFirstRegionType(node);
        if (regionType == "XML_COMMENT_OPEN" || regionType == "JSP_COMMENT_OPEN") {
            ITextRegionList regions = node.getRegions();
            for (ITextRegion region : regions) {
                regionType = region.getType();
                if (regionType != "XML_COMMENT_TEXT" && regionType != "JSP_COMMENT_TEXT") continue;
                String data = node.getText(region);
                if (!(data = data.trim()).startsWith("siteedit")) continue;
                return data;
            }
        }
        return null;
    }

    private static String getNavCustomTag(IStructuredDocumentRegion node) {
        String regionType = NavigationTagUtil.getFirstRegionType(node);
        if (regionType == "XML_TAG_OPEN") {
            ITextRegionList regions = node.getRegions();
            for (ITextRegion region : regions) {
                regionType = region.getType();
                if (regionType != "XML_TAG_NAME") continue;
                String data = node.getText();
                if (!(data = data.trim()).startsWith("<siteedit")) continue;
                return data;
            }
        }
        return null;
    }

    private boolean isUseNavTagBeanTag(IStructuredDocumentRegion node) {
        String regionType = NavigationTagUtil.getFirstRegionType(node);
        if (regionType == "XML_TAG_OPEN") {
            ITextRegionList regions = node.getRegions();
            for (ITextRegion region : regions) {
                String typeValue;
                String tagName;
                regionType = region.getType();
                if (regionType != "XML_TAG_NAME" || !(tagName = node.getText(region)).equalsIgnoreCase("jsp:useBean") || !(typeValue = this.getAttrValue(node.getFullText(), "type")).equals(SiteNavBean.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getFirstRegionType(IStructuredDocumentRegion flatNode) {
        if (flatNode == null) {
            return "UNDEFINED";
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null || regions.size() == 0) {
            return "UNDEFINED";
        }
        ITextRegion region = regions.get(0);
        return region.getType();
    }

    private String getAttrValue(String data, String attrName) {
        String name;
        TagScanner scanner = new TagScanner(data, 0);
        String value = "";
        while ((name = scanner.nextName()) != null) {
            if (!name.equals(attrName)) continue;
            value = scanner.nextValue();
            break;
        }
        return value;
    }
}

