/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.util;

import com.ibm.etools.siteedit.internal.core.util.SiteFileTypeUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.webedit.viewer.utils.ModelManagerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FileUtil2 {
    public static IFile getFile(IDOMModel xmlModel) {
        if (xmlModel == null) {
            return null;
        }
        Path path = new Path(ModelManagerUtil.getBaseLocation((IStructuredModel)xmlModel));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        return file != null && file.exists() ? file : null;
    }

    public static boolean isJSPFragmentFile(IFile file) {
        IPath filePath = file.getProjectRelativePath();
        return SiteFileTypeUtil.whatKindOfFile(filePath) == 8;
    }

    public static boolean isCSSFile(IFile specFile) {
        return SiteFileTypeUtil.whatKindOfFile(specFile.getProjectRelativePath()) == 1;
    }

    public static IResource[] collectCSSFiles(IVirtualComponent component) {
        ArrayList result = new ArrayList();
        try {
            IContainer root = WebComponentUtil.getComponentRootFolder(component);
            if (root != null) {
                root.accept((IResourceVisitor)new CustomVisitor(result, null, component, new int[]{1}));
            }
        }
        catch (CoreException coreException) {}
        return result.toArray(new IResource[result.size()]);
    }

    private static class CustomVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        protected final Collection result;
        protected final Collection candidate;
        protected final IVirtualComponent component;
        final int[] fileTypes;

        public CustomVisitor(Collection result, Collection candidate, IVirtualComponent component, int[] fileTypes) {
            this.result = result;
            this.candidate = candidate;
            this.component = component;
            this.fileTypes = fileTypes;
            Arrays.sort(fileTypes);
        }

        public boolean visit(IResourceDelta delta) {
            return this.visit(delta.getResource());
        }

        public boolean visit(IResource resource) {
            int comparisonFileType;
            if (this.fileTypes.length < 1) {
                return false;
            }
            if (resource.getType() == 1 && Arrays.binarySearch(this.fileTypes, comparisonFileType = SiteFileTypeUtil.whatKindOfFile(resource.getFullPath())) >= 0) {
                String name = SiteResourceUtil.getProjectRelativePathString(this.component, resource);
                if (this.candidate == null || this.candidate.contains(name)) {
                    this.result.add(resource);
                }
            }
            return true;
        }
    }
}

