/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitetags.model;

import com.ibm.etools.siteedit.internal.builder.common.TagNode;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.util.Assert;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SiteTagModel {
    private Node node;
    private TagNode tagnode;
    private static final char ESCAPE = '\\';
    public static final int UNKNOWN = 0;
    public static final int COMMENT_NAV_TAG = 1;
    public static final int CUSTOM_NAV_TAG = 2;

    public SiteTagModel() {
    }

    public SiteTagModel(Node node) {
        Assert.isTrue((boolean)(node instanceof IDOMElement));
        this.node = node;
    }

    public SiteTagModel(TagNode tagnode) {
        this.tagnode = tagnode;
    }

    public static String escapeString(String string, String key, boolean escapeSelf) {
        int index = 0;
        StringBuffer buf = new StringBuffer(string);
        if (escapeSelf) {
            while ((index = buf.toString().indexOf(92, index)) != -1) {
                buf.insert(index, '\\');
                ++index;
                if (buf.length() <= ++index) break;
            }
        }
        index = 0;
        while ((index = buf.toString().indexOf(key, index)) != -1) {
            buf.insert(index, '\\');
            ++index;
            if (buf.length() <= (index += key.length())) break;
        }
        return buf.toString();
    }

    public static String escapeString(String string, String[] keys) {
        int i = 0;
        while (i < keys.length) {
            string = SiteTagModel.escapeString(string, keys[i], i == 0);
            ++i;
        }
        return string;
    }

    public static boolean isStringInt(String string, boolean onlyPos) {
        if (string == null) {
            return false;
        }
        boolean result = false;
        try {
            int n = Integer.parseInt(string);
            result = onlyPos ? n > 0 : true;
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    public static List getList(String value, String delim, boolean unescapeSelf) {
        if (value == null || delim == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, delim, true);
        boolean bAdd = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals(delim)) {
                if (!bAdd) {
                    list.add("");
                }
                bAdd = false;
                continue;
            }
            list.add(token);
            bAdd = true;
        }
        return SiteTagModel.unescapeList(list, delim, unescapeSelf);
    }

    public static List getListList(String value, String delim1, String delim2) {
        if (value == null || delim1 == null || delim2 == null) {
            return null;
        }
        List valuelist = SiteTagModel.getList(value, delim2, false);
        if (valuelist == null) {
            return null;
        }
        ArrayList<List> result = new ArrayList<List>();
        int len = valuelist.size();
        int i = 0;
        while (i < len) {
            result.add(SiteTagModel.getList((String)valuelist.get(i), delim1, true));
            ++i;
        }
        return result;
    }

    public static int[] getListStringInt(List list) {
        if (list == null) {
            return null;
        }
        int len = list.size();
        if (len <= 0) {
            return null;
        }
        int[] result = new int[len];
        int i = 0;
        while (i < len) {
            String string = (String)list.get(i);
            try {
                result[i] = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                result[i] = Integer.MIN_VALUE;
            }
            ++i;
        }
        return result;
    }

    public String getAttribute(String attr) {
        if (attr == null) {
            return null;
        }
        if (!this.isAttributePermitted(attr)) {
            return null;
        }
        if (this.node != null && this.node instanceof Element) {
            return SiteTagModel.getAttribute((Element)this.node, attr);
        }
        if (this.tagnode != null) {
            return this.tagnode.containsAttr(attr) ? this.tagnode.getAttr(attr) : null;
        }
        return null;
    }

    private static String getAttribute(Element element, String attrName) {
        Attr attr = element.getAttributeNode(attrName);
        if (attr == null) {
            return null;
        }
        return SiteTagModel.getAttribute(attr);
    }

    private static String getAttribute(Attr attr) {
        if (attr instanceof IDOMNode) {
            return ((IDOMNode)attr).getValueSource();
        }
        return attr.getValue();
    }

    public boolean getAttributeBoolean(String attr) {
        return SiteTagModel.getBoolean(this.getAttribute(attr));
    }

    public List getAttributeFromListList(String attr, String firstvalue) {
        List listlist = this.getAttributeListList(attr);
        if (listlist == null) {
            return null;
        }
        int len = listlist.size();
        int i = 0;
        while (i < len) {
            String val;
            List list = (List)listlist.get(i);
            if (list != null && (val = (String)list.get(0)) != null && val.equalsIgnoreCase(firstvalue)) {
                ArrayList result = new ArrayList(list);
                result.remove(0);
                return result;
            }
            ++i;
        }
        return null;
    }

    public List getAttributeList(String attr) {
        return this.getAttributeList(attr, ",");
    }

    public List getAttributeList(String attr, String delim) {
        return SiteTagModel.getList(this.getAttribute(attr), delim, true);
    }

    public List getAttributeListList(String attr) {
        return this.getAttributeListList(attr, ",", "|");
    }

    public List getAttributeListList(String attr, String delim1, String delim2) {
        return SiteTagModel.getListList(this.getAttribute(attr), delim1, delim2);
    }

    public static boolean getBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static String getStringFromArray(String[] value, String delim) {
        if (value == null || delim == null) {
            return null;
        }
        StringBuffer result = null;
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                String val = SiteTagModel.escapeString(value[i], delim, true);
                if (result == null) {
                    result = new StringBuffer(val);
                } else {
                    result.append(val);
                }
                if (i != value.length - 1) {
                    result.append(delim);
                }
            }
            ++i;
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public static String getStringFromArrays(String[][] value, String delim1, String delim2) {
        if (value == null || delim1 == null || delim2 == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                int j = 0;
                while (j < value[i].length) {
                    if (value[i][j] != null) {
                        String val = SiteTagModel.escapeString(value[i][j], new String[]{delim1, delim2});
                        result.append(val);
                        if (j != value[i].length - 1) {
                            result.append(delim1);
                        }
                    }
                    ++j;
                }
                if (i != value.length - 1) {
                    result.append(delim2);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String getStringFromList(List value, String delim) {
        if (value == null || delim == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = value.size();
        int i = 0;
        while (i < len) {
            String val = (String)value.get(i);
            if (val != null) {
                val = SiteTagModel.escapeString(val, delim, true);
                result.append(val);
                if (i != len - 1) {
                    result.append(delim);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String getStringFromListList(List value, String delim1, String delim2) {
        if (value == null || delim1 == null || delim2 == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int len = value.size();
        int i = 0;
        while (i < len) {
            List list = (List)value.get(i);
            if (list != null) {
                int len2 = list.size();
                int j = 0;
                while (j < len2) {
                    String val = (String)list.get(j);
                    if (val != null) {
                        val = SiteTagModel.escapeString(val, new String[]{delim1, delim2});
                        result.append(val);
                        if (j != len2 - 1) {
                            result.append(delim1);
                        }
                    }
                    ++j;
                }
                if (i != len - 1) {
                    result.append(delim2);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public int getNavigationTagType() {
        if (this.node instanceof IDOMElement) {
            IDOMElement xmlElement = (IDOMElement)this.node;
            if (xmlElement.isCommentTag()) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public boolean isAttributePermitted(String attr) {
        return true;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setTagNode(TagNode tagnode) {
        this.tagnode = tagnode;
    }

    public TagNode getTagNode() {
        return this.tagnode;
    }

    public static List unescapeList(List list, String delim, boolean unescapeSelf) {
        if (list == null || delim == null) {
            return null;
        }
        int len = list.size();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < len) {
            StringBuffer buf = new StringBuffer((String)list.get(i));
            int index = 0;
            while ((index = buf.toString().indexOf(92, index)) != -1) {
                if (index == buf.length() - 1) {
                    buf.deleteCharAt(index);
                    buf.append(delim);
                    if (len <= ++i) break;
                    buf.append((String)list.get(i));
                } else if (unescapeSelf) {
                    buf.deleteCharAt(index);
                    ++index;
                } else {
                    index += 2;
                }
                if (buf.length() <= index) break;
            }
            result.add(buf.toString());
            ++i;
        }
        return result.size() > 0 ? result : null;
    }
}

