/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.sitelib.util;

import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.util.BuildUtil;
import com.ibm.etools.siteedit.internal.core.util.LinkUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteModelUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteTaglibDirectiveReader;
import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.sitelib.core.Site;
import com.ibm.etools.siteedit.sitelib.core.io.SiteFileReader;
import com.ibm.etools.siteedit.sitelib.core.io.SiteFileWriter;
import com.ibm.etools.webedit.linkfixup.ModelUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class SitelibHelper {
    private SitelibHelper() {
    }

    public static boolean ensureSitelibResources(IVirtualComponent component, IProgressMonitor monitor) {
        return SitelibHelper.ensureJSTLFeature(component, monitor) && SitelibHelper.ensureLibFiles(component) && SitelibHelper.ensureSitelibConfigFile(component);
    }

    private static boolean ensureJSTLFeature(IVirtualComponent component, IProgressMonitor monitor) {
        try {
            if (!WebComponentUtil.hasComponentFeature(component, "web.jstl")) {
                WebComponentUtil.installProjectFacet(component.getProject(), "web.jstl", monitor);
            }
            return true;
        }
        catch (CoreException e) {
            Logger.log(e);
            return false;
        }
    }

    private static boolean ensureLibFiles(IVirtualComponent component) {
        String[] jarFiles = new String[]{"sitelib.jar"};
        try {
            Bundle sitelibBundle = Platform.getBundle((String)"com.ibm.etools.siteedit.sitelib");
            IFolder libFolder = WebComponentUtil.getLibraryFolder(component);
            if (!libFolder.exists()) {
                libFolder.create(true, true, null);
            }
            int i = 0;
            while (i < jarFiles.length) {
                URL url = sitelibBundle.getEntry("runtime/" + jarFiles[i]);
                if (url == null) {
                    throw new FileNotFoundException(jarFiles[i]);
                }
                URLConnection from = url.openConnection();
                IFile to = libFolder.getFile(jarFiles[i]);
                if (from.getLastModified() > to.getLocalTimeStamp()) {
                    InputStream in = null;
                    try {
                        in = from.getInputStream();
                        if (to.exists()) {
                            to.setContents(in, true, false, null);
                        } else {
                            to.create(in, true, null);
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                ++i;
            }
            return true;
        }
        catch (FileNotFoundException e) {
            Logger.log(e);
        }
        catch (IOException e) {
            Logger.log(e);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
        return false;
    }

    private static boolean ensureSitelibConfigFile(IVirtualComponent component) {
        File config = SitelibHelper.getSiteLibConfigFile(component).getLocation().toFile();
        return config.exists() || SitelibHelper.createSitelibConfigFile(component);
    }

    public static boolean updateSitelibConfigFile(IVirtualComponent component) {
        File config = SitelibHelper.getSiteLibConfigFile(component).getLocation().toFile();
        return !config.exists() || SitelibHelper.createSitelibConfigFile(component);
    }

    private static boolean createSitelibConfigFile(IVirtualComponent component) {
        String name = WebComponentUtil.encodeComponentToText(component);
        Site site = Site.loadSite((SiteFileReader)new SiteConfigReader(name));
        if (site == null) {
            return false;
        }
        site.expand();
        return site.saveSite((SiteFileWriter)new SiteXmlWriter(name));
    }

    public static IFile getSiteLibConfigFile(IVirtualComponent component) {
        return WebComponentUtil.getRootPublishableFolder(component).getFile((IPath)new Path("/WEB-INF/website-config.xml"));
    }

    public static boolean fixupSpecFile(IFile file) {
        IStructuredModel model = null;
        try {
            if (WebComponentUtil.getServletVersion(WebComponentUtil.findComponent((IResource)file)) < 24) {
                return true;
            }
            LinkNode linkNode = ReferenceManager.getReferenceManager().getLinkNode(file);
            linkNode.getLinks(null);
            new RefactoringSupport();
            model = StructuredModelManager.getModelManager().getModelForEdit(file);
            int modelType = ModelUtil.getModelType((IStructuredModel)model);
            if (modelType == 2) {
                return true;
            }
            if (modelType != 1) {
                return false;
            }
            IDOMModel domModel = (IDOMModel)model;
            IDOMDocument document = domModel.getDocument();
            NodeIterator iter = ((DocumentTraversal)document).createNodeIterator((Node)document, 1, null, false);
            Node n = iter.nextNode();
            boolean replaced = false;
            while (n != null) {
                if (replaced) break;
                String nName = n.getNodeName();
                if (!nName.equals("jsp:directive.taglib")) {
                    n = iter.nextNode();
                    continue;
                }
                IDOMElement cfr_ignored_0 = (IDOMElement)n;
                NamedNodeMap attributeNodes = n.getAttributes();
                int length = attributeNodes.getLength();
                int i = 0;
                while (i < length) {
                    IDOMAttr attr;
                    Node item = attributeNodes.item(i);
                    String attName = item.getNodeName();
                    if (attName.equalsIgnoreCase("uri") && (attr = (IDOMAttr)item).getValue().equals("http://java.sun.com/jstl/core")) {
                        attr.setValue("http://java.sun.com/jsp/jstl/core");
                        replaced = true;
                    }
                    ++i;
                }
                n = iter.nextNode();
            }
            model.save();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
        return false;
    }

    public static boolean fixupSitelibPage(IVirtualComponent component, String url) {
        SiteModelUtil mu = new SiteModelUtil();
        IFile file = SiteResourceUtil.fileForProjectRelative(component, url);
        IDOMModel model = null;
        try {
            model = mu.getModelForRead(file, false);
            boolean bl = SitelibHelper.fixupSitelibPage(model, file);
            return bl;
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public static boolean fixupSitelibPage(IDOMModel model, IFile baseFile) {
        boolean hasNav = false;
        if (baseFile == null) {
            return hasNav;
        }
        hasNav = BuildUtil.hasNav(baseFile);
        if (!hasNav) {
            return hasNav;
        }
        IVirtualComponent component = WebComponentUtil.findComponent((IResource)baseFile);
        String prefix = SiteTaglibDirectiveReader.getPrefixForUri("http://www.ibm.com/siteedit/sitelib", null, model);
        if (prefix == null) {
            return hasNav;
        }
        SitelibHelper.ensureSitelibResources(component, null);
        IDOMDocument doc = model.getDocument();
        NodeIterator ni = ((DocumentTraversal)doc).createNodeIterator((Node)doc, 1, null, false);
        HashSet<String> spec = new HashSet<String>();
        Node n = ni.nextNode();
        while (n != null) {
            String s;
            String p = n.getPrefix();
            if (p != null && p.equals(prefix) && (s = ((Element)n).getAttribute("spec")) != null && s.length() > 0) {
                spec.add(s);
            }
            n = ni.nextNode();
        }
        Iterator si = spec.iterator();
        while (si.hasNext()) {
            IFile f = SitelibHelper.getNavspecFile(baseFile, "siteedit:navbar", "spec", (String)si.next(), null);
            if (f != null && SitelibHelper.fixupSpecFile(f)) continue;
            return false;
        }
        return true;
    }

    private static IVirtualComponent getComponent(String name) {
        return WebComponentUtil.decodeComponentFromText(name);
    }

    private static IFile getNavspecFile(IFile baseFile, String tagName, String attrName, String attrValue, String baseHref) {
        return LinkUtil.getFile(baseFile, tagName, attrName, attrValue, baseHref);
    }

    private static class SiteConfigReader
    extends SiteFileReader {
        public SiteConfigReader(String name) {
            super(name);
        }

        public SiteFileReader newInstance(String name) {
            return new SiteConfigReader(name);
        }

        protected InputStream openInputStream() {
            try {
                IVirtualComponent component = SitelibHelper.getComponent(this.getName());
                IFile f = WebComponentUtil.getWebSiteConfigFile(component);
                if (f.exists()) {
                    return f.getContents();
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return null;
        }

        public String convertSrc(String src) {
            if (src != null && src.length() > 0) {
                IVirtualComponent component = SitelibHelper.getComponent(this.getName());
                IPath webPath = WebComponentUtil.getRootPublishableFolder(component).getProjectRelativePath();
                String contextRoot = WebComponentUtil.getServerContextRoot(component);
                IPath srcPath = component.getProject().getFile(src).getProjectRelativePath();
                if (webPath.isPrefixOf(srcPath)) {
                    return new Path(contextRoot).append(srcPath.removeFirstSegments(webPath.segmentCount())).makeAbsolute().toString();
                }
            }
            return "#";
        }
    }

    private static class SiteXmlWriter
    extends SiteFileWriter {
        public SiteXmlWriter(String name) {
            super(name);
        }

        public boolean saveDocument(Document document) {
            IVirtualComponent component = SitelibHelper.getComponent(this.getName());
            IFile file = SitelibHelper.getSiteLibConfigFile(component);
            try {
                SiteXmlDocumentUtil.saveDocument(document, file);
                return true;
            }
            catch (IOException e) {
                Logger.log(e);
            }
            catch (CoreException e) {
                Logger.log(e);
            }
            return false;
        }
    }
}

