/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model.command;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.site.model.command.SiteCommandUtil;
import com.ibm.etools.siteedit.site.model.command.SiteCommandValidator;
import com.ibm.etools.siteedit.site.model.command.SiteInteractiveCommandValidator;
import com.ibm.etools.siteedit.site.model.command.SiteValidateEditCommandValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;

public class SiteCommandStack
extends CommandStack {
    private boolean isCommandRunning;
    private SiteCommandValidator[] commandValidators;
    private boolean extDirty;
    private static final String TRACE_KEY = "model/commandstack";

    public SiteCommandStack() {
        this.addValidator(new SiteInteractiveCommandValidator());
        this.addValidator(new SiteValidateEditCommandValidator());
    }

    public void execute(Command command) {
        if (command == null) {
            return;
        }
        if (!this.validateCommand(command, 1)) {
            return;
        }
        try {
            this.isCommandRunning = true;
            if (this.isStackableCommand(command)) {
                this.setIgnoreStackAction(command, true);
                super.execute(command);
            } else if (command.canExecute()) {
                this.extDirty |= this.isExtDirtyCommand(command);
                command.execute();
            }
        }
        finally {
            this.isCommandRunning = false;
        }
    }

    public void undo() {
        if (!this.validateCommand(this.getUndoCommand(), 2)) {
            return;
        }
        try {
            this.isCommandRunning = true;
            super.undo();
        }
        finally {
            this.isCommandRunning = false;
        }
    }

    public void redo() {
        if (!this.validateCommand(this.getRedoCommand(), 3)) {
            return;
        }
        try {
            this.isCommandRunning = true;
            super.redo();
        }
        finally {
            this.isCommandRunning = false;
        }
    }

    private boolean validateCommand(Command command, int state) {
        SiteCommandValidator[] validators = this.commandValidators;
        int i = 0;
        while (i < validators.length) {
            long currentTime = System.currentTimeMillis();
            boolean result = validators[i].validate(command, state);
            if (SiteCommandStack._isTracing()) {
                Logger.log("Command Validation " + validators[i].getClass().getName() + " took " + (System.currentTimeMillis() - currentTime) + " millisecs.");
            }
            if (!result) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addValidator(SiteCommandValidator validator) {
        if (validator == null) {
            return;
        }
        ArrayList<SiteCommandValidator> ar = new ArrayList<SiteCommandValidator>();
        if (this.commandValidators != null) {
            ar.addAll(Arrays.asList(this.commandValidators));
        }
        if (ar.contains(validator)) {
            return;
        }
        ar.add(validator);
        SiteCommandValidator[] result = ar.toArray(new SiteCommandValidator[ar.size()]);
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SiteCommandValidator)o2).getPriority() - ((SiteCommandValidator)o1).getPriority();
            }
        });
        this.commandValidators = result;
    }

    public void removeValidator(SiteCommandValidator validator) {
        if (validator == null) {
            return;
        }
        ArrayList<SiteCommandValidator> ar = new ArrayList<SiteCommandValidator>(Arrays.asList(this.commandValidators));
        ar.remove(validator);
        this.commandValidators = ar.toArray(new SiteCommandValidator[ar.size()]);
    }

    public void markSaveLocation() {
        this.extDirty = false;
        super.markSaveLocation();
    }

    public boolean isDirty() {
        return this.extDirty || super.isDirty();
    }

    public void flush() {
        this.extDirty = false;
        super.flush();
    }

    public boolean isExtDirty() {
        return this.extDirty;
    }

    public void setExtDirty(boolean extDirty) {
        this.extDirty = extDirty;
    }

    public boolean isCommandRunning() {
        return this.isCommandRunning;
    }

    private boolean isStackableCommand(Command command) {
        final boolean[] result = new boolean[1];
        SiteCommandUtil.accept(command, new SiteCommandUtil.Visitor(){

            @Override
            public boolean visit(Command command) {
                if (command instanceof StackControlCommand && !((StackControlCommand)command).isStackable()) {
                    return true;
                }
                result[0] = true;
                return false;
            }
        });
        return result[0];
    }

    private boolean isExtDirtyCommand(Command nonStackableCommand) {
        final boolean[] result = new boolean[1];
        SiteCommandUtil.accept(nonStackableCommand, new SiteCommandUtil.Visitor(){

            @Override
            public boolean visit(Command command) {
                if (command instanceof StackControlCommand) {
                    StackControlCommand cmd = (StackControlCommand)command;
                    if (cmd.isStackable()) {
                        return false;
                    }
                    if (cmd.isDirtyCommand()) {
                        result[0] = true;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
        return result[0];
    }

    private void setIgnoreStackAction(Command command, final boolean ignore) {
        SiteCommandUtil.accept(command, new SiteCommandUtil.Visitor(){

            @Override
            public boolean visit(Command command) {
                StackControlCommand c;
                if (command instanceof StackControlCommand && !(c = (StackControlCommand)command).isStackable()) {
                    c.setIgnoreUndoRedo(ignore);
                }
                return true;
            }
        });
    }

    static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    static boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }

    public static interface StackControlCommand {
        public boolean isStackable();

        public boolean isDirtyCommand();

        public void setIgnoreUndoRedo(boolean var1);
    }
}

