/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model.command;

import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModelConstraint;
import com.ibm.etools.siteedit.site.model.SiteModelUtil2;
import com.ibm.etools.siteedit.site.model.command.AbstractModifySiteTreeCommand;
import com.ibm.etools.siteedit.site.model.command.SiteSubProjectUtil;
import com.ibm.etools.siteedit.site.model.command.SiteValidateEditCommand;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class AbstractMoveSiteComponentCommand
extends AbstractModifySiteTreeCommand {
    protected SiteComponent target;
    protected int direction;
    private AbstractModifySiteTreeCommand.RemoveOps done;
    private AbstractModifySiteTreeCommand.RemoveOps undo;
    protected static SiteSubProjectUtil NULL_SUBPROJECT_UTIL = new NullSubProjectUtil();

    public AbstractMoveSiteComponentCommand() {
    }

    public AbstractMoveSiteComponentCommand(String label) {
        super(label);
    }

    protected abstract SiteComponent[] getMoveComponents();

    public boolean canExecute() {
        if (this.target == null) {
            return false;
        }
        SiteComponent parent = this.direction == 0 ? this.target : this.target.getParent();
        SiteComponent[] moveRoots = this.getMoveRoots();
        if (moveRoots == null) {
            return false;
        }
        int i = moveRoots.length - 1;
        while (i >= 0) {
            SiteComponent sc = moveRoots[i];
            if (this.direction != 0 && this.target == sc) {
                return false;
            }
            if (!SiteModelConstraint.canMove(sc, parent)) {
                return false;
            }
            --i;
        }
        return super.canExecute();
    }

    public void execute() {
        final SiteComponent[] moveRoots = this.getMoveRoots();
        this.target.getSiteModel().internalExecWithoutListener(new Runnable(){

            @Override
            public void run() {
                AbstractMoveSiteComponentCommand.this.done = AbstractMoveSiteComponentCommand.this.removeCore(moveRoots);
                AbstractMoveSiteComponentCommand.this.addCore(AbstractMoveSiteComponentCommand.this.target, moveRoots, AbstractMoveSiteComponentCommand.this.direction);
            }
        });
    }

    public void undo() {
        this.target.getSiteModel().internalExecWithoutListener(new Runnable(){

            @Override
            public void run() {
                AbstractMoveSiteComponentCommand.this.undo = AbstractMoveSiteComponentCommand.this.removeCore(AbstractMoveSiteComponentCommand.this.done.getSiteComponents());
                AbstractMoveSiteComponentCommand.this.undoRemoveCore(AbstractMoveSiteComponentCommand.this.done);
                AbstractMoveSiteComponentCommand.this.done = null;
            }
        });
    }

    public void redo() {
        this.target.getSiteModel().internalExecWithoutListener(new Runnable(){

            @Override
            public void run() {
                AbstractMoveSiteComponentCommand.this.done = AbstractMoveSiteComponentCommand.this.removeCore(AbstractMoveSiteComponentCommand.this.undo.getSiteComponents());
                AbstractMoveSiteComponentCommand.this.undoRemoveCore(AbstractMoveSiteComponentCommand.this.undo);
                AbstractMoveSiteComponentCommand.this.undo = null;
            }
        });
    }

    public void setTarget(SiteComponent obj) {
        this.target = obj;
    }

    protected SiteComponent[] getMoveRoots() {
        if (this.done == null) {
            SiteComponent[] remove = this.getMoveComponents();
            if (!SiteModelUtil2.isValidComponentArray(remove)) {
                return null;
            }
            ArrayList<SiteComponent> result = new ArrayList<SiteComponent>(Arrays.asList(remove));
            SiteModelUtil2.optimizeTreeRoots(result);
            return result.toArray(new SiteComponent[result.size()]);
        }
        return this.done.getSiteComponents();
    }

    @Override
    protected SiteSubProjectUtil getSubProjectUtil() {
        return NULL_SUBPROJECT_UTIL;
    }

    @Override
    public boolean notifyCollectingValidateEditData(SiteValidateEditCommand.Data data, int state) {
        data.addAsSiteNavigation(this.target);
        return true;
    }

    private static class NullSubProjectUtil
    implements SiteSubProjectUtil {
        private NullSubProjectUtil() {
        }

        @Override
        public boolean confirmToAdd(SiteComponent target, SiteComponent[] ins, Object shell) {
            return true;
        }

        @Override
        public void modifyReferencesToAdd(SiteComponent target, SiteComponent[] components) {
        }

        @Override
        public boolean confirmToRemove(SiteComponent target, SiteComponent[] del, Object shell) {
            return true;
        }

        @Override
        public void modifyReferencesToRemove(SiteComponent site, SiteComponent[] components) {
        }
    }
}

