/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model.command;

import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModelConstraint;
import com.ibm.etools.siteedit.site.model.command.AbstractModifySiteTreeCommand;
import com.ibm.etools.siteedit.site.model.command.SiteInteractiveCommand;
import com.ibm.etools.siteedit.site.model.command.SiteValidateEditCommand;

public abstract class AbstractInsertSiteComponentCommand
extends AbstractModifySiteTreeCommand
implements SiteInteractiveCommand {
    protected SiteComponent target;
    protected int direction;
    private SiteComponent[] insertedComponents;
    private AbstractModifySiteTreeCommand.RemoveOps undo;

    public AbstractInsertSiteComponentCommand() {
    }

    public AbstractInsertSiteComponentCommand(String label) {
        super(label);
    }

    protected abstract SiteComponent[] getInsertionComponents();

    protected SiteComponentType[] getInsertionComponentTypes() {
        return null;
    }

    public boolean canExecute() {
        if (this.target == null) {
            return false;
        }
        if (!this.isValidDirection()) {
            return false;
        }
        SiteComponent insertionParent = this.isAsChild() ? this.target : this.target.getParent();
        SiteComponentType[] types = this.getInsertionComponentTypes();
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                if (!SiteModelConstraint.canAddChild(insertionParent, types[i])) {
                    return false;
                }
                ++i;
            }
        } else {
            SiteComponent[] ins = this.getInsertionComponents();
            if (ins == null) {
                return false;
            }
            int i = 0;
            while (i < ins.length) {
                SiteComponent c = ins[i];
                if (c == null) {
                    return false;
                }
                if (!SiteModelConstraint.canAddChild(insertionParent, c.getType())) {
                    return false;
                }
                ++i;
            }
        }
        return super.canExecute();
    }

    public void execute() {
        SiteComponent[] ins = this.getInsertionComponents();
        this.addCore(this.target, ins, this.direction);
        this.insertedComponents = ins;
    }

    public void undo() {
        this.undo = this.removeCore(this.insertedComponents);
    }

    public void redo() {
        this.undoRemoveCore(this.undo);
    }

    @Override
    public boolean confirmExec(int state, Object shell) {
        if (state == 1 || state == 3) {
            SiteComponent[] ins = null;
            if (state == 1) {
                ins = this.getInsertionComponents();
            }
            if (state == 3) {
                ins = this.insertedComponents;
            }
            return this.getSubProjectUtil().confirmToAdd(this.target, ins, shell);
        }
        if (state == 2) {
            return this.getSubProjectUtil().confirmToRemove(this.target, this.insertedComponents, shell);
        }
        return false;
    }

    protected boolean isAsChild() {
        return this.direction == 0;
    }

    protected boolean isValidDirection() {
        return this.direction == 2 || this.direction == 1 || this.direction == 0;
    }

    public void setTarget(SiteComponent obj) {
        this.target = obj;
    }

    @Override
    public boolean notifyCollectingValidateEditData(SiteValidateEditCommand.Data data, int state) {
        data.addAsSiteNavigation(this.target);
        return true;
    }
}

