/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModelProperty;

class SiteTraverseProperty
implements SiteModelProperty {
    final boolean reverse;
    private int lastIndex = -1;

    SiteTraverseProperty(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public boolean isPropertyFor(SiteComponent sc) {
        return true;
    }

    @Override
    public Object getProperty(SiteComponent sc) {
        if (!this.reverse) {
            return this.getNext(sc);
        }
        return this.getPrevious(sc);
    }

    @Override
    public boolean isEditablePropertyFor(SiteComponent sc) {
        return false;
    }

    @Override
    public void setProperty(SiteComponent sc, Object o) {
        throw new IllegalStateException();
    }

    private int getIndex(SiteComponent sc) {
        SiteComponent parent = sc.getParent();
        int index = this.lastIndex;
        if (index >= 0 && index < parent.numberOfChildren() && parent.getChildAt(index) == sc) {
            return index;
        }
        return parent.indexOf(sc);
    }

    private SiteComponent getNextSibling(SiteComponent sc) {
        SiteComponent parent = sc.getParent();
        if (parent == null) {
            return null;
        }
        int index = this.getIndex(sc);
        if (index >= 0 && index < parent.numberOfChildren() - 1) {
            this.lastIndex = index + 1;
            return parent.getChildAt(index + 1);
        }
        return null;
    }

    private SiteComponent getPreviousSibling(SiteComponent sc) {
        SiteComponent parent = sc.getParent();
        if (parent == null) {
            return null;
        }
        int index = this.getIndex(sc);
        if (1 <= index && index < parent.numberOfChildren()) {
            this.lastIndex = index - 1;
            return parent.getChildAt(index - 1);
        }
        return null;
    }

    private SiteComponent getNext(SiteComponent sc) {
        if (sc == null) {
            return null;
        }
        if (sc.numberOfChildren() > 0) {
            this.lastIndex = 0;
            return sc.getChildAt(0);
        }
        SiteComponent focus = sc;
        while (focus != null) {
            SiteComponent sibling = this.getNextSibling(focus);
            if (sibling != null) {
                return sibling;
            }
            focus = focus.getParent();
        }
        return null;
    }

    private SiteComponent getPrevious(SiteComponent sc) {
        if (sc == null) {
            return null;
        }
        SiteComponent sibling = this.getPreviousSibling(sc);
        if (sibling != null) {
            SiteComponent focus = sibling;
            while (focus.numberOfChildren() > 0) {
                focus = focus.getChildAt(focus.numberOfChildren() - 1);
            }
            return focus;
        }
        return sc.getParent();
    }
}

