/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.site.model.ParsingException;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;

public class SiteParseUtil {
    private String filename;
    private final DocumentBuilder parser;

    public SiteParseUtil() {
        this.parser = SiteParseUtil.createDocumentBuilder();
    }

    public SiteParseUtil(String filename) {
        this.filename = filename;
        this.parser = SiteParseUtil.createDocumentBuilder();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public Document getDocument() throws ParsingException, IOException {
        Document doc = null;
        if (this.filename == null) {
            throw new IOException("filename is not specified.");
        }
        try {
            doc = this.parser.parse(new File(this.filename));
        }
        catch (Exception e) {
            throw new ParsingException(e.getMessage());
        }
        return doc;
    }

    private static DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.log(e);
        }
        catch (FactoryConfigurationError e) {
            Logger.log(e);
        }
        return null;
    }
}

