/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.RootModel;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.StepupModel;
import com.ibm.etools.siteedit.site.model.TrailModel;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SiteModelUtil2 {
    public static Set getPagesReferedBySharedPage(SiteModel site) {
        final HashSet result = new HashSet();
        site.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent c) {
                if (c.getType() == SiteComponentType.SHAREDPAGE) {
                    result.add(((SharedPageModel)c).getTargetPage());
                }
                return true;
            }
        });
        if (result.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    public static boolean optimizeTreeRoots(List roots) {
        ArrayList<SiteComponent> toRemove = new ArrayList<SiteComponent>(roots.size());
        block0: for (SiteComponent sc : roots) {
            SiteComponent i = sc.getParentForEditing();
            while (i != null) {
                if (roots.contains(i)) {
                    toRemove.add(sc);
                    continue block0;
                }
                i = i.getParentForEditing();
            }
        }
        return roots.removeAll(toRemove);
    }

    public static Set getSharedPagesReferTo(final PageModel page) {
        final HashSet result = new HashSet();
        page.getSiteModel().accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent c) {
                if (c.getType() == SiteComponentType.SHAREDPAGE && ((SharedPageModel)c).getTargetPage() == page) {
                    result.add(c);
                }
                return true;
            }
        });
        if (result.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return result;
    }

    public static List calcurateRootsForRemove(List orgRoots) {
        final ArrayList roots = new ArrayList(orgRoots);
        SiteModelUtil2.optimizeTreeRoots(roots);
        if (roots.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        final Set targetPages = SiteModelUtil2.getPagesReferedBySharedPage(((SiteComponent)orgRoots.get(0)).getSiteModel());
        int index = 0;
        while (index < roots.size()) {
            SiteComponent sc = (SiteComponent)roots.get(index);
            sc.accept(new SiteComponentVisitor(){

                @Override
                public boolean visit(SiteComponent c) {
                    if (c.getType() == SiteComponentType.PAGE && targetPages.contains(c)) {
                        roots.addAll(SiteModelUtil2.getSharedPagesReferTo((PageModel)c));
                    }
                    return true;
                }
            });
            ++index;
        }
        SiteModelUtil2.optimizeTreeRoots(roots);
        return roots;
    }

    public static boolean isValidComponentArray(SiteComponent[] array) {
        if (array == null) {
            return false;
        }
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == null) {
                return false;
            }
            --i;
        }
        return true;
    }

    public static boolean hasDepth(SiteComponent c) {
        SiteComponentType t = c.getType();
        return t == SiteComponentType.PAGE || t == SiteComponentType.LINK || t == SiteComponentType.SHAREDPAGE || t == SiteComponentType.WEBPROJECT;
    }

    public static GroupModel[] getGroups(SiteModel m) {
        final ArrayList result = new ArrayList();
        m.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent c) {
                if (c.getType() == SiteComponentType.GROUP) {
                    result.add(c);
                }
                return true;
            }
        });
        return result.toArray(new GroupModel[result.size()]);
    }

    public static PageModel findPageModelBySRC(SiteModel siteModel, final String src) {
        if (siteModel == null || src == null) {
            return null;
        }
        final PageModel[] result = new PageModel[1];
        siteModel.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent sc) {
                if (sc.getType() == SiteComponentType.PAGE && src.equals(((PageModel)sc).getSRC())) {
                    result[0] = (PageModel)sc;
                }
                return result[0] == null;
            }
        });
        return result[0];
    }

    public static WebprojectModel findProjectModelBySRC(SiteModel siteModel, final String src) {
        if (siteModel == null || src == null) {
            return null;
        }
        final WebprojectModel[] result = new WebprojectModel[1];
        siteModel.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent sc) {
                if (sc.getType() == SiteComponentType.WEBPROJECT && src.equals(((WebprojectModel)sc).getSRC())) {
                    result[0] = (WebprojectModel)sc;
                }
                return result[0] == null;
            }
        });
        return result[0];
    }

    public static void resetSiteModel(SiteModel siteModel) {
        if (siteModel == null) {
            return;
        }
        siteModel.setParentForEditing(null);
        siteModel.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent component) {
                for (SiteComponent child : component.getAllChildren()) {
                    child.setParentForEditing(null);
                }
                return true;
            }
        });
    }

    public static RootModel createViewModelFor(SiteComponent newRoot, SiteModel siteModel) {
        SiteModel siteTop;
        if (siteModel == null) {
            return null;
        }
        if (newRoot == null) {
            newRoot = siteModel;
        }
        SiteModelUtil2.resetSiteModel(siteModel);
        TrailModel trail = new TrailModel(siteModel);
        SiteComponent cur = newRoot;
        while (cur != null && !(cur instanceof SiteModel)) {
            trail.appendTrailAncestor(cur);
            cur = cur.getParent();
        }
        if (newRoot instanceof SiteModel) {
            siteTop = siteModel;
        } else {
            siteTop = new SiteModel();
            StepupModel stepup = new StepupModel(siteModel);
            SiteModelUtil2.appendChildForEditing(stepup, newRoot);
            SiteModelUtil2.appendChildForEditing(siteTop, stepup);
        }
        RootModel result = new RootModel(siteModel);
        SiteModelUtil2.appendChildForEditing(result, trail);
        SiteModelUtil2.appendChildForEditing(result, siteTop);
        return result;
    }

    private static void appendChildForEditing(SiteComponent target, SiteComponent toAdd) {
        if (target == null || toAdd == null) {
            return;
        }
        SiteComponent parent = toAdd.getParent();
        target.appendChild(toAdd);
        toAdd.setParent(parent);
        toAdd.setParentForEditing(target);
    }

    public static SiteComponent[] getAllItems(SiteModel m) {
        SiteComponent[] childItems = m.getChildren();
        ArrayList list = new ArrayList();
        list = SiteModelUtil2.findAllItems(childItems, list);
        int size = list.size();
        return list.toArray(new SiteComponent[size]);
    }

    private static ArrayList findAllItems(SiteComponent[] rootItem, ArrayList list) {
        int size = rootItem.length;
        int i = 0;
        while (i < size) {
            list.add(rootItem[i]);
            if (rootItem[i].numberOfChildren() > 0) {
                list = SiteModelUtil2.findAllItems(rootItem[i].getChildren(), list);
            }
            ++i;
        }
        return list;
    }
}

