/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.LinkModel;
import com.ibm.etools.siteedit.site.model.NavItemSiteComponent;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.ParsingException;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteParseUtil;
import com.ibm.etools.siteedit.site.model.SiteXmlDefaultValues;
import com.ibm.etools.siteedit.site.model.SiteXmlStrings;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteModelLoader
implements SiteXmlStrings,
SiteXmlDefaultValues {
    private static final String TRACE_KEY = "model/loader";
    private HashMap referenceMap = new HashMap(3);
    private HashSet missingNodeIdSet = new HashSet(1);
    private ArrayList referenceResolver = new ArrayList(1);
    private SiteModel site;

    public static SiteModel createSite(String siteFilePath) throws ParsingException {
        SiteParseUtil parseUtil = new SiteParseUtil(siteFilePath);
        try {
            SiteModelLoader maker = new SiteModelLoader();
            return maker.createSite(parseUtil.getDocument());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParsingException(e.getMessage());
        }
    }

    public static SiteModel createSiteFromDocument(Document doc) {
        SiteModelLoader maker = new SiteModelLoader();
        return maker.createSite(doc);
    }

    private SiteModelLoader() {
    }

    private SiteModel createSite(Document doc) {
        Element node = doc.getDocumentElement();
        if (node == null) {
            return null;
        }
        Node siteNode = SiteModelLoader.getSiteNode(node);
        if (siteNode == null) {
            return null;
        }
        this.site = new SiteModel();
        this.site.setTemplate(SiteModelLoader.getTemplateFrom(siteNode));
        NodeList children = siteNode.getChildNodes();
        if (children != null) {
            int index = 0;
            while (index < children.getLength()) {
                Node aNode = children.item(index);
                if (aNode.getNodeType() == 1) {
                    String aNodeName = aNode.getNodeName();
                    if (!this.appendNodeCommon(aNode, this.site)) {
                        if (aNodeName.equalsIgnoreCase("description")) {
                            this.site.setDescription(SiteModelLoader.getDescriptionFrom(aNode));
                        } else if (aNodeName.equalsIgnoreCase("author")) {
                            this.site.setAuthor(SiteModelLoader.getAuthorFrom(aNode));
                        }
                    }
                }
                ++index;
            }
        }
        for (ReferenceResolver resolver : this.referenceResolver) {
            resolver.resolve();
        }
        this.site.calcurateNextNodeId();
        for (SiteComponent sc : this.missingNodeIdSet) {
            sc.setNodeId(this.site.getNextNodeId());
        }
        return this.site;
    }

    private boolean appendNodeCommon(Node aNode, SiteComponent parent) {
        String aNodeName = aNode.getNodeName();
        SiteComponent sc = null;
        if (aNodeName.equalsIgnoreCase("page")) {
            sc = this.createPage(aNode);
        } else if (aNodeName.equalsIgnoreCase("pagelink")) {
            sc = this.createSharedPage(aNode);
        } else if (aNodeName.equalsIgnoreCase("webproject")) {
            sc = this.createWebproject(aNode);
        } else if (aNodeName.equalsIgnoreCase("link")) {
            sc = this.createLink(aNode);
        } else if (aNodeName.equalsIgnoreCase("group")) {
            sc = this.createGroup(aNode);
        } else {
            return false;
        }
        String nodeId = ((Element)aNode).getAttribute("nid");
        if (nodeId != null && nodeId.length() > 0) {
            if (this.referenceMap.containsKey(nodeId)) {
                Logger.log("Bad site structure detected.");
                if (SiteModelLoader._isTracing()) {
                    SiteModelLoader._trace("SiteIIModelLoader: duplicated node id: " + nodeId);
                }
            }
            this.referenceMap.put(nodeId, sc);
            sc.setNodeId(nodeId);
        } else {
            this.missingNodeIdSet.add(sc);
        }
        parent.appendChild(sc);
        return true;
    }

    private void initAttributeCommon(SiteComponent sc) {
        if (sc instanceof NavItemSiteComponent) {
            NavItemSiteComponent nsc = (NavItemSiteComponent)sc;
            nsc.setNavigation(true);
            nsc.setSiteMap(true);
        }
    }

    private boolean appendAttributesCommon(Node aNode, SiteComponent sc) {
        if (aNode.getNodeName().equalsIgnoreCase("nid")) {
            return true;
        }
        if (sc instanceof NavItemSiteComponent) {
            NavItemSiteComponent nsc = (NavItemSiteComponent)sc;
            if (aNode.getNodeName().equalsIgnoreCase("navigation")) {
                String value = aNode.getNodeValue();
                nsc.setNavigation(Boolean.valueOf(value));
                return true;
            }
            if (aNode.getNodeName().equalsIgnoreCase("sitemap")) {
                String value = aNode.getNodeValue();
                nsc.setSiteMap(Boolean.valueOf(value));
                return true;
            }
        }
        return false;
    }

    private static Node getSiteNode(Node topNode) {
        String nodeName;
        Node siteNode = null;
        if (topNode.getNodeType() == 1 && (nodeName = topNode.getNodeName()).equalsIgnoreCase("website")) {
            NodeList children = topNode.getChildNodes();
            int index = 0;
            while (index < children.getLength()) {
                Node aNode = children.item(index);
                nodeName = aNode.getNodeName();
                if (nodeName.equalsIgnoreCase("structure")) {
                    siteNode = aNode;
                    break;
                }
                ++index;
            }
        }
        return siteNode;
    }

    private static String getTitleFrom(Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return "";
        }
        int index = 0;
        while (index < children.getLength()) {
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 3) {
                String tmp = aNode.getNodeValue();
                tmp = tmp.trim();
                String title = "";
                int i = 0;
                while (i < tmp.length()) {
                    char c = tmp.charAt(i);
                    if (c != '\r' && c != '\n') {
                        title = String.valueOf(title) + c;
                    }
                    ++i;
                }
                return title;
            }
            ++index;
        }
        return "";
    }

    private static String getDescriptionFrom(Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return "";
        }
        int index = 0;
        while (index < children.getLength()) {
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 3) {
                return aNode.getNodeValue();
            }
            ++index;
        }
        return "";
    }

    private static String getTemplateFrom(Node node) {
        if (node == null) {
            return "";
        }
        String ret = ((Element)node).getAttribute("template");
        if (ret == null) {
            ret = "";
        }
        return ret;
    }

    private PageModel createPage(Node node) {
        PageModel page = new PageModel(this.site);
        this.setPageAttributes(page, node);
        this.setPageChildren(page, node);
        return page;
    }

    private SharedPageModel createSharedPage(Node node) {
        SharedPageModel spage = new SharedPageModel(this.site, null);
        this.setSharedPageAttributes(spage, node);
        this.setSharedPageChildren(spage, node);
        return spage;
    }

    private WebprojectModel createWebproject(Node node) {
        WebprojectModel wpmodel = new WebprojectModel(this.site);
        this.setWebprojectAttributes(wpmodel, node);
        this.setWebprojectChildren(wpmodel, node);
        return wpmodel;
    }

    private LinkModel createLink(Node node) {
        LinkModel link = new LinkModel(this.site);
        this.setLinkAttributes(link, node);
        this.setLinkChildren(link, node);
        return link;
    }

    private GroupModel createGroup(Node node) {
        GroupModel group = new GroupModel(this.site);
        this.setGroupAttributes(group, node);
        this.setGroupChildren(group, node);
        return group;
    }

    private void setPageAttributes(PageModel page, Node node) {
        this.initAttributeCommon(page);
        page.setNavroot(false);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int index = 0;
        while (index < attributes.getLength()) {
            Node aNode = attributes.item(index);
            if (!this.appendAttributesCommon(aNode, page)) {
                if (aNode.getNodeName().equalsIgnoreCase("src")) {
                    page.setSRC(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("template")) {
                    page.setTemplate(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("status")) {
                    page.setDocStatus(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("author")) {
                    page.setAuthor(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("navroot")) {
                    page.setNavroot(Boolean.valueOf(aNode.getNodeValue()));
                } else if (aNode.getNodeName().equalsIgnoreCase("id")) {
                    page.setId(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("servleturl")) {
                    page.setServletUrl(aNode.getNodeValue());
                }
            }
            ++index;
        }
    }

    private void setSharedPageAttributes(SharedPageModel spage, Node node) {
        this.initAttributeCommon(spage);
        spage.setSyncLabel(true);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int index = 0;
        while (index < attributes.getLength()) {
            Node aNode = attributes.item(index);
            if (!this.appendAttributesCommon(aNode, spage)) {
                if (aNode.getNodeName().equalsIgnoreCase("id")) {
                    spage.setId(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("ref")) {
                    this.referenceResolver.add(new ReferenceResolver(spage, aNode.getNodeValue()));
                } else if (aNode.getNodeName().equalsIgnoreCase("synclabel")) {
                    String value = aNode.getNodeValue();
                    spage.setSyncLabel(Boolean.valueOf(value));
                }
            }
            ++index;
        }
    }

    private void setWebprojectAttributes(WebprojectModel wproject, Node node) {
        this.initAttributeCommon(wproject);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int index = 0;
        while (index < attributes.getLength()) {
            Node aNode = attributes.item(index);
            if (!this.appendAttributesCommon(aNode, wproject) && aNode.getNodeName().equalsIgnoreCase("src")) {
                wproject.setSRC(aNode.getNodeValue());
            }
            ++index;
        }
    }

    private void setLinkAttributes(LinkModel link, Node node) {
        this.initAttributeCommon(link);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int index = 0;
        while (index < attributes.getLength()) {
            Node aNode = attributes.item(index);
            if (!this.appendAttributesCommon(aNode, link)) {
                if (aNode.getNodeName().equalsIgnoreCase("src")) {
                    link.setSRC(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("id")) {
                    link.setId(aNode.getNodeValue());
                }
            }
            ++index;
        }
    }

    private void setPageChildren(PageModel page, Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int index = 0;
        while (index < children.getLength()) {
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 1) {
                String aNodeName = aNode.getNodeName();
                if (aNodeName.equalsIgnoreCase("title")) {
                    page.setTitle(SiteModelLoader.getTitleFrom(aNode));
                } else {
                    this.appendNodeCommon(aNode, page);
                }
            }
            ++index;
        }
    }

    private void setSharedPageChildren(SharedPageModel page, Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int index = 0;
        while (index < children.getLength()) {
            String aNodeName;
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 1 && (aNodeName = aNode.getNodeName()).equalsIgnoreCase("title")) {
                page.setTitle(SiteModelLoader.getTitleFrom(aNode));
            }
            ++index;
        }
    }

    private void setWebprojectChildren(WebprojectModel wpmodel, Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int index = 0;
        while (index < children.getLength()) {
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 1) {
                this.appendNodeCommon(aNode, wpmodel);
            }
            ++index;
        }
    }

    private void setLinkChildren(LinkModel link, Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int index = 0;
        while (index < children.getLength()) {
            String aNodeName;
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 1 && (aNodeName = aNode.getNodeName()).equalsIgnoreCase("title")) {
                link.setTitle(SiteModelLoader.getTitleFrom(aNode));
            }
            ++index;
        }
    }

    private void setGroupAttributes(GroupModel group, Node node) {
        this.initAttributeCommon(group);
        group.setDepth(0);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return;
        }
        int index = 0;
        while (index < attributes.getLength()) {
            Node aNode = attributes.item(index);
            if (!this.appendAttributesCommon(aNode, group)) {
                if (aNode.getNodeName().equalsIgnoreCase("id")) {
                    group.setId(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("gid")) {
                    group.setGroupId(aNode.getNodeValue());
                } else if (aNode.getNodeName().equalsIgnoreCase("depth")) {
                    try {
                        group.setDepth(Integer.parseInt(aNode.getNodeValue()));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (aNode.getNodeName().equalsIgnoreCase("color")) {
                    String value = aNode.getNodeValue();
                    group.setColor(value);
                }
            }
            ++index;
        }
    }

    private void setGroupChildren(GroupModel group, Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return;
        }
        int index = 0;
        while (index < children.getLength()) {
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 1) {
                String aNodeName = aNode.getNodeName();
                if (aNodeName.equalsIgnoreCase("title")) {
                    group.setTitle(SiteModelLoader.getTitleFrom(aNode));
                } else {
                    this.appendNodeCommon(aNode, group);
                }
            }
            ++index;
        }
    }

    private static String getAuthorFrom(Node node) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return "";
        }
        int index = 0;
        while (index < children.getLength()) {
            Node aNode = children.item(index);
            if (aNode.getNodeType() == 3) {
                return aNode.getNodeValue();
            }
            ++index;
        }
        return "";
    }

    private static void _trace(String msg) {
        Logger.trace(TRACE_KEY, msg);
    }

    private static boolean _isTracing() {
        return Logger.isTracing(TRACE_KEY);
    }

    class ReferenceResolver {
        private SiteComponent sc;
        private String refId;

        public ReferenceResolver(SiteComponent sc, String refId) {
            this.sc = sc;
            this.refId = refId;
            if (SiteModelLoader._isTracing()) {
                System.out.println("SiteIIModelLoader: add reference cueue: " + refId + " for " + sc);
            }
        }

        public void resolve() {
            try {
                SiteComponent resolved = this.getReference();
                if (this.sc.getType() == SiteComponentType.SHAREDPAGE) {
                    ((SharedPageModel)this.sc).setTargetPage((PageModel)resolved);
                    if (resolved == null) {
                        this.sc.getParent().removeChildAt(this.sc.getParent().indexOf(this.sc));
                        if (SiteModelLoader._isTracing()) {
                            SiteModelLoader._trace("SiteIIModelLoader: reference not resolved. " + this.sc + " is removed.");
                        }
                    }
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }

        private SiteComponent getReference() {
            SiteComponent result = (SiteComponent)SiteModelLoader.this.referenceMap.get(this.refId);
            if (result == null) {
                Logger.log(2, "SiteIIModelLoader cannot resolve refid: " + this.refId);
            }
            return result;
        }
    }
}

