/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.GroupModel;
import com.ibm.etools.siteedit.site.model.LinkModel;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModelListener;
import com.ibm.etools.siteedit.site.model.UnmappedPageModel;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import java.util.ArrayList;
import java.util.Collection;

public class SiteModel
extends SiteComponent {
    private transient int nextNodeId;
    private transient boolean handleEvent = true;
    private final transient ArrayList listeners = new ArrayList(3);
    private String template = "";
    private String description = "";
    private String author = "";

    public SiteModel() {
        super(null);
        this.site = this;
    }

    @Override
    public SiteComponentType getType() {
        return SiteComponentType.SITE;
    }

    public WebprojectModel createWebproject() {
        WebprojectModel r = new WebprojectModel(this);
        r.setNodeId(this.getNextNodeId());
        return r;
    }

    public PageModel createPageModel() {
        PageModel r = new PageModel(this);
        r.setNodeId(this.getNextNodeId());
        return r;
    }

    public LinkModel createLinkModel() {
        LinkModel r = new LinkModel(this);
        r.setNodeId(this.getNextNodeId());
        return r;
    }

    public GroupModel createGroupModel() {
        GroupModel r = new GroupModel(this);
        r.setNodeId(this.getNextNodeId());
        return r;
    }

    public SharedPageModel createSharedPageModel(PageModel page) {
        SharedPageModel r = new SharedPageModel(this, page);
        r.setNodeId(this.getNextNodeId());
        return r;
    }

    public UnmappedPageModel createUnmappedPageModel() {
        UnmappedPageModel r = new UnmappedPageModel(this);
        return r;
    }

    String getNextNodeId() {
        return Integer.toString(this.nextNodeId++);
    }

    void calcurateNextNodeId() {
        final int[] result = new int[1];
        this.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent component) {
                try {
                    int value = Integer.parseInt(component.getNodeId());
                    if (result[0] < value) {
                        result[0] = value;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return true;
            }
        });
        this.nextNodeId = result[0] + 1;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setChangedAndNotify();
    }

    public String getDescription() {
        return this.description;
    }

    public void setTemplate(String template) {
        boolean updated;
        if (template == null) {
            template = "";
        }
        boolean bl = updated = !template.equals(this.template);
        if (!updated) {
            return;
        }
        this.template = template;
        this.setChangedAndNotify();
    }

    public String getTemplate() {
        return this.template;
    }

    public void setAuthor(String author) {
        this.author = author;
        this.setChangedAndNotify();
    }

    public String getAuthor() {
        return this.author;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSiteModelListener(SiteModelListener sml) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(sml)) {
                this.listeners.add(sml);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSiteModelListener(Collection sml) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.addAll(sml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSiteModelListener(SiteModelListener sml) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(sml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSiteModelListener(Collection sml) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.removeAll(sml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SiteModelListener[] getListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return this.listeners.toArray(new SiteModelListener[this.listeners.size()]);
        }
    }

    void notifyPostChildAddition(SiteComponent child) {
        if (!this.handleEvent) {
            return;
        }
        if (child.isOrphan()) {
            return;
        }
        SiteModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].postChildAdded(child);
            ++i;
        }
    }

    void notifyPreChildRemoval(SiteComponent child) {
        if (!this.handleEvent) {
            return;
        }
        if (child.isOrphan()) {
            return;
        }
        SiteModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].preChildRemoved(child);
            ++i;
        }
    }

    void notifyPostPropertyChanged(SiteModelListener.SiteComponentEvent e) {
        if (!this.handleEvent) {
            return;
        }
        SiteComponent child = e.sc;
        if (child.isOrphan()) {
            return;
        }
        SiteModelListener[] targets = this.getListeners();
        int i = 0;
        while (i < targets.length) {
            targets[i].postPropertyChanged(e);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalExecWithoutListener(Runnable runnable) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            try {
                this.handleEvent = false;
                runnable.run();
            }
            finally {
                this.handleEvent = true;
            }
        }
    }

    @Override
    public void copyProperties(SiteComponent other) {
        throw new UnsupportedOperationException();
    }
}

