/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.NavItemSiteComponent;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModel;
import java.util.Observable;
import java.util.Observer;

public class SharedPageModel
extends NavItemSiteComponent {
    private PageModel targetPage;
    private boolean syncLabel = true;
    private final Observer targetPageObserver = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            SharedPageModel.this.setChangedAndNotify(arg);
        }
    };

    SharedPageModel(SiteModel site, PageModel targetPage) {
        super(site);
        this.setTargetPage(targetPage);
    }

    @Override
    public SiteComponentType getType() {
        return SiteComponentType.SHAREDPAGE;
    }

    public PageModel getTargetPage() {
        return this.targetPage;
    }

    final void setTargetPage(PageModel targetPage) {
        if (this.targetPage != null) {
            this.targetPage.deleteObserver(this.targetPageObserver);
        }
        this.targetPage = targetPage;
        if (this.targetPage != null) {
            this.targetPage.addObserver(this.targetPageObserver);
        }
    }

    @Override
    public String getTitle() {
        if (this.syncLabel) {
            return this.targetPage.getTitle();
        }
        return super.getTitle();
    }

    public void setSyncLabel(boolean syncLabel) {
        this.syncLabel = syncLabel;
        if (!syncLabel && this.targetPage != null) {
            this.setTitle(this.targetPage.getTitle());
        }
        this.setChangedAndNotify();
    }

    public boolean getSyncLabel() {
        return this.syncLabel;
    }

    public String getSRC() {
        return this.targetPage.getSRC();
    }

    @Override
    public String toString() {
        return "SharedPage(target=" + this.getTargetPage() + ")";
    }

    @Override
    public void copyProperties(SiteComponent target) {
        super.copyProperties(target);
        SharedPageModel copy = (SharedPageModel)target;
        copy.setSyncLabel(this.getSyncLabel());
    }
}

