/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.site.model;

import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelUtil2;
import com.ibm.etools.siteedit.site.model.TrailModel;

public class RootModel
extends SiteComponent {
    private final SiteModel originalModel;

    RootModel(SiteModel original) {
        super(original);
        this.originalModel = original;
    }

    @Override
    public SiteComponentType getType() {
        return SiteComponentType.ROOT;
    }

    @Override
    public SiteModel getSiteModel() {
        int i = this.numberOfChildren() - 1;
        while (i >= 0) {
            if (this.getChildAt(i) instanceof SiteModel) {
                return (SiteModel)this.getChildAt(i);
            }
            --i;
        }
        return null;
    }

    public TrailModel getTrailModel() {
        int i = this.numberOfChildren() - 1;
        while (i >= 0) {
            if (this.getChildAt(i) instanceof TrailModel) {
                return (TrailModel)this.getChildAt(i);
            }
            --i;
        }
        return null;
    }

    public SiteModel getOriginalSiteModel() {
        return this.originalModel;
    }

    public static int getNodeCount(SiteComponent sc) {
        if (sc == null) {
            return 0;
        }
        final int[] result = new int[1];
        sc.accept(new SiteComponentVisitor(){

            @Override
            public boolean visit(SiteComponent component) {
                if (SiteModelUtil2.hasDepth(component)) {
                    result[0] = result[0] + 1;
                }
                return true;
            }
        });
        return result[0];
    }

    public static int getNodeDepth(SiteComponent sc) {
        int result = 0;
        while (sc != null && sc.getType() != SiteComponentType.SITE) {
            ++result;
            sc = sc.getParentForEditing();
        }
        return result;
    }

    public static SiteModel getOriginalSiteModel(SiteComponent c) {
        SiteComponent b = c;
        while (c != null) {
            if (c instanceof RootModel) {
                return ((RootModel)c).getOriginalSiteModel();
            }
            c = c.getParentForEditing();
        }
        while (b != null) {
            if (b instanceof SiteModel) {
                return (SiteModel)b;
            }
            c = b.getParent();
        }
        return null;
    }

    @Override
    public void copyProperties(SiteComponent other) {
        throw new UnsupportedOperationException();
    }
}

