/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.builder.ISiteCoreConstants;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import com.ibm.etools.siteedit.nature.WebSiteNatureRuntime;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebComponentUtil
implements ISiteCoreConstants {
    private static final String CSS_FOLDER_NAME = "theme";

    public static IFile getActiveWebSiteConfigFile(IVirtualComponent component) {
        if (!WebComponentUtil.hasWebSiteFeature(component)) {
            return null;
        }
        return component.getProject().getFile(".website-config");
    }

    public static IFile getWebSiteConfigFile(IVirtualComponent component) {
        if (!WebComponentUtil.isValidComponent(component)) {
            return null;
        }
        return component.getProject().getFile(".website-config");
    }

    public static IVirtualComponent findComponentFromWebSiteConfig(IResource metadata) {
        if (metadata == null) {
            return null;
        }
        return WebComponentUtil.getFirstComponent(metadata.getProject());
    }

    public static IVirtualComponent findComponent(IResource resource) {
        if (resource == null) {
            return null;
        }
        return ComponentCore.createComponent((IProject)resource.getProject());
    }

    public static String encodeComponentToText(IVirtualComponent component, boolean ommitComponentNameForTheFirstComponent) {
        String name = component.getProject().getName();
        if (ommitComponentNameForTheFirstComponent && component.equals(WebComponentUtil.getFirstComponent(component.getProject()))) {
            return name;
        }
        name = String.valueOf(name) + ":" + component.getName();
        return name;
    }

    public static String encodeComponentToText(IVirtualComponent component) {
        return WebComponentUtil.encodeComponentToText(component, true);
    }

    public static IVirtualComponent decodeComponentFromText(String encodedText) {
        int cIndex = encodedText.indexOf(58);
        String projectName = cIndex >= 0 ? encodedText.substring(0, cIndex) : encodedText;
        IProject project = SiteResourceUtil.getProject(projectName);
        return WebComponentUtil.getFirstComponent(project);
    }

    public static boolean isFlexibleProject(IProject project) {
        return ModuleCoreNature.isFlexibleProject((IProject)project);
    }

    public static IVirtualComponent getFirstComponent(IProject project) {
        if (project == null || !WebComponentUtil.isFlexibleProject(project)) {
            return null;
        }
        IVirtualComponent[] vcomp = WebComponentUtil.getComponents(project);
        return vcomp.length > 0 ? vcomp[0] : null;
    }

    public static IVirtualComponent[] getComponents(IProject project) {
        return new IVirtualComponent[]{WebComponentUtil.findComponent((IResource)project)};
    }

    public static IProject getProject(IVirtualComponent component) {
        if (component == null) {
            return null;
        }
        return component.getProject();
    }

    public static boolean hasWebSiteFeature(IVirtualComponent component) {
        return WebComponentUtil.hasComponentFeature(component, "web.siteedit");
    }

    public static boolean isWebComponent(IVirtualComponent component) {
        return WebComponentUtil.isStaticComponent(component) || WebComponentUtil.isJ2EEComponent(component);
    }

    public static boolean isStaticComponent(IVirtualComponent component) {
        return WebComponentUtil.hasComponentFeature(component, "wst.web");
    }

    public static boolean isJ2EEComponent(IVirtualComponent component) {
        return WebComponentUtil.hasComponentFeature(component, "jst.web");
    }

    public static boolean hasComponentFeature(IVirtualComponent component, String facet_id) {
        block5: {
            block4: {
                try {
                    if (WebComponentUtil.isValidComponent(component)) break block4;
                    return false;
                }
                catch (Exception e) {
                    Logger.log(e);
                    return false;
                }
            }
            if (ProjectFacetsManager.isProjectFacetDefined((String)facet_id)) break block5;
            return false;
        }
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facet_id);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
        return facetedProject != null && facetedProject.hasProjectFacet(facet);
    }

    public static void installProjectFacet(IProject project, String facet_id, IProgressMonitor monitor) throws CoreException {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)facet_id);
        ProjectFacetsManager.create((IProject)project).installProjectFacet(facet.getLatestVersion(), null, monitor);
    }

    public static boolean ensureWebsiteConfig(IVirtualComponent component) {
        IFile websiteConfig = WebComponentUtil.getWebSiteConfigFile(component);
        if (websiteConfig == null) {
            return false;
        }
        if (websiteConfig.exists()) {
            return true;
        }
        SiteModelContainer container = SiteModelManager.getDefault().getModelContainerForEdit(component);
        try {
            boolean bl = container.save(null);
            return bl;
        }
        catch (Exception e) {
            Logger.log(e);
            return false;
        }
        finally {
            container.release();
        }
    }

    public static boolean isValidForWebSiteFeature(IVirtualComponent component) {
        if (!WebComponentUtil.isValidComponent(component)) {
            return false;
        }
        try {
            IFacetedProject fp = ProjectFacetsManager.create((IProject)component.getProject());
            if (fp == null) {
                IProjectFacet facet;
                NullProgressMonitor monitor = new NullProgressMonitor();
                fp = ProjectFacetsManager.create((IProject)component.getProject(), (boolean)true, (IProgressMonitor)monitor);
                if (!fp.hasProjectFacet(facet = ProjectFacetsManager.getProjectFacet((String)"web.siteedit"))) {
                    WebComponentUtil.installProjectFacet(component.getProject(), "jst.java", (IProgressMonitor)monitor);
                    WebComponentUtil.installProjectFacet(component.getProject(), "jst.web", (IProgressMonitor)monitor);
                    WebComponentUtil.installProjectFacet(component.getProject(), "web.siteedit", (IProgressMonitor)new NullProgressMonitor());
                }
            }
            IProjectFacetVersion fv = ProjectFacetsManager.getProjectFacet((String)"web.siteedit").getVersion("7.0");
            IProjectFacet dynamicPF = ProjectFacetsManager.getProjectFacet((String)"jst.web");
            IProjectFacet staticPF = ProjectFacetsManager.getProjectFacet((String)"wst.web");
            boolean isProjectFacetVersionValid = false;
            for (IProjectFacet f : fp.getFixedProjectFacets()) {
                if (fv.getProjectFacet() == f || dynamicPF == f || staticPF == f) {
                    isProjectFacetVersionValid = true;
                }
                if (isProjectFacetVersionValid) break;
            }
            return isProjectFacetVersionValid && !WebComponentUtil.hasComponentFeature(component, "web.portal");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static void ensureWebSiteFeature(IVirtualComponent component, IProgressMonitor monitor) {
        if (!WebComponentUtil.isValidForWebSiteFeature(component) || WebComponentUtil.hasWebSiteFeature(component)) {
            return;
        }
        try {
            WebComponentUtil.installProjectFacet(component.getProject(), "web.siteedit", monitor);
        }
        catch (CoreException e) {
            Logger.log(e);
        }
    }

    public static String getServerContextRoot(IVirtualComponent component) {
        if (!WebComponentUtil.isValidComponent(component)) {
            return null;
        }
        return ComponentUtilities.getServerContextRoot((IProject)component.getProject());
    }

    public static int getServletVersion(IVirtualComponent component) {
        int version = 0;
        WebArtifactEdit wae = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
        if (wae != null) {
            try {
                version = wae.getServletVersion();
            }
            finally {
                wae.dispose();
            }
        }
        return version;
    }

    public static WebApp getWebApp(IVirtualComponent component) {
        if (!WebComponentUtil.isValidComponent(component)) {
            return null;
        }
        WebArtifactEdit wae = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)component);
        if (wae == null) {
            return null;
        }
        try {
            WebApp webApp = wae.getWebApp();
            return webApp;
        }
        finally {
            wae.dispose();
        }
    }

    public static IContainer getRootPublishableFolder(IVirtualComponent component) {
        if (!WebComponentUtil.isValidComponent(component)) {
            return null;
        }
        return component.getRootFolder().getUnderlyingFolder();
    }

    public static IContainer getWebModuleContainer(IVirtualComponent component) {
        return WebComponentUtil.getRootPublishableFolder(component);
    }

    public static IContainer getComponentRootFolder(IVirtualComponent component) {
        return WebComponentUtil.getRootPublishableFolder(component);
    }

    public static IFolder getDefaultCSSFolder(IVirtualComponent component) {
        IContainer root = WebComponentUtil.getRootPublishableFolder(component);
        return root == null ? null : WebComponentUtil.getCSSFolder(root);
    }

    public static IFolder getCSSFolder(IContainer container) {
        return container.getFolder((IPath)new Path(CSS_FOLDER_NAME));
    }

    public static IFolder getWEBINFFolder(IVirtualComponent component) {
        IContainer root = WebComponentUtil.getRootPublishableFolder(component);
        return root == null ? null : root.getFolder((IPath)new Path("WEB-INF"));
    }

    public static IFolder getLibraryFolder(IVirtualComponent component) {
        IContainer root = WebComponentUtil.getRootPublishableFolder(component);
        return root == null ? null : root.getFolder(WebArtifactEdit.WEBLIB);
    }

    private static boolean isValidComponent(IVirtualComponent component) {
        return component != null && component.exists();
    }

    public static boolean isPortletProject(IVirtualComponent component) {
        block5: {
            block4: {
                try {
                    if (WebComponentUtil.isValidComponent(component)) break block4;
                    return false;
                }
                catch (Exception e) {
                    Logger.log(e);
                    return false;
                }
            }
            if (ProjectFacetsManager.isProjectFacetDefined((String)"jsr.base") && ProjectFacetsManager.isProjectFacetDefined((String)"ibmportlet.base")) break block5;
            return false;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)component.getProject());
        IProjectFacet jsrPortletFacet = ProjectFacetsManager.getProjectFacet((String)"jsr.base");
        IProjectFacet ibmPortletfacet = ProjectFacetsManager.getProjectFacet((String)"ibmportlet.base");
        return facetedProject != null && (facetedProject.hasProjectFacet(jsrPortletFacet) || facetedProject.hasProjectFacet(ibmPortletfacet));
    }

    public static boolean checkEmptyConfigFile(IProject project) {
        boolean bsiteStructureEmpty = true;
        try {
            String nodeName;
            IVirtualComponent component = WebComponentUtil.getFirstComponent(project);
            Element topNode = null;
            IFile file = WebComponentUtil.getWebSiteConfigFile(component);
            SiteXmlDocumentUtil docUtil = new SiteXmlDocumentUtil();
            String filePath = file.getLocation().toString();
            docUtil.load(filePath);
            if (docUtil != null) {
                topNode = docUtil.getRootElement();
            }
            if (topNode != null && topNode.getNodeType() == 1 && (nodeName = topNode.getNodeName()).equalsIgnoreCase("website")) {
                NodeList children = topNode.getChildNodes();
                int index = 0;
                while (index < children.getLength()) {
                    Node aNode = children.item(index);
                    nodeName = aNode.getNodeName();
                    if (nodeName.equalsIgnoreCase("structure")) {
                        NodeList childrenOfStructure = aNode.getChildNodes();
                        if (childrenOfStructure.getLength() <= 0) break;
                        bsiteStructureEmpty = false;
                        break;
                    }
                    ++index;
                }
            }
            if (topNode == null) {
                bsiteStructureEmpty = true;
            }
        }
        catch (Exception e) {
            Logger.log(e);
            e.printStackTrace();
        }
        return bsiteStructureEmpty;
    }

    public static boolean hasWebSiteNature(IProject project) {
        try {
            return project.hasNature("com.ibm.etools.siteedit.WebSiteNature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void addWebSiteRuntimeNature(IProject project) {
        try {
            if (!WebComponentUtil.hasWebSiteNature(project) && !WebComponentUtil.checkEmptyConfigFile(project)) {
                WebSiteNatureRuntime.ensureWebSiteNature(project, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            Logger.log(e);
            e.printStackTrace();
        }
    }
}

