/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.core.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SiteXmlDocumentUtil {
    protected Document document;
    private String rootElementName;

    protected DocumentBuilder getDocumentBuilder() {
        DocumentBuilder result = null;
        try {
            result = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Logger.logException(e);
        }
        return result;
    }

    protected Document _getNewDocumentDOM2() {
        Document result = null;
        DocumentBuilder builder = this.getDocumentBuilder();
        result = builder.newDocument();
        if (this.rootElementName != null && this.rootElementName.length() > 0) {
            Element settings = result.createElement(this.rootElementName);
            result.appendChild(settings);
        }
        return result;
    }

    protected Document _getParsedDocumentDOM2(String filename) {
        DocumentBuilder builder = this.getDocumentBuilder();
        try {
            FileReader inputReader = new FileReader(filename);
            InputSource inputSource = new InputSource(inputReader);
            return builder.parse(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
        return null;
    }

    protected String getRootElementName() {
        return this.rootElementName;
    }

    public void setRootElementName(String rootElementName) {
        this.rootElementName = rootElementName;
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getRootElement() {
        Element element = this.document != null ? (Element)this.document.getFirstChild() : null;
        return element;
    }

    public Element getElementByAttr(String elemName, String attrName, String attrValue) {
        Node node;
        Element element = null;
        Node node2 = node = this.document != null ? this.document.getFirstChild() : null;
        if (node != null) {
            node = node.getFirstChild();
        }
        while (node != null) {
            String value;
            if (node.getNodeType() == 1 && ((Element)node).getTagName().equals(elemName) && (value = ((Element)node).getAttribute(attrName)) != null && value.equals(attrValue)) {
                element = (Element)node;
                break;
            }
            node = node.getNextSibling();
        }
        if (element == null) {
            element = this.document.createElement(elemName);
            element.setAttribute(attrName, attrValue);
            Node root = this.document.getFirstChild();
            root.appendChild(element);
        }
        return element;
    }

    protected Document getParsedDocument(String filename) {
        File existenceTester;
        Document result = null;
        if (filename != null && (existenceTester = new File(filename)).exists()) {
            result = this._getParsedDocumentDOM2(filename);
        }
        return result;
    }

    protected Document createDocument() {
        Document result = null;
        result = this._getNewDocumentDOM2();
        return result;
    }

    public void load(String filename) {
        this.document = this.getParsedDocument(filename);
        if (this.document == null) {
            this.document = this.createDocument();
            this.save(filename);
        }
    }

    public void loadBlank() {
        this.document = this.createDocument();
    }

    public void save(String filename) {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        try {
            FileWriter output = new FileWriter(filename);
            SiteXmlDocumentUtil.saveDocument(this.document, output);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            Logger.log(e);
        }
    }

    public static void saveDocument(Document document, IFile file) throws CoreException, IOException {
        SiteXmlDocumentUtil.saveDocument(document, file, null);
    }

    public static void saveDocument(Document document, IFile file, IProgressMonitor monitor) throws CoreException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SiteXmlDocumentUtil.saveDocument(document, baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        if (file.exists()) {
            file.setContents((InputStream)bais, true, true, monitor);
        } else {
            file.create((InputStream)bais, true, monitor);
        }
        bais.close();
    }

    public static void saveDocument(Document document, Writer writer) throws IOException {
        SiteXmlDocumentUtil.serialize(document, new StreamResult(writer));
    }

    public static void saveDocument(Document document, OutputStream out) throws IOException {
        SiteXmlDocumentUtil.serialize(document, new StreamResult(out));
    }

    private static void serialize(Document sourceDocument, StreamResult result) throws IOException {
        DOMSource domSource = new DOMSource(sourceDocument);
        try {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            try {
                serializer.setOutputProperty("indent", "yes");
                serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            serializer.transform(domSource, result);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IOException(e.getMessage());
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
    }
}

