/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteComponentVisitor;
import com.ibm.etools.siteedit.site.model.SiteModel;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelManager;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import com.ibm.etools.siteedit.site.model.command.SiteSubProjectUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public final class SiteSubProjectUtil2
implements SiteSubProjectUtil {
    @Override
    public boolean confirmToAdd(SiteComponent target, SiteComponent[] ins, Object shell) {
        IVirtualComponent[] rel = SiteSubProjectUtil2.getExistingComponentsUnder(ins);
        if (rel.length == 0) {
            return true;
        }
        IVirtualComponent[] modify = SiteSubProjectUtil2.findComponentsWhoseNavigationNeedsToModifiedByAdd(SiteSubProjectUtil2.getContainerComponent(target), rel);
        if (modify.length == 0) {
            return true;
        }
        return true;
    }

    @Override
    public boolean confirmToRemove(SiteComponent target, SiteComponent[] del, Object shell) {
        return true;
    }

    @Override
    public void modifyReferencesToAdd(SiteComponent target, SiteComponent[] components) {
        IVirtualComponent[] targets = SiteSubProjectUtil2.getExistingComponentsUnder(components);
        if (targets == null || targets.length == 0) {
            return;
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        IVirtualComponent component = SiteSubProjectUtil2.getContainerComponent(target);
        try {
            int i = 0;
            while (i < targets.length) {
                SiteSubProjectUtil2.ensureUplinkInSiteNavigation(targets[i], component, (IProgressMonitor)monitor);
                ++i;
            }
            SiteSubProjectUtil2.addComponentReferencesToComponentDescription(component, targets, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Logger.log(e);
        }
    }

    @Override
    public void modifyReferencesToRemove(final SiteComponent target, SiteComponent[] components) {
        final IVirtualComponent[] targets = SiteSubProjectUtil2.getExistingComponentsUnder(components);
        if (targets == null || targets.length == 0) {
            return;
        }
        WorkspaceModifyOperation job = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IVirtualComponent component = SiteSubProjectUtil2.getContainerComponent(target);
                int i = 0;
                while (i < targets.length) {
                    SiteSubProjectUtil2.removeLinkInSiteNavigation(targets[i], component, monitor);
                    ++i;
                }
                SiteSubProjectUtil2.removeComponentReferencesFromComponentDescription(component, targets, monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (IRunnableWithProgress)job, null);
        }
        catch (InvocationTargetException e) {
            Logger.log(e);
        }
        catch (InterruptedException e) {
            Logger.log(e);
        }
    }

    private static WebprojectModel findTargetProjectModel(SiteComponent siteComponent, IVirtualComponent component) {
        return SiteSubProjectUtil2.findTargetProjectModel(siteComponent, WebComponentUtil.encodeComponentToText(component));
    }

    private static WebprojectModel findTargetProjectModel(SiteComponent siteComponent, String src) {
        Iterator it = siteComponent.iterator();
        while (it.hasNext()) {
            WebprojectModel wm;
            SiteComponent sc = (SiteComponent)it.next();
            if (sc instanceof WebprojectModel && src.equals((wm = (WebprojectModel)sc).getSRC())) {
                return (WebprojectModel)sc;
            }
            wm = SiteSubProjectUtil2.findTargetProjectModel(sc, src);
            if (wm == null) continue;
            return wm;
        }
        return null;
    }

    private static SiteComponent findFirstPageModel(SiteComponent siteComponent) {
        Iterator it = siteComponent.iterator();
        while (it.hasNext()) {
            SiteComponent sc = (SiteComponent)it.next();
            if (!(sc instanceof PageModel)) continue;
            return sc;
        }
        return null;
    }

    private static IVirtualComponent[] getExistingComponentsUnder(SiteComponent[] scomps) {
        final ArrayList result = new ArrayList();
        int i = 0;
        while (i < scomps.length) {
            scomps[i].accept(new SiteComponentVisitor(){

                @Override
                public boolean visit(SiteComponent sc) {
                    IVirtualComponent comp;
                    if (sc.getType() == SiteComponentType.WEBPROJECT && (comp = SiteSubProjectUtil2.findComponent((WebprojectModel)sc)) != null && comp.exists()) {
                        result.add(comp);
                    }
                    return true;
                }
            });
            ++i;
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    private static IVirtualComponent getContainerComponent(SiteComponent target) {
        SiteModelManager mm = SiteCorePlugin.getDefault().getSiteModelManager();
        SiteModel sm = target.getSiteModel();
        SiteModelContainer smc = mm.findModelContainerForTemp(sm);
        return smc.getComponent();
    }

    public static IVirtualComponent findComponent(WebprojectModel model) {
        return WebComponentUtil.decodeComponentFromText(model.getSRC());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void ensureUplinkInSiteNavigation(IVirtualComponent component, IVirtualComponent partner, IProgressMonitor monitor) {
        SiteModelManager mm = SiteModelManager.getDefault();
        SiteModelContainer mc = mm.getModelContainerForEdit(component);
        try {
            if (mc == null) return;
            if (mc.getSiteModel() == null) {
                return;
            }
            if (!SiteSubProjectUtil2.hasDownlink(partner, component)) {
                return;
            }
            WebprojectModel link = SiteSubProjectUtil2.findTargetProjectModel((SiteComponent)mc.getSiteModel(), partner);
            if (link == null) {
                SiteModel siteModel = mc.getSiteModel();
                link = siteModel.createWebproject();
                link.setSRC(WebComponentUtil.encodeComponentToText(partner));
                SiteComponent pm = SiteSubProjectUtil2.findFirstPageModel(siteModel);
                if (pm != null) {
                    siteModel.removeChildAt(siteModel.indexOf(pm));
                    link.appendChild(pm);
                }
                siteModel.appendChild(link);
                mc.save(monitor);
            }
            link.setRealized(SiteSubProjectUtil2.isComponentRealized(partner));
            return;
        }
        finally {
            if (mc != null) {
                mc.release();
            }
        }
    }

    private static boolean hasDownlink(IVirtualComponent component, IVirtualComponent partner) {
        SiteModelManager mm = SiteModelManager.getDefault();
        SiteModelContainer mc = mm.getModelContainerForRead(component);
        try {
            if (mc == null || mc.getSiteModel() == null) {
                return false;
            }
            WebprojectModel link = SiteSubProjectUtil2.findTargetProjectModel((SiteComponent)mc.getSiteModel(), partner);
            boolean bl = link != null && !(link.getParent() instanceof SiteModel);
            return bl;
        }
        finally {
            if (mc != null) {
                mc.release();
            }
        }
    }

    private static void removeLinkInSiteNavigation(IVirtualComponent component, IVirtualComponent partner, IProgressMonitor monitor) {
        SiteModelManager mm = SiteModelManager.getDefault();
        SiteModelContainer mc = mm.getModelContainerForEdit(component);
        try {
            SiteComponent parent;
            int ndx;
            if (mc == null) {
                return;
            }
            SiteModel siteModel = mc.getSiteModel();
            if (siteModel == null) {
                return;
            }
            WebprojectModel link = SiteSubProjectUtil2.findTargetProjectModel((SiteComponent)siteModel, partner);
            if (link != null && (ndx = (parent = link.getParent()).indexOf(link)) >= 0) {
                parent.removeChildAt(ndx);
                int i = link.numberOfChildren() - 1;
                while (i >= 0) {
                    parent.addChildAt(ndx, link.getChildAt(i));
                    --i;
                }
            }
        }
        finally {
            if (mc != null) {
                mc.release();
            }
        }
    }

    private static IVirtualComponent[] addComponentReferencesToComponentDescription(IVirtualComponent current, IVirtualComponent[] targets, IProgressMonitor monitor) throws CoreException {
        List<IVirtualComponent> ref = Arrays.asList(SiteSubProjectUtil2.getReferencedComponents(current));
        ArrayList<IVirtualComponent> newReferencedComponents = new ArrayList<IVirtualComponent>(targets.length);
        int i = 0;
        while (i < targets.length) {
            IVirtualComponent comp = targets[i];
            if (!ref.contains(comp) && !newReferencedComponents.contains(comp) && WebComponentUtil.isWebComponent(comp) && WebComponentUtil.hasWebSiteFeature(comp)) {
                newReferencedComponents.add(comp);
            }
            ++i;
        }
        if (!newReferencedComponents.isEmpty()) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>(Arrays.asList(current.getReferences()));
                monitor.beginTask("", newRefs.size());
                for (IVirtualComponent newReferencedComponent : newReferencedComponents) {
                    IVirtualReference newRef = ComponentCore.createReference((IVirtualComponent)current, (IVirtualComponent)newReferencedComponent);
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
                    newRef.create(0, (IProgressMonitor)subMonitor);
                    newRefs.add(newRef);
                }
                current.setReferences(newRefs.toArray(new IVirtualReference[newRefs.size()]));
            }
            finally {
                monitor.done();
            }
        }
        return newReferencedComponents.toArray(new IVirtualComponent[newReferencedComponents.size()]);
    }

    private static IVirtualComponent[] removeComponentReferencesFromComponentDescription(IVirtualComponent current, IVirtualComponent[] targets, IProgressMonitor monitor) throws CoreException {
        List<IVirtualComponent> ref = Arrays.asList(SiteSubProjectUtil2.getReferencedComponents(current));
        ArrayList<IVirtualComponent> removedComponents = new ArrayList<IVirtualComponent>(targets.length);
        int i = 0;
        while (i < targets.length) {
            IVirtualComponent comp = targets[i];
            if (ref.contains(comp) && !removedComponents.contains(comp) && WebComponentUtil.isWebComponent(comp) && WebComponentUtil.hasWebSiteFeature(comp)) {
                removedComponents.add(comp);
            }
            ++i;
        }
        if (!removedComponents.isEmpty()) {
            ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>(Arrays.asList(current.getReferences()));
            Iterator<IVirtualReference> it = newRefs.iterator();
            while (it.hasNext()) {
                IVirtualReference newRef = it.next();
                if (!removedComponents.contains(newRef.getReferencedComponent())) continue;
                it.remove();
            }
            current.setReferences(newRefs.toArray(new IVirtualReference[newRefs.size()]));
        }
        return removedComponents.toArray(new IVirtualComponent[removedComponents.size()]);
    }

    private static IVirtualComponent[] findComponentsWhoseNavigationNeedsToModifiedByAdd(IVirtualComponent current, IVirtualComponent[] targets) {
        ArrayList<IVirtualComponent> result = new ArrayList<IVirtualComponent>(targets.length);
        SiteModelManager mm = SiteCorePlugin.getDefault().getSiteModelManager();
        int i = 0;
        while (i < targets.length) {
            SiteModelContainer mc;
            if (WebComponentUtil.hasWebSiteFeature(targets[i]) && (mc = mm.getModelContainerForRead(targets[i])) != null) {
                try {
                    if (SiteSubProjectUtil2.findTargetProjectModel((SiteComponent)mc.getSiteModel(), current) == null) {
                        result.add(targets[i]);
                    }
                }
                finally {
                    mc.release();
                }
            }
            ++i;
        }
        return result.toArray(new IVirtualComponent[result.size()]);
    }

    public static boolean isComponentRealized(IVirtualComponent component) {
        return WebComponentUtil.hasWebSiteFeature(component);
    }

    public static IVirtualComponent[] getReferencedComponents(IVirtualComponent component) {
        IVirtualReference[] refs = component.exists() ? component.getReferences() : new IVirtualReference[]{};
        IVirtualComponent[] result = new IVirtualComponent[refs.length];
        int i = 0;
        while (i < refs.length) {
            result[i] = refs[i].getReferencedComponent();
            ++i;
        }
        return result;
    }
}

