/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.internal.core.util.SiteXmlDocumentUtil;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteRestorableXmlDocumentUtil
extends SiteXmlDocumentUtil {
    private ArrayList nodeArray;

    @Override
    public void load(String filename) {
        super.load(filename);
        this.cloneNodes(this.document);
    }

    protected void cloneNodes(Document doc) {
        if (doc == null) {
            return;
        }
        if (this.nodeArray == null) {
            this.nodeArray = new ArrayList();
        } else {
            this.nodeArray.clear();
        }
        NodeList nodes = doc.getChildNodes();
        if (nodes != null) {
            int len = nodes.getLength();
            int i = 0;
            while (i < len) {
                Node node = nodes.item(i).cloneNode(true);
                this.nodeArray.add(node);
                ++i;
            }
        }
    }

    public void restoreNodes() {
        NodeList nodes = this.document.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            this.document.removeChild(node);
            ++i;
        }
        if (this.document != null && this.nodeArray != null) {
            i = 0;
            while (i < this.nodeArray.size()) {
                Object o = this.nodeArray.get(i);
                if (o instanceof Node) {
                    this.document.appendChild((Node)o);
                }
                ++i;
            }
        }
        this.cloneNodes(this.document);
    }
}

