/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.webedit.links.util.FileURL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SiteResourceUtil {
    public static String getFileName(String path) {
        String strName = path;
        int idx = path.lastIndexOf(47);
        if (idx >= 0) {
            strName = path.substring(idx + 1);
        }
        return strName;
    }

    public static String getFileExtension(String fileName) {
        String strExt = fileName;
        int idx = fileName.lastIndexOf(46);
        if (idx >= 0) {
            strExt = fileName.substring(idx + 1);
        }
        return strExt;
    }

    public static String getName(String fileName) {
        String strName = fileName;
        int idx = strName.lastIndexOf(46);
        if (idx > 0) {
            strName = strName.substring(0, idx);
        }
        return strName;
    }

    public static IProject getProject(String name) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(name);
    }

    public static IFile fileForProjectRelative(IVirtualComponent component, IPath path) {
        return component.getProject().getFile(path);
    }

    public static IFile fileForProjectRelative(IVirtualComponent component, String fileName) {
        return SiteResourceUtil.fileForProjectRelative(component.getProject(), fileName);
    }

    public static IFile fileForProjectRelative(IProject project, String fileName) {
        if (fileName.equals("")) {
            return null;
        }
        return project.getFile(fileName);
    }

    public static IFile fileForLocation(IPath location) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
    }

    public static IFile fileForComponentRelative(IVirtualComponent component, String path) {
        return component.getRootFolder().getFile((IPath)new Path(path)).getUnderlyingFile();
    }

    public static String getProjectRelativePathString(IVirtualComponent component, IResource res) {
        return SiteResourceUtil.getProjectRelativePathString(component.getProject(), res);
    }

    public static IPath getProjectRelativePath(IProject project, IResource resource) {
        IPath projectRoot;
        if (resource == null) {
            return null;
        }
        IPath projectRelativePath = resource.getFullPath();
        int c = projectRelativePath.matchingFirstSegments(projectRoot = project.getFullPath());
        if (c > 0) {
            projectRelativePath = projectRelativePath.removeFirstSegments(c);
        }
        return projectRelativePath;
    }

    public static String getProjectRelativePathString(IProject project, IResource resource) {
        String result = "";
        IPath path = SiteResourceUtil.getProjectRelativePath(project, resource);
        if (path == null) {
            return result;
        }
        result = path.setDevice("").toString();
        if (result.length() > 0 && result.charAt(0) != '/') {
            result = String.valueOf('/') + result;
        }
        return result;
    }

    public static String getProjectRelativePathString(IVirtualComponent component, IPath path) {
        return SiteResourceUtil.getProjectRelativePathString(component.getProject(), path);
    }

    public static String getProjectRelativePathString(IProject project, IPath path) {
        String result;
        IPath projectRelativePath = path;
        IPath projectRoot = project.getFullPath();
        int c = projectRelativePath.matchingFirstSegments(projectRoot);
        if (c == 0) {
            c = projectRelativePath.matchingFirstSegments(project.getLocation());
        }
        if (c > 0) {
            projectRelativePath = projectRelativePath.removeFirstSegments(c);
        }
        if ((result = projectRelativePath.setDevice("").toString()).length() > 0 && result.charAt(0) != '/') {
            result = String.valueOf('/') + result;
        }
        return result;
    }

    public static String getProjectRelativeString(IVirtualComponent component, FileURL fileURL) {
        return SiteResourceUtil.getProjectRelativeString(component.getProject(), fileURL);
    }

    public static String getProjectRelativeString(IProject project, FileURL fileURL) {
        IPath projectPath = project.getLocation();
        IPath absUrl = fileURL.getPath().makeAbsolute();
        int ncnt = absUrl.matchingFirstSegments(projectPath);
        absUrl = absUrl.removeFirstSegments(ncnt);
        String retUrl = (absUrl = absUrl.setDevice("")).toString();
        if (retUrl != null && retUrl.length() > 0 && retUrl.charAt(0) != '/') {
            retUrl = String.valueOf('/') + retUrl;
        }
        return retUrl;
    }

    public static String getWebModuleRelativeString(IResource resource) {
        IVirtualComponent component = WebComponentUtil.findComponent(resource);
        IPath projectRelativePath = resource.getFullPath();
        IPath webModulePath = WebComponentUtil.getWebModuleContainer(component).getProjectRelativePath();
        int nMatch = projectRelativePath.matchingFirstSegments(webModulePath);
        IPath webModuleRelativePath = projectRelativePath.removeFirstSegments(nMatch);
        return webModuleRelativePath.setDevice("").toString();
    }

    public static boolean isComponentResource(IVirtualComponent component, IResource resource) {
        if (component == null || resource == null) {
            return false;
        }
        IContainer c = WebComponentUtil.getComponentRootFolder(component);
        if (c == null) {
            return false;
        }
        return c.getFullPath().isPrefixOf(resource.getFullPath());
    }
}

