/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.SiteSubProjectUtil2;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.PageModel;
import com.ibm.etools.siteedit.site.model.SharedPageModel;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteComponentType;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelManager;
import com.ibm.etools.siteedit.site.model.WebprojectModel;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class SiteModelResUtil {
    public static IFile getIFile(SiteComponent sc) {
        return SiteModelResUtil.getIFile(sc, true);
    }

    public static IFile getIFile(SiteComponent sc, boolean allowDerived) {
        IFile file;
        IVirtualComponent component;
        if (sc == null) {
            return null;
        }
        SiteModelContainer smc = SiteModelManager.getDefault().findModelContainerForTemp(sc.getSiteModel());
        if (smc == null) {
            return null;
        }
        String src = null;
        if (sc.getType() == SiteComponentType.SHAREDPAGE) {
            if (allowDerived) {
                src = ((SharedPageModel)sc).getTargetPage().getSRC();
            }
        } else if (sc.getType() == SiteComponentType.PAGE) {
            src = ((PageModel)sc).getSRC();
        } else if (sc.getType() == SiteComponentType.WEBPROJECT && WebComponentUtil.hasWebSiteFeature(component = SiteSubProjectUtil2.findComponent((WebprojectModel)sc))) {
            return WebComponentUtil.getActiveWebSiteConfigFile(component);
        }
        if (src != null && (file = SiteResourceUtil.fileForProjectRelative(smc.getComponent(), src)) != null && file.exists()) {
            return file;
        }
        return null;
    }

    public static IFile[] getIFile(SiteComponent[] sc, boolean allowDerived) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        if (sc != null) {
            int i = 0;
            while (i < sc.length) {
                IFile file = SiteModelResUtil.getIFile(sc[i], allowDerived);
                if (file != null && !result.contains(file)) {
                    result.add(file);
                }
                ++i;
            }
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static boolean getRealized(SiteComponent sc) {
        IFile file = SiteModelResUtil.getIFile(sc);
        return file != null && file.exists();
    }

    public static IVirtualComponent getComponent(SiteComponent sc) {
        SiteModelContainer smc = SiteModelManager.getDefault().findModelContainerForTemp(sc.getSiteModel());
        return smc == null ? null : smc.getComponent();
    }

    public static IVirtualComponent getTargetComponent(SiteComponent siteComponent) {
        if (siteComponent instanceof WebprojectModel) {
            return SiteSubProjectUtil2.findComponent((WebprojectModel)siteComponent);
        }
        return null;
    }
}

