/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.services.providers.ProviderArguments;
import com.ibm.etools.references.web.URIUtil;
import com.ibm.etools.siteedit.core.Logger;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.webedit.links.util.ContextRootManager;
import com.ibm.etools.webedit.links.util.FileURL;
import com.ibm.etools.webedit.links.util.InvalidURLException;
import com.ibm.etools.webedit.links.util.URI;
import java.util.EnumSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class LinkUtil {
    public static IPath getFileLocation(IFile baseFile, String src, boolean contextRootSensitive) {
        if (src == null || baseFile == null) {
            return null;
        }
        String absURL = com.ibm.etools.webedit.viewer.utils.LinkUtil.getAbsURL((IPath)baseFile.getLocation(), (IPath)baseFile.getLocation(), (String)src, (boolean)contextRootSensitive);
        return LinkUtil.getFileLocation(absURL);
    }

    public static IFile getFile(IFile baseFile, String tagName, String attrName, String attrValue, String baseHref) {
        IFile result = null;
        String URI2 = com.ibm.etools.webedit.viewer.utils.LinkUtil.getAbsURL((IPath)baseFile.getLocation(), (IPath)baseFile.getLocation(), (String)attrValue, (boolean)true);
        if (URI2 != null) {
            Path pathOfFile = new Path(URI2);
            return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)pathOfFile);
        }
        String absUrl = null;
        EnumSet<ProviderArguments> args = EnumSet.of(ProviderArguments.LINKSTYLE_ABSOLUTE);
        SpecializedType linkType = ReferenceManager.getReferenceManager().getLinkType("web.commonlink");
        String linkText = ReferenceManager.getReferenceManager().expandLinkText(linkType, attrValue, (IResource)baseFile, args);
        Path path1 = new Path(linkText);
        String relativePathOfSrc = null;
        relativePathOfSrc = attrValue.startsWith("/") ? path1.removeFirstSegments(1).toString() : linkText;
        absUrl = URIUtil.makeAbsoluteURI((String)("file:////" + baseFile.getLocation().toString()), (String)relativePathOfSrc);
        if (absUrl.indexOf("file/") >= 0) {
            absUrl = absUrl.split("file/")[1];
        }
        if (absUrl != null) {
            Path path = new Path(absUrl);
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        }
        return result;
    }

    private static IPath getFileLocation(String absURL) {
        Path filePath = null;
        String scheme = URI.getOnlyScheme((String)absURL);
        if (scheme != null && scheme.length() > 0) {
            if (scheme.compareToIgnoreCase("file") == 0) {
                try {
                    FileURL fileURL = new FileURL(absURL);
                    filePath = fileURL.getPath();
                }
                catch (InvalidURLException e) {
                    Logger.log(e);
                }
            }
        } else {
            filePath = new Path(absURL);
        }
        return filePath;
    }

    public static IFile getTemplateFile(IFile file, String src) {
        IPath location = LinkUtil.getFileLocation(file, src, false);
        if (location == null) {
            return null;
        }
        return SiteResourceUtil.fileForLocation(location);
    }

    public static IPath getDocumentRoot(IVirtualComponent component) {
        IContainer root = WebComponentUtil.getRootPublishableFolder(component);
        return root == null ? null : root.getLocation().addTrailingSeparator();
    }

    public static String getDocRootLocation(IProject newProject, String sourceLocation) {
        String projDocRootLocation = "";
        if (newProject == null) {
            int index = sourceLocation.lastIndexOf(47);
            if (index != -1) {
                projDocRootLocation = sourceLocation.substring(0, index + 1);
            }
            return projDocRootLocation;
        }
        projDocRootLocation = ContextRootManager.getRootLocation((IProject)newProject);
        if (projDocRootLocation == null) {
            projDocRootLocation = newProject.getLocation().addTrailingSeparator().toString();
            return projDocRootLocation;
        }
        return projDocRootLocation;
    }

    public static String getDocRootRelative(IVirtualComponent component, IFile fileToEncode) {
        return LinkUtil.makeDocRootRelative(component.getProject(), fileToEncode.getLocation().toString(), fileToEncode.getLocation().toString(), LinkUtil.getDocumentRoot(component).toString(), WebComponentUtil.getServerContextRoot(component), "A", "href");
    }

    public static String makeDocRootRelative(IProject project, String sourceLocation, String absoluteLink, String docRoot, String serverContextRoot, String tagname, String attributeName) {
        if (absoluteLink == null || absoluteLink.length() == 0) {
            if (absoluteLink != null) {
                return absoluteLink;
            }
            return "";
        }
        String protocol = URI.getOnlyScheme((String)absoluteLink).toLowerCase();
        if (!"".equals(protocol) && !"file".equals(protocol)) {
            return null;
        }
        IPath filePath = null;
        FileURL fileURL = null;
        try {
            fileURL = new FileURL(absoluteLink);
        }
        catch (InvalidURLException invalidURLException) {
            fileURL = new FileURL((IPath)new Path(absoluteLink));
        }
        filePath = fileURL.getPath().makeRelative();
        IPath docRootPath = new Path(docRoot).makeRelative();
        if (!LinkUtil.sameDevices(filePath, docRootPath)) {
            return null;
        }
        int docRootSegments = docRootPath.matchingFirstSegments(filePath);
        if (docRootSegments == docRootPath.segmentCount()) {
            filePath = filePath.removeFirstSegments(docRootSegments);
            if (serverContextRoot != null && serverContextRoot.length() > 0) {
                Path serverContextRootIPath = new Path(serverContextRoot);
                IPath webAppPath = serverContextRootIPath.makeAbsolute();
                filePath = filePath.setDevice(null);
                filePath = webAppPath.append(filePath);
            }
            return filePath.setDevice(null).makeAbsolute().toString();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sameDevices(IPath path1, IPath path2) {
        device1 = path1.getDevice();
        device2 = path2.getDevice();
        if (device1 == null && device2 == null) {
            return true;
        }
        if (device1 != null && device2 != null) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            device1 = device1.substring(1);
lbl8:
            // 2 sources

            ** while (device1.length() > 0 && device1.charAt((int)0) == '/')
        }
lbl9:
        // 2 sources

        while (device2.length() > 0 && device2.charAt(0) == '/') {
            device2 = device2.substring(1);
        }
        return device1.toLowerCase().equals(device2.toLowerCase());
    }
}

