/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.core.util;

import com.ibm.etools.siteedit.internal.builder.util.ui.DirtyEditorUtil;
import com.ibm.etools.siteedit.internal.core.util.ISiteResourceChangeListener;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.siteedit.site.model.SiteComponent;
import com.ibm.etools.siteedit.site.model.SiteModelContainer;
import com.ibm.etools.siteedit.site.model.SiteModelManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;

public class EditorUtil {
    private DirtyEditorUtil editorUtil;

    protected DirtyEditorUtil getEditorUtil() {
        if (this.editorUtil == null) {
            this.editorUtil = DirtyEditorUtil.Factory.create();
        }
        return this.editorUtil;
    }

    public IDocument getDirtyDocument(IFile file) {
        return this.getEditorUtil().getDirtyDocument(file);
    }

    public void observePart(IFile file, SiteComponent c) {
        SiteModelContainer smc = SiteModelManager.getDefault().findModelContainerForTemp(c.getSiteModel());
        if (smc == null || smc.getFile() == null) {
            return;
        }
        IAdaptable siteDesigner = this.findSiteDesigner(smc.getFile());
        if (!(siteDesigner instanceof IEditorPart)) {
            return;
        }
        IEditorPart site = (IEditorPart)siteDesigner;
        IEditorPart editor = (IEditorPart)this.getEditorUtil().getDirtyEditor(file);
        if (editor == null) {
            return;
        }
        PartListener listener = PartListener.getListener(site);
        listener.listen(editor, file);
    }

    public void observePart(IFile file) {
        IAdaptable siteDesigner = this.findSiteDesigner(WebComponentUtil.getWebSiteConfigFile(WebComponentUtil.getFirstComponent(file.getProject())));
        if (!(siteDesigner instanceof IEditorPart)) {
            return;
        }
        IEditorPart site = (IEditorPart)siteDesigner;
        IEditorPart editor = (IEditorPart)this.getEditorUtil().getDirtyEditor(file);
        if (editor == null) {
            return;
        }
        PartListener listener = PartListener.getListener(site);
        listener.listen(editor, file);
    }

    public IAdaptable findSiteDesigner(IFile file) {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                IWorkbenchWindow window = windows[i];
                IWorkbenchPage[] pages = window.getPages();
                int j = 0;
                while (j < pages.length) {
                    IWorkbenchPage page = pages[j];
                    IEditorReference[] editorRefs = page.getEditorReferences();
                    int k = 0;
                    while (k < editorRefs.length) {
                        IFile inputFile;
                        IEditorPart editor = editorRefs[i].getEditor(false);
                        if (editor != null && file.equals((Object)(inputFile = ResourceUtil.getFile((IEditorInput)editor.getEditorInput()))) && editor.getAdapter(SiteModelContainer.class) != null) {
                            return editor;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    protected static class PartListener
    implements IPartListener {
        private static final Map site2listener = Collections.synchronizedMap(new HashMap(5));
        private IEditorPart site;
        private WeakHashMap part2file = new WeakHashMap(2);

        public static PartListener getListener(IEditorPart site) {
            PartListener result = (PartListener)site2listener.get(site);
            if (result == null) {
                result = new PartListener(site);
                site2listener.put(site, result);
            }
            return result;
        }

        public void listen(IEditorPart editor, IFile file) {
            editor.getSite().getPage().addPartListener((IPartListener)this);
            this.part2file.put(editor, file);
        }

        public PartListener(IEditorPart site) {
            this.site = site;
            site.getSite().getPage().addPartListener((IPartListener)this);
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            IFile file;
            if (this.site == null) {
                return;
            }
            final IEditorPart currentSite = this.site;
            if (site2listener.remove(part) != null) {
                part.getSite().getPage().removePartListener((IPartListener)this);
            }
            if (this.site == part) {
                this.site = null;
            }
            if ((file = (IFile)this.part2file.remove(part)) != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (currentSite instanceof ISiteResourceChangeListener) {
                            ((ISiteResourceChangeListener)currentSite).handleContentReplaced((IResource)file);
                        }
                    }
                });
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

