/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util.ui;

import com.ibm.etools.siteedit.core.ResourceHandler;
import com.ibm.etools.siteedit.internal.core.preference.SitePreferenceManager;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

class ReadOnlyFailureDialog
extends MessageDialog
implements Listener {
    private static final String[] buttonLabels = new String[]{IDialogConstants.OK_LABEL};
    private static final String title = ResourceHandler._UI_BUILDER_Updating_Files_using_Web_Site_Navigation_1;
    private Collection readOnlyFailedFiles;
    private Button continueToPrompt;
    private static final String message = ResourceHandler._UI_BUILDER_Some_of_the_files_using_Web_Site_Navigation_may_not_have_been_updated_due_to_being_marked_read_only__2;

    public ReadOnlyFailureDialog(Shell shell, Collection readOnlyFiles) {
        super(shell, title, null, message, 4, buttonLabels, 0);
        this.readOnlyFailedFiles = readOnlyFiles;
    }

    protected Control createCustomArea(Composite parent) {
        String msg = "";
        for (IFile f : this.readOnlyFailedFiles) {
            msg = String.valueOf(msg) + "\n" + f.getFullPath().toString();
        }
        Label label = new Label(parent, 64);
        label.setText(msg);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = 500;
        label.setLayoutData((Object)data);
        Composite promptGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        promptGroup.setLayout((Layout)layout);
        promptGroup.setLayoutData((Object)new GridData(768));
        this.continueToPrompt = new Button(promptGroup, 32);
        this.continueToPrompt.setText(ResourceHandler._UI_BUILDER_Show_this_message_when_updating_read_only_files_using_Web_Site_Navigation_3);
        this.continueToPrompt.setSelection(true);
        data = new GridData();
        this.continueToPrompt.setLayoutData((Object)data);
        this.continueToPrompt.addListener(13, (Listener)this);
        return promptGroup;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.continueToPrompt) {
            SitePreferenceManager.setBuilderShowReadOnlyPrompt(this.continueToPrompt.getSelection());
        }
    }

    public static void exec(final Collection readonlyFiles) {
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (shell = window.getShell()) != null) {
                        ReadOnlyFailureDialog dialog = new ReadOnlyFailureDialog(shell, readonlyFiles);
                        dialog.setBlockOnOpen(true);
                        dialog.create();
                        dialog.open();
                    }
                }
            });
        }
    }
}

