/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util.ui;

import com.ibm.etools.siteedit.core.ResourceHandler;
import com.ibm.etools.siteedit.internal.builder.SiteNavMessages;
import com.ibm.etools.siteedit.internal.builder.util.BuildFileCollector;
import com.ibm.etools.siteedit.internal.builder.util.ui.DirtyEditorUtil;
import com.ibm.etools.siteedit.internal.builder.util.ui.ResizableListSelectionDialog;
import com.ibm.etools.siteedit.internal.core.util.SiteResourceUtil;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.common.editdomain.HTMLSubModelContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

class DirtyEditorUtilImpl
implements DirtyEditorUtil {
    private IEditorPart[] dirtyEditors;
    private Map fileToEditorMap;

    static DirtyEditorUtil create() {
        return new DirtyEditorUtilImpl();
    }

    @Override
    public void scheduleSaveResources(IFile[] files, Object workbenchPart, Map descriptionMap, boolean requiresBuild) {
        SaveLaterJob saveResroucesJob = new SaveLaterJob(requiresBuild, (IWorkbenchPart)workbenchPart, descriptionMap, files);
        saveResroucesJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        saveResroucesJob.setSystem(true);
        saveResroucesJob.schedule();
    }

    @Override
    public IDocument getDirtyDocument(IFile file) {
        ITextFileBuffer buffer;
        if (file == null) {
            return null;
        }
        ITextFileBufferManager bm = FileBuffers.getTextFileBufferManager();
        if (bm != null && (buffer = bm.getTextFileBuffer(FileBuffers.normalizeLocation((IPath)file.getLocation()))) != null && buffer.isDirty()) {
            return buffer.getDocument();
        }
        return null;
    }

    @Override
    public IAdaptable getDirtyEditor(IFile file) {
        if (this.fileToEditorMap == null) {
            this.fileToEditorMap = new HashMap();
            IEditorPart[] editors = this.getDirtyEditors();
            int i = 0;
            while (i < editors.length) {
                IEditorPart part = editors[i];
                IFile[] files = this.getDirtyFiles(part);
                int j = 0;
                while (j < files.length) {
                    IFile file2 = files[j];
                    this.fileToEditorMap.put(file2, part);
                    ++j;
                }
                ++i;
            }
        }
        return (IEditorPart)this.fileToEditorMap.get(file);
    }

    @Override
    public IAdaptable getEditor(final IFile file) {
        final IAdaptable[] result = new IAdaptable[1];
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
                    int i = 0;
                    while (i < windows.length) {
                        IWorkbenchPage[] pages = windows[i].getPages();
                        int j = 0;
                        while (j < pages.length) {
                            IEditorReference[] editors = pages[j].getEditorReferences();
                            int k = 0;
                            while (k < editors.length) {
                                IEditorPart editor = editors[k].getEditor(false);
                                if (editor != null && file.equals((Object)ResourceUtil.getFile((IEditorInput)editor.getEditorInput()))) {
                                    result[0] = editor;
                                    return;
                                }
                                ++k;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
            });
        }
        return result[0];
    }

    @Override
    public boolean saveAllDirtyEditor(IFile[] files, Object workbenchPart) {
        return this.saveAllDirtyEditor(files, workbenchPart, null);
    }

    boolean saveAllDirtyEditor(final IFile[] files, final Object workbenchPart, Map description) {
        final boolean[] result = new boolean[1];
        ((IWorkbenchPart)workbenchPart).getSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = DirtyEditorUtilImpl.this.saveAllDirtyEditorCore(files, (IWorkbenchPart)workbenchPart, null);
            }
        });
        return result[0];
    }

    boolean saveAllDirtyEditorCore(IFile[] files, IWorkbenchPart part, Map description) {
        Object[] editorsToSave = this.filterByFiles(this.getDirtyEditors(), files);
        if (editorsToSave.length == 0) {
            return true;
        }
        ResizableListSelectionDialog dlg = new ResizableListSelectionDialog(part.getSite().getShell(), new AdaptableList(Arrays.asList(editorsToSave)), (IStructuredContentProvider)new WorkbenchContentProvider(), new MyLabelProvider(description), SiteNavMessages.SAVEDLG_MESSAGE){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Shell shell = parent.getShell();
                GC gc = new GC((Drawable)shell);
                gc.setFont(shell.getFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                int cancelButtonWidth = MessageDialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)ResourceHandler.DirtyEditorUtilImpl_1.length());
                Button cancel = this.getButton(1);
                cancel.setText(ResourceHandler.DirtyEditorUtilImpl_1);
                cancel.setSize(cancelButtonWidth, cancel.getSize().y);
                this.setButtonLayoutData(cancel);
            }
        };
        dlg.setTitle(SiteNavMessages.SAVEDLG_TITLE);
        dlg.setInitialSelections(editorsToSave);
        if (dlg.open() != 0) {
            return false;
        }
        Object[] saveTargetEditors = dlg.getResult();
        IEditorPart[] saveEditors = Arrays.asList(saveTargetEditors).toArray(new IEditorPart[saveTargetEditors.length]);
        IFile[] targetFiles = this.getDirtyFiles(saveEditors);
        if (targetFiles.length == 0) {
            return true;
        }
        return IDE.saveAllEditors((IResource[])targetFiles, (boolean)false);
    }

    @Override
    public IFile[] getAllDirtyFiles(IVirtualComponent[] filter) {
        return this.filterByComponent(this.getDirtyFiles(this.getDirtyEditors()), filter);
    }

    IEditorPart[] filterByComponent(IEditorPart[] editors, IVirtualComponent[] filter) {
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i];
            IFile[] files = this.filterByComponent(this.getDirtyFiles(editor), filter);
            if (files.length > 0) {
                result.add(editor);
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    IEditorPart[] filterByFiles(IEditorPart[] editors, IFile[] files) {
        List<IFile> cFiles = Arrays.asList(files);
        ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(editors.length);
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i];
            IFile[] dfiles = this.getDirtyFiles(editor);
            int j = 0;
            while (j < dfiles.length) {
                IFile file = dfiles[j];
                if (cFiles.contains(file)) {
                    result.add(editor);
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IEditorPart[result.size()]);
    }

    private IFile[] filterByComponent(IFile[] files, IVirtualComponent[] filter) {
        ArrayList<IFile> removeList = null;
        int i = 0;
        while (i < files.length) {
            IVirtualComponent component = WebComponentUtil.findComponent((IResource)files[i]);
            if (component != null) {
                int j = 0;
                while (j < filter.length) {
                    if (!component.equals(filter[j])) {
                        ++j;
                        continue;
                    }
                    break;
                }
            } else {
                if (removeList == null) {
                    removeList = new ArrayList<IFile>(3);
                }
                removeList.add(files[i]);
            }
            ++i;
        }
        if (removeList == null) {
            return files;
        }
        ArrayList<IFile> result = new ArrayList<IFile>(Arrays.asList(files));
        result.removeAll(removeList);
        return result.toArray(new IFile[result.size()]);
    }

    private IFile[] getDirtyFiles(IEditorPart[] editors) {
        ArrayList result = new ArrayList(editors.length);
        int i = 0;
        while (i < editors.length) {
            IEditorPart editor = editors[i];
            this.getDirtyFiles(editor, result);
            ++i;
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile[] getDirtyFiles(IEditorPart editor) {
        ArrayList result = new ArrayList(3);
        this.getDirtyFiles(editor, result);
        return result.toArray(new IFile[result.size()]);
    }

    private void getDirtyFiles(IEditorPart editor, Collection result) {
        if (editor instanceof HTMLEditDomain) {
            this.collectDirtyFilsFromPD((HTMLEditDomain)editor, result);
        } else {
            this.collectDirtyFilesDefault(editor, result);
        }
    }

    protected IEditorPart[] getDirtyEditors() {
        if (this.dirtyEditors == null) {
            ArrayList<IEditorPart> result = new ArrayList<IEditorPart>(8);
            if (PlatformUI.isWorkbenchRunning()) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    IWorkbenchWindow window = windows[i];
                    IWorkbenchPage[] pages = window.getPages();
                    int j = 0;
                    while (j < pages.length) {
                        IWorkbenchPage page = pages[j];
                        IEditorPart[] dirtyEditors = page.getDirtyEditors();
                        int k = 0;
                        while (k < dirtyEditors.length) {
                            IEditorPart dirtyEditor = dirtyEditors[k];
                            result.add(dirtyEditor);
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.dirtyEditors = result.toArray(new IEditorPart[result.size()]);
        }
        return this.dirtyEditors;
    }

    private void collectDirtyFilsFromPD(HTMLEditDomain domain, Collection result) {
        HTMLSubModelContext context;
        IFile file;
        IDOMModel model = domain.getActiveModel();
        if (model.isDirty() && (file = SiteResourceUtil.fileForLocation((context = domain.getActiveSubModelContext()).getFileBase())) != null && !result.contains(file) && BuildFileCollector.isSiteNavBuilderTargetResource((IResource)file)) {
            result.add(file);
        }
    }

    private void collectDirtyFilesDefault(IEditorPart editor, Collection result) {
        IFile file;
        if (editor.isDirty() && (file = ResourceUtil.getFile((IEditorInput)editor.getEditorInput())) != null && !result.contains(file) && BuildFileCollector.isSiteNavBuilderTargetResource((IResource)file)) {
            result.add(file);
        }
    }

    protected static class MyLabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        private final Map fileToDescr;
        private final WorkbenchPartLabelProvider parent;

        public MyLabelProvider(Map fileToDescr) {
            this.fileToDescr = fileToDescr;
            this.parent = new WorkbenchPartLabelProvider();
        }

        public String getColumnText(Object element, int columnIndex) {
            IFile file;
            Object o;
            String result = this.parent.getColumnText(element, columnIndex);
            if (this.fileToDescr == null) {
                return result;
            }
            if (element instanceof IEditorPart && (o = this.fileToDescr.get(file = ResourceUtil.getFile((IEditorInput)((IEditorPart)element).getEditorInput()))) != null) {
                return String.valueOf(result) + " (" + o.toString() + ")";
            }
            return result;
        }

        public Image getImage(Object element) {
            return this.parent.getImage(element);
        }

        public String getText(Object element) {
            return this.parent.getText(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.parent.isLabelProperty(element, property);
        }

        public void addListener(ILabelProviderListener listener) {
            this.parent.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.parent.removeListener(listener);
        }

        public void dispose() {
            this.parent.dispose();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return this.parent.getColumnImage(element, columnIndex);
        }
    }

    private static class SaveLaterJob
    extends UIJob {
        final boolean requiresBuild;
        final IWorkbenchPart part;
        final IFile[] files;
        final Map description;

        public SaveLaterJob(boolean requiresBuild, IWorkbenchPart part, Map descriptionMap, IFile[] files) {
            super(ResourceHandler.DirtyEditorUtilImpl_0);
            this.requiresBuild = requiresBuild;
            this.part = part;
            this.files = files;
            this.description = descriptionMap;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IWorkbenchPart myPart = this.part;
            if (myPart == null) {
                myPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            }
            boolean r = ((DirtyEditorUtilImpl)DirtyEditorUtilImpl.create()).saveAllDirtyEditor(this.files, myPart, this.description);
            if (this.requiresBuild && r) {
                new GlobalBuildAction(myPart.getSite().getWorkbenchWindow(), 10).doBuild();
            }
            return Status.OK_STATUS;
        }
    }
}

