/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class VirtualComponentMap {
    private final HashMap map;

    public VirtualComponentMap() {
        this.map = new HashMap();
    }

    public VirtualComponentMap(int capacity) {
        this.map = new HashMap(capacity);
    }

    public Object get(IVirtualComponent component) {
        return this.map.get(new Key(component));
    }

    public Object put(IVirtualComponent component, Object value) {
        return this.map.put(new Key(component), value);
    }

    public Object remove(IVirtualComponent component) {
        return this.map.remove(new Key(component));
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set keySet() {
        HashSet<IVirtualComponent> result = new HashSet<IVirtualComponent>();
        for (Key key : this.map.keySet()) {
            result.add(key.component);
        }
        return Collections.unmodifiableSet(result);
    }

    public Collection values() {
        return this.map.values();
    }

    public boolean containsKey(IVirtualComponent e) {
        return this.map.containsKey(new Key(e));
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VirtualComponentMap)) {
            return false;
        }
        return this.map.equals(((VirtualComponentMap)obj).map);
    }

    protected static class Key {
        final IVirtualComponent component;

        Key(IVirtualComponent component) {
            this.component = component;
        }

        public int hashCode() {
            return WebComponentUtil.encodeComponentToText(this.component, false).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            return this.component.equals(((Key)obj).component);
        }
    }
}

