/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.siteedit.internal.builder.util;

import com.ibm.etools.siteedit.core.SiteCorePlugin;
import com.ibm.etools.siteedit.internal.builder.SiteNavBuilderLogger;
import com.ibm.etools.siteedit.internal.builder.SiteNavConstants;
import com.ibm.etools.siteedit.internal.core.util.WebComponentUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public final class SpeculativeBuildUtil
implements SiteNavConstants {
    public static void createMarker(IFile file) {
        try {
            file.createMarker("com.ibm.etools.siteedit.SiteNavBuilder.speculativeNavMarker");
        }
        catch (CoreException e1) {
            SiteNavBuilderLogger.log(e1);
        }
    }

    public static void removeMarker(IFile file) {
        try {
            IMarker[] markers = file.findMarkers("com.ibm.etools.siteedit.SiteNavBuilder.speculativeNavMarker", false, 0);
            int i = 0;
            while (i < markers.length) {
                markers[i].delete();
                ++i;
            }
        }
        catch (CoreException e) {
            SiteNavBuilderLogger.log(e);
        }
    }

    public static void rollbackSpeculativeNavBarGeneration(IVirtualComponent component) {
        try {
            IContainer componentRoot = WebComponentUtil.getComponentRootFolder(component);
            if (componentRoot == null) {
                return;
            }
            IMarker[] markers = componentRoot.findMarkers("com.ibm.etools.siteedit.SiteNavBuilder.speculativeNavMarker", false, 2);
            final IResource[] res = new IResource[markers.length];
            int count = 0;
            int i = 0;
            while (i < markers.length) {
                try {
                    markers[i].delete();
                    res[i] = markers[i].getResource();
                    ++count;
                }
                catch (CoreException coreException) {}
                ++i;
            }
            if (count > 0) {
                try {
                    SiteCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().run(true, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                            int i = 0;
                            while (i < res.length) {
                                res[i].touch(monitor);
                                ++i;
                            }
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (CoreException e) {
            SiteNavBuilderLogger.log(e);
        }
    }
}

